/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer.valuewriter;

import com.google.common.base.Preconditions;
import io.trino.parquet.writer.valuewriter.PrimitiveValueWriter;
import io.trino.spi.block.Block;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Type;
import java.util.Objects;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.schema.PrimitiveType;

public class Int64ShortDecimalValueWriter
extends PrimitiveValueWriter {
    private final DecimalType decimalType;

    public Int64ShortDecimalValueWriter(ValuesWriter valuesWriter, Type type, PrimitiveType parquetType) {
        super(parquetType, valuesWriter);
        this.decimalType = (DecimalType)Objects.requireNonNull(type, "type is null");
        Preconditions.checkArgument((boolean)this.decimalType.isShort(), (Object)"type is not a short decimal");
    }

    @Override
    public void write(Block block) {
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) continue;
            long value = this.decimalType.getLong(block, i);
            this.getValueWriter().writeLong(value);
            this.getStatistics().updateStats(value);
        }
    }
}

