/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy;

import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.LazyObject;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.io.Text;
import com.linkedin.coral.$internal.org.apache.hadoop.io.Writable;
import java.nio.charset.CharacterCodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LazyPrimitive<OI extends ObjectInspector, T extends Writable>
extends LazyObject<OI> {
    private static final Logger LOG = LoggerFactory.getLogger(LazyPrimitive.class);
    protected T data;

    protected LazyPrimitive(OI oi) {
        super(oi);
    }

    protected LazyPrimitive(LazyPrimitive<OI, T> copy) {
        super(copy.oi);
        this.isNull = copy.isNull;
    }

    public T getWritableObject() {
        return this.isNull ? null : (T)this.data;
    }

    public String toString() {
        return this.isNull ? null : this.data.toString();
    }

    @Override
    public int hashCode() {
        return this.isNull ? 0 : this.data.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LazyPrimitive)) {
            return false;
        }
        if (this.data == obj) {
            return true;
        }
        if (this.data == null || obj == null) {
            return false;
        }
        return this.data.equals(((LazyPrimitive)obj).getWritableObject());
    }

    public void logExceptionMessage(ByteArrayRef bytes, int start, int length, String dataType) {
        try {
            if (LOG.isDebugEnabled()) {
                String byteData = Text.decode(bytes.getData(), start, length);
                LOG.debug("Data not in the " + dataType + " data type range so converted to null. Given data is :" + byteData, (Throwable)new Exception("For debugging purposes"));
            }
        }
        catch (CharacterCodingException e1) {
            LOG.debug("Data not in the " + dataType + " data type range so converted to null.", (Throwable)e1);
        }
    }
}

