/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.fast;

import java.nio.charset.StandardCharsets;

public class StringToDouble {
    static final int maxExponent = 511;
    static final double[] powersOf10 = new double[]{10.0, 100.0, 10000.0, 1.0E8, 1.0E16, 1.0E32, 1.0E64, 1.0E128, 1.0E256};

    static double strtod(String s2) {
        byte[] utf8 = s2.getBytes(StandardCharsets.UTF_8);
        return StringToDouble.strtod(utf8, 0, utf8.length);
    }

    public static double strtod(byte[] utf8, int offset, int length) {
        byte c;
        int mantSize;
        int p;
        if (length == 0) {
            throw new NumberFormatException();
        }
        boolean signIsNegative = true;
        boolean expSignIsNegative = true;
        int end = offset + length;
        int exp = 0;
        int fracExp = 0;
        for (p = offset; p < end && Character.isWhitespace(utf8[p]); ++p) {
        }
        while (end > p && Character.isWhitespace(utf8[end - 1])) {
            --end;
        }
        if (!StringToDouble.testSimpleDecimal(utf8, p, end - p)) {
            return Double.parseDouble(new String(utf8, p, end - p, StandardCharsets.UTF_8));
        }
        if (utf8[p] == 45) {
            signIsNegative = true;
            ++p;
        } else {
            if (utf8[p] == 43) {
                ++p;
            }
            signIsNegative = false;
        }
        int decPt = -1;
        int mantEnd = end - p;
        for (mantSize = 0; mantSize < mantEnd; ++mantSize) {
            c = utf8[p];
            if (!StringToDouble.isdigit(c)) {
                if (c != 46 || decPt >= 0) break;
                decPt = mantSize;
            }
            ++p;
        }
        int pExp = p;
        p -= mantSize;
        if (decPt < 0) {
            decPt = mantSize;
        } else {
            --mantSize;
        }
        if (mantSize > 18) {
            fracExp = decPt - 18;
            mantSize = 18;
        } else {
            fracExp = decPt - mantSize;
        }
        if (mantSize == 0) {
            if (signIsNegative) {
                return -0.0;
            }
            return 0.0;
        }
        double frac1 = 0.0;
        while (mantSize > 9) {
            c = utf8[p];
            ++p;
            if (c == 46) {
                c = utf8[p];
                ++p;
            }
            frac1 = 10.0 * frac1 + (double)(c - 48);
            --mantSize;
        }
        double frac2 = 0.0;
        while (mantSize > 0) {
            c = utf8[p];
            ++p;
            if (c == 46) {
                c = utf8[p];
                ++p;
            }
            frac2 = 10.0 * frac2 + (double)(c - 48);
            --mantSize;
        }
        double fraction = 1.0E9 * frac1 + frac2;
        p = pExp;
        if (p < end && (utf8[p] == 69 || utf8[p] == 101) && ++p < end) {
            if (utf8[p] == 45) {
                expSignIsNegative = true;
                ++p;
            } else {
                if (utf8[p] == 43) {
                    ++p;
                }
                expSignIsNegative = false;
            }
            while (p < end && StringToDouble.isdigit(utf8[p])) {
                exp = exp * 10 + (utf8[p] - 48);
                ++p;
            }
        }
        if ((exp = expSignIsNegative ? fracExp - exp : fracExp + exp) < 0) {
            expSignIsNegative = true;
            exp = -exp;
        } else {
            expSignIsNegative = false;
        }
        if (exp > 511) {
            exp = 511;
        }
        double dblExp = 1.0;
        int d = 0;
        while (exp != 0) {
            if ((exp & 1) == 1) {
                dblExp *= powersOf10[d];
            }
            exp >>= 1;
            ++d;
        }
        fraction = expSignIsNegative ? (fraction /= dblExp) : (fraction *= dblExp);
        if (signIsNegative) {
            return -fraction;
        }
        return fraction;
    }

    private static boolean testSimpleDecimal(byte[] utf8, int off, int len) {
        if (len > 18) {
            return false;
        }
        int decimalPts = 0;
        int signs = 0;
        int nondigits = 0;
        int digits = 0;
        for (int i = off; i < len + off; ++i) {
            byte c = utf8[i];
            if (c == 46) {
                ++decimalPts;
                continue;
            }
            if (c == 45 || c == 43) {
                ++signs;
                continue;
            }
            if (!StringToDouble.isdigit(c)) {
                ++nondigits;
                continue;
            }
            ++digits;
        }
        return decimalPts <= 1 && signs <= 1 && nondigits == 0 && digits < 16;
    }

    private static boolean isdigit(int c) {
        return 48 <= c && c <= 57;
    }
}

