/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.transformers;

import com.linkedin.coral.calcite.$internal.com.google.common.collect.ImmutableList;
import com.linkedin.coral.calcite.$internal.com.google.common.collect.ImmutableMap;
import com.linkedin.coral.common.functions.CoralSqlUnnestOperator;
import com.linkedin.coral.common.functions.FunctionFieldReferenceOperator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.calcite.config.NullCollation;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Uncollect;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import org.apache.calcite.rel.rel2sql.RelToSqlConverter;
import org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLateralOperator;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;

public class CoralRelToSqlNodeConverter
extends RelToSqlConverter {
    public static final SqlDialect INSTANCE = CoralRelToSqlNodeConverter.returnInstance();

    public CoralRelToSqlNodeConverter() {
        super(INSTANCE);
    }

    public SqlNode convert(RelNode coralRelNode) {
        return this.visitChild(0, coralRelNode).asStatement();
    }

    private static SqlDialect returnInstance() {
        SqlDialect.Context context = SqlDialect.EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.HIVE).withNullCollation(NullCollation.HIGH);
        return new SqlDialect(context){

            @Override
            public boolean requireCastOnString() {
                return true;
            }

            @Override
            public boolean hasImplicitTableAlias() {
                return false;
            }
        };
    }

    @Override
    public SqlImplementor.Result visit(TableScan e) {
        List<String> qualifiedName = e.getTable().getQualifiedName();
        if (qualifiedName.size() > 2) {
            qualifiedName = qualifiedName.subList(qualifiedName.size() - 2, qualifiedName.size());
        }
        SqlIdentifier identifier = new SqlIdentifier(qualifiedName, SqlParserPos.ZERO);
        return this.result(identifier, ImmutableList.of(SqlImplementor.Clause.FROM), e, null);
    }

    @Override
    public SqlImplementor.Result visit(Correlate e) {
        SqlImplementor.Result leftResult = this.visitChild(0, e.getLeft()).resetAlias();
        this.correlTableMap.put(e.getCorrelationId(), leftResult.qualifiedContext());
        SqlImplementor.Result rightResult = this.visitChild(1, e.getRight()).resetAlias();
        SqlNode rightSqlNode = rightResult.asFrom();
        if (e.getRight() instanceof LogicalTableFunctionScan || e.getRight() instanceof Uncollect) {
            rightSqlNode = this.generateRightChildForSqlJoinWithLateralViews(e, rightResult);
        }
        SqlJoin join = new SqlJoin(POS, leftResult.asFrom(), SqlLiteral.createBoolean(false, POS), JoinType.COMMA.symbol(POS), rightSqlNode, JoinConditionType.NONE.symbol(POS), null);
        return this.result(join, leftResult, rightResult);
    }

    public SqlImplementor.Result visit(LogicalTableFunctionScan e) {
        RexCall call = (RexCall)e.getCall();
        SqlOperator functionOperator = call.getOperator();
        ArrayList<SqlNode> functionOperands = new ArrayList<SqlNode>();
        for (RexNode rexOperand : call.getOperands()) {
            RexFieldAccess rexFieldAccess = (RexFieldAccess)rexOperand;
            RexCorrelVariable rexCorrelVariable = (RexCorrelVariable)rexFieldAccess.getReferenceExpr();
            SqlNode sqlNodeOperand = ((SqlImplementor.Context)this.correlTableMap.get(rexCorrelVariable.id)).toSql(null, rexOperand);
            functionOperands.add(sqlNodeOperand);
        }
        SqlCall functionSqlCall = functionOperator.createCall(POS, functionOperands.toArray(new SqlNode[0]));
        SqlCall tableCall = new SqlLateralOperator(SqlKind.COLLECTION_TABLE).createCall(POS, functionSqlCall);
        SqlImplementor.Result tableCallResultWithAlias = this.result(tableCall, ImmutableList.of(SqlImplementor.Clause.FROM), e, null);
        return new SqlImplementor.Result(this, tableCall, ImmutableList.of(SqlImplementor.Clause.FROM), null, e.getRowType(), ImmutableMap.of(tableCallResultWithAlias.neededAlias, e.getRowType()));
    }

    @Override
    public SqlImplementor.Result visit(Join e) {
        SqlImplementor.Result leftResult = this.visitChild(0, e.getLeft()).resetAlias();
        SqlImplementor.Result rightResult = this.visitChild(1, e.getRight()).resetAlias();
        SqlImplementor.Context leftContext = leftResult.qualifiedContext();
        SqlImplementor.Context rightContext = rightResult.qualifiedContext();
        SqlNode sqlCondition = null;
        SqlLiteral condType = JoinConditionType.ON.symbol(POS);
        JoinType joinType = CoralRelToSqlNodeConverter.joinType(e.getJoinType());
        if (e.getJoinType() == JoinRelType.INNER && e.getCondition().isAlwaysTrue()) {
            joinType = this.dialect.emulateJoinTypeForCrossJoin();
            condType = JoinConditionType.NONE.symbol(POS);
        } else {
            sqlCondition = this.convertConditionToSqlNode(e.getCondition(), leftContext, rightContext, e.getLeft().getRowType().getFieldCount());
        }
        SqlNode rightSqlNode = rightResult.asFrom();
        if (e.getRight() instanceof LogicalTableFunctionScan || e.getRight() instanceof Uncollect) {
            rightSqlNode = this.generateRightChildForSqlJoinWithLateralViews(e, rightResult);
        }
        SqlJoin join = new SqlJoin(POS, leftResult.asFrom(), SqlLiteral.createBoolean(false, POS), joinType.symbol(POS), rightSqlNode, condType, sqlCondition);
        return this.result(join, leftResult, rightResult);
    }

    @Override
    public SqlImplementor.Result visit(Uncollect e) {
        SqlImplementor.Result projectResult = this.visitChild(0, e.getInput());
        ArrayList<SqlNode> unnestOperands = new ArrayList<SqlNode>();
        RelDataType recordType = null;
        boolean withOrdinality = e.withOrdinality;
        for (RexNode unnestCol : ((Project)e.getInput()).getChildExps()) {
            unnestOperands.add(projectResult.qualifiedContext().toSql(null, unnestCol));
            if (!unnestCol.getType().getSqlTypeName().equals((Object)SqlTypeName.ARRAY) || !unnestCol.getType().getComponentType().getSqlTypeName().equals((Object)SqlTypeName.ROW)) continue;
            recordType = unnestCol.getType().getComponentType();
        }
        SqlCall unnestCall = new CoralSqlUnnestOperator(withOrdinality, recordType).createCall(POS, unnestOperands.toArray(new SqlNode[0]));
        return new SqlImplementor.Result(this, unnestCall, ImmutableList.of(SqlImplementor.Clause.FROM), null, e.getRowType(), ImmutableMap.of(projectResult.neededAlias, e.getRowType()));
    }

    @Override
    public SqlImplementor.Result visit(Values e) {
        SqlImplementor.Result originalResult = super.visit(e);
        return new SqlImplementor.Result(this, originalResult.node, originalResult.clauses, null, originalResult.neededType, originalResult.aliases);
    }

    private SqlNode generateRightChildForSqlJoinWithLateralViews(BiRel e, SqlImplementor.Result rightResult) {
        SqlNode rightSqlNode = rightResult.asFrom();
        SqlCall rightLateral = SqlStdOperatorTable.LATERAL.createCall(POS, rightSqlNode);
        RelDataType relDataType = e.getRight().getRowType();
        String alias = rightResult.aliases.entrySet().stream().filter(entry -> relDataType.equals(entry.getValue())).findFirst().map(Map.Entry::getKey).orElse("coralDefaultColumnAlias");
        List<SqlNode> asOperands = this.createAsFullOperands(relDataType, rightLateral, alias);
        return SqlStdOperatorTable.AS.createCall(POS, asOperands);
    }

    @Override
    public SqlImplementor.Context aliasContext(Map<String, RelDataType> aliases, boolean qualified) {
        return new SqlImplementor.AliasContext(INSTANCE, aliases, qualified){

            @Override
            public SqlNode toSql(RexProgram program, RexNode rex) {
                if (rex.getKind() == SqlKind.FIELD_ACCESS) {
                    ArrayList<String> accessNames = new ArrayList<String>();
                    RexNode referencedExpr = rex;
                    while (referencedExpr.getKind() == SqlKind.FIELD_ACCESS) {
                        accessNames.add(((RexFieldAccess)referencedExpr).getField().getName());
                        referencedExpr = ((RexFieldAccess)referencedExpr).getReferenceExpr();
                    }
                    SqlKind sqlKind = referencedExpr.getKind();
                    if (sqlKind == SqlKind.OTHER_FUNCTION || sqlKind == SqlKind.CAST || sqlKind == SqlKind.ROW) {
                        SqlNode functionCall = this.toSql(program, referencedExpr);
                        Collections.reverse(accessNames);
                        for (String accessName : accessNames) {
                            functionCall = FunctionFieldReferenceOperator.DOT.createCall(SqlParserPos.ZERO, functionCall, new SqlIdentifier(accessName, SqlImplementor.POS));
                        }
                        return functionCall;
                    }
                }
                return super.toSql(program, rex);
            }
        };
    }
}

