/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.rel2trino;

import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlArrayTypeSpec;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlMapTypeSpec;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlRowTypeSpec;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.SqlShuttle;

public class TrinoSqlRewriter
extends SqlShuttle {
    private static SqlDataTypeSpec convertTypeSpec(SqlDataTypeSpec type) {
        if (type instanceof SqlArrayTypeSpec) {
            SqlArrayTypeSpec arrayType = (SqlArrayTypeSpec)type;
            return new SqlArrayTypeSpec(TrinoSqlRewriter.convertTypeSpec(arrayType.getElementTypeSpec()), arrayType.getParserPosition());
        }
        if (type instanceof SqlMapTypeSpec) {
            SqlMapTypeSpec mapType = (SqlMapTypeSpec)type;
            return new SqlMapTypeSpec(TrinoSqlRewriter.convertTypeSpec(mapType.getKeyTypeSpec()), TrinoSqlRewriter.convertTypeSpec(mapType.getValueTypeSpec()), mapType.getParserPosition());
        }
        if (type instanceof SqlRowTypeSpec) {
            SqlRowTypeSpec rowType = (SqlRowTypeSpec)type;
            return new SqlRowTypeSpec(rowType.getFieldNames(), rowType.getFieldTypeSpecs().stream().map(TrinoSqlRewriter::convertTypeSpec).collect(Collectors.toList()), rowType.getParserPosition());
        }
        assert (type.getTypeNameSpec() instanceof SqlBasicTypeNameSpec);
        SqlBasicTypeNameSpec typeNameSpec = (SqlBasicTypeNameSpec)type.getTypeNameSpec();
        int precision = typeNameSpec.getPrecision();
        int scale = typeNameSpec.getScale();
        String charSetName = typeNameSpec.getCharSetName();
        TimeZone timeZone = type.getTimeZone();
        SqlParserPos parserPos = type.getParserPosition();
        switch (typeNameSpec.getTypeName().toString()) {
            case "BINARY": 
            case "VARBINARY": {
                SqlBasicTypeNameSpec binaryTypeName = new SqlBasicTypeNameSpec(SqlTypeName.VARBINARY, -1, -1, charSetName, parserPos);
                return new SqlDataTypeSpec(binaryTypeName, timeZone, parserPos);
            }
            case "FLOAT": {
                SqlBasicTypeNameSpec realTypeName = new SqlBasicTypeNameSpec(SqlTypeName.REAL, precision, scale, charSetName, parserPos);
                return new SqlDataTypeSpec(realTypeName, timeZone, parserPos);
            }
        }
        return type;
    }

    @Override
    public SqlNode visit(SqlDataTypeSpec type) {
        return TrinoSqlRewriter.convertTypeSpec(type);
    }
}

