/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import com.linkedin.coral.calcite.$internal.com.google.common.base.Preconditions;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.util.DateTimeStringUtils;
import org.apache.calcite.util.TimeString;

public class TimeWithTimeZoneString
implements Comparable<TimeWithTimeZoneString> {
    final TimeString localTime;
    final TimeZone timeZone;
    final String v;

    public TimeWithTimeZoneString(TimeString localTime, TimeZone timeZone) {
        this.localTime = localTime;
        this.timeZone = timeZone;
        this.v = localTime.toString() + " " + timeZone.getID();
    }

    public TimeWithTimeZoneString(String v) {
        this.localTime = new TimeString(v.substring(0, 8));
        String timeZoneString = v.substring(9);
        Preconditions.checkArgument(DateTimeStringUtils.isValidTimeZone(timeZoneString));
        this.timeZone = TimeZone.getTimeZone(timeZoneString);
        this.v = v;
    }

    public TimeWithTimeZoneString(int h2, int m3, int s2, String timeZone) {
        this(DateTimeStringUtils.hms(new StringBuilder(), h2, m3, s2).toString() + " " + timeZone);
    }

    public TimeWithTimeZoneString withMillis(int millis) {
        Preconditions.checkArgument(millis >= 0 && millis < 1000);
        return this.withFraction(DateTimeStringUtils.pad(3, millis));
    }

    public TimeWithTimeZoneString withNanos(int nanos) {
        Preconditions.checkArgument(nanos >= 0 && nanos < 1000000000);
        return this.withFraction(DateTimeStringUtils.pad(9, nanos));
    }

    public TimeWithTimeZoneString withFraction(String fraction) {
        String v = this.v;
        int i = v.indexOf(46);
        v = i >= 0 ? v.substring(0, i) : v.substring(0, 8);
        while (fraction.endsWith("0")) {
            fraction = fraction.substring(0, fraction.length() - 1);
        }
        if (fraction.length() > 0) {
            v = v + "." + fraction;
        }
        v = v + this.v.substring(8);
        return new TimeWithTimeZoneString(v);
    }

    public TimeWithTimeZoneString withTimeZone(TimeZone timeZone) {
        String fraction;
        String v;
        if (this.timeZone.equals(timeZone)) {
            return this;
        }
        String localTimeString = this.localTime.toString();
        int i = localTimeString.indexOf(46);
        if (i >= 0) {
            v = localTimeString.substring(0, i);
            fraction = localTimeString.substring(i + 1);
        } else {
            v = localTimeString;
            fraction = null;
        }
        DateTimeUtils.PrecisionTime pt = DateTimeUtils.parsePrecisionDateTimeLiteral(v, new SimpleDateFormat("HH:mm:ss", Locale.ROOT), this.timeZone, -1);
        pt.getCalendar().setTimeZone(timeZone);
        if (fraction != null) {
            return new TimeWithTimeZoneString(pt.getCalendar().get(11), pt.getCalendar().get(12), pt.getCalendar().get(13), timeZone.getID()).withFraction(fraction);
        }
        return new TimeWithTimeZoneString(pt.getCalendar().get(11), pt.getCalendar().get(12), pt.getCalendar().get(13), timeZone.getID());
    }

    public String toString() {
        return this.v;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof TimeWithTimeZoneString && ((TimeWithTimeZoneString)o).v.equals(this.v);
    }

    public int hashCode() {
        return this.v.hashCode();
    }

    @Override
    public int compareTo(TimeWithTimeZoneString o) {
        return this.v.compareTo(o.v);
    }

    public TimeWithTimeZoneString round(int precision) {
        Preconditions.checkArgument(precision >= 0);
        return new TimeWithTimeZoneString(this.localTime.round(precision), this.timeZone);
    }

    public static TimeWithTimeZoneString fromMillisOfDay(int i) {
        return new TimeWithTimeZoneString(DateTimeUtils.unixTimeToString(i) + " " + DateTimeUtils.UTC_ZONE.getID()).withMillis((int)DateTimeUtils.floorMod(i, 1000L));
    }

    public String toString(int precision) {
        Preconditions.checkArgument(precision >= 0);
        return this.localTime.toString(precision) + " " + this.timeZone.getID();
    }

    public TimeString getLocalTimeString() {
        return this.localTime;
    }
}

