/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.http;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.ForwardedHeaderParser;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpRouteHolder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.net.internal.InternalNetServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.instrumentation.api.internal.SpanKey;
import io.opentelemetry.instrumentation.api.internal.SpanKeyProvider;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class HttpServerAttributesExtractor<REQUEST, RESPONSE>
extends HttpCommonAttributesExtractor<REQUEST, RESPONSE, HttpServerAttributesGetter<REQUEST, RESPONSE>>
implements SpanKeyProvider {
    private final InternalNetServerAttributesExtractor<REQUEST> internalNetExtractor;
    private final Function<Context, String> httpRouteHolderGetter;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(HttpServerAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter, NetServerAttributesGetter<REQUEST> netAttributesGetter) {
        return HttpServerAttributesExtractor.builder(httpAttributesGetter, netAttributesGetter).build();
    }

    public static <REQUEST, RESPONSE> HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> builder(HttpServerAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter, NetServerAttributesGetter<REQUEST> netAttributesGetter) {
        return new HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE>(httpAttributesGetter, netAttributesGetter);
    }

    HttpServerAttributesExtractor(HttpServerAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter, NetServerAttributesGetter<REQUEST> netAttributesGetter, List<String> capturedRequestHeaders, List<String> capturedResponseHeaders) {
        this(httpAttributesGetter, netAttributesGetter, capturedRequestHeaders, capturedResponseHeaders, HttpRouteHolder::getRoute);
    }

    HttpServerAttributesExtractor(HttpServerAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter, NetServerAttributesGetter<REQUEST> netAttributesGetter, List<String> capturedRequestHeaders, List<String> capturedResponseHeaders, Function<Context, String> httpRouteHolderGetter) {
        super(httpAttributesGetter, capturedRequestHeaders, capturedResponseHeaders);
        this.internalNetExtractor = new InternalNetServerAttributesExtractor<Object>(netAttributesGetter, this::shouldCaptureHostPort, new HttpCommonAttributesExtractor.HttpNetNamePortGetter<REQUEST>(httpAttributesGetter));
        this.httpRouteHolderGetter = httpRouteHolderGetter;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        super.onStart(attributes, parentContext, request);
        String forwardedProto = this.forwardedProto(request);
        String value = forwardedProto != null ? forwardedProto : ((HttpServerAttributesGetter)this.getter).getScheme(request);
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_SCHEME, (Object)value);
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_TARGET, (Object)((HttpServerAttributesGetter)this.getter).getTarget(request));
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_ROUTE, (Object)((HttpServerAttributesGetter)this.getter).getRoute(request));
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_CLIENT_IP, (Object)this.clientIp(request));
        this.internalNetExtractor.onStart(attributes, request);
    }

    private boolean shouldCaptureHostPort(int port, REQUEST request) {
        String scheme = ((HttpServerAttributesGetter)this.getter).getScheme(request);
        if (scheme == null) {
            return true;
        }
        return (!scheme.equals("http") || port != 80) && (!scheme.equals("https") || port != 443);
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        super.onEnd(attributes, context, request, response, error);
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_ROUTE, (Object)this.httpRouteHolderGetter.apply(context));
    }

    @Nullable
    private String forwardedProto(REQUEST request) {
        String forwarded = HttpServerAttributesExtractor.firstHeaderValue(((HttpServerAttributesGetter)this.getter).getRequestHeader(request, "forwarded"));
        if (forwarded != null && (forwarded = ForwardedHeaderParser.extractProtoFromForwardedHeader(forwarded)) != null) {
            return forwarded;
        }
        forwarded = HttpServerAttributesExtractor.firstHeaderValue(((HttpServerAttributesGetter)this.getter).getRequestHeader(request, "x-forwarded-proto"));
        if (forwarded != null) {
            return ForwardedHeaderParser.extractProtoFromForwardedProtoHeader(forwarded);
        }
        return null;
    }

    @Nullable
    private String clientIp(REQUEST request) {
        String forwarded = HttpServerAttributesExtractor.firstHeaderValue(((HttpServerAttributesGetter)this.getter).getRequestHeader(request, "forwarded"));
        if (forwarded != null && (forwarded = ForwardedHeaderParser.extractClientIpFromForwardedHeader(forwarded)) != null) {
            return forwarded;
        }
        forwarded = HttpServerAttributesExtractor.firstHeaderValue(((HttpServerAttributesGetter)this.getter).getRequestHeader(request, "x-forwarded-for"));
        if (forwarded != null) {
            return ForwardedHeaderParser.extractClientIpFromForwardedForHeader(forwarded);
        }
        return null;
    }

    public SpanKey internalGetSpanKey() {
        return SpanKey.HTTP_SERVER;
    }
}

