/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.delete;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.math.IntMath;
import com.google.common.primitives.SignedBytes;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class Base85Codec {
    @VisibleForTesting
    static final int BASE = 85;
    @VisibleForTesting
    static final int BASE_2ND_POWER = IntMath.pow((int)85, (int)2);
    @VisibleForTesting
    static final int BASE_3RD_POWER = IntMath.pow((int)85, (int)3);
    @VisibleForTesting
    static final int BASE_4TH_POWER = IntMath.pow((int)85, (int)4);
    private static final int ASCII_BITMASK = 127;
    static final int ENCODED_UUID_LENGTH = 20;
    private static final String BASE85_CHARACTERS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ.-:+=^!/*?&<>()[]{}@%$#";
    @VisibleForTesting
    static final byte[] ENCODE_MAP = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ.-:+=^!/*?&<>()[]{}@%$#".getBytes(StandardCharsets.UTF_8);
    static final byte[] DECODE_MAP = new byte[128];

    private Base85Codec() {
    }

    public static byte[] decode(String encoded) {
        Preconditions.checkArgument((encoded.length() % 5 == 0 ? 1 : 0) != 0, (Object)"Input should be 5 character aligned");
        byte[] buffer = new byte[encoded.length() / 5 * 4];
        int outputIndex = 0;
        for (int inputIndex = 0; inputIndex < encoded.length(); inputIndex += 5) {
            int word = 0;
            word += Base85Codec.decodeInputChar(encoded.charAt(inputIndex)) * BASE_4TH_POWER;
            word += Base85Codec.decodeInputChar(encoded.charAt(inputIndex + 1)) * BASE_3RD_POWER;
            word += Base85Codec.decodeInputChar(encoded.charAt(inputIndex + 2)) * BASE_2ND_POWER;
            word += Base85Codec.decodeInputChar(encoded.charAt(inputIndex + 3)) * 85;
            buffer[outputIndex] = (byte)((word += Base85Codec.decodeInputChar(encoded.charAt(inputIndex + 4))) >> 24);
            buffer[outputIndex + 1] = (byte)(word >> 16);
            buffer[outputIndex + 2] = (byte)(word >> 8);
            buffer[outputIndex + 3] = (byte)word;
            outputIndex += 4;
        }
        Preconditions.checkState((outputIndex == buffer.length ? 1 : 0) != 0);
        return buffer;
    }

    private static int decodeInputChar(char input) {
        Preconditions.checkArgument((input == (input & 0x7F) ? 1 : 0) != 0, (String)"Input character is not ASCII: [%s]", (char)input);
        byte decoded = DECODE_MAP[input & 0x7F];
        Preconditions.checkArgument((decoded != -1 ? 1 : 0) != 0, (String)"Invalid input character: [%s]", (char)input);
        return decoded;
    }

    static {
        Arrays.fill(DECODE_MAP, (byte)-1);
        for (int i = 0; i < ENCODE_MAP.length; ++i) {
            Base85Codec.DECODE_MAP[Base85Codec.ENCODE_MAP[i]] = SignedBytes.checkedCast((long)i);
        }
    }
}

