/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.expression;

import com.google.common.base.MoreObjects;
import io.trino.plugin.deltalake.expression.SparkExpression;
import io.trino.plugin.deltalake.expression.SparkExpressionTreeVisitor;
import java.util.Objects;

public class ArithmeticBinaryExpression
extends SparkExpression {
    private final Operator operator;
    private final SparkExpression left;
    private final SparkExpression right;

    public ArithmeticBinaryExpression(Operator operator, SparkExpression left, SparkExpression right) {
        this.operator = Objects.requireNonNull(operator, "operator is null");
        this.left = Objects.requireNonNull(left, "left is null");
        this.right = Objects.requireNonNull(right, "right is null");
    }

    public Operator getOperator() {
        return this.operator;
    }

    public SparkExpression getLeft() {
        return this.left;
    }

    public SparkExpression getRight() {
        return this.right;
    }

    @Override
    <R, C> R accept(SparkExpressionTreeVisitor<R, C> visitor, C context) {
        return visitor.visitArithmeticBinary(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArithmeticBinaryExpression that = (ArithmeticBinaryExpression)o;
        return this.operator == that.operator && Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.left, this.right});
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("operator", (Object)this.operator).add("left", (Object)this.left).add("right", (Object)this.right).toString();
    }

    public static enum Operator {
        ADD("+"),
        SUBTRACT("-"),
        MULTIPLY("*"),
        DIVIDE("/"),
        MODULUS("%"),
        BITWISE_AND("&"),
        BITWISE_XOR("^");

        private final String value;

        private Operator(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

