/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.inject.Inject;
import io.airlift.jmx.CacheStatsMBean;
import io.airlift.log.Logger;
import io.airlift.slice.SizeOf;
import io.trino.cache.CacheUtils;
import io.trino.cache.EvictableCacheBuilder;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoInputFile;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.plugin.deltalake.DeltaLakeColumnMetadata;
import io.trino.plugin.deltalake.DeltaLakeConfig;
import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.transactionlog.AddFileEntry;
import io.trino.plugin.deltalake.transactionlog.CanonicalColumnName;
import io.trino.plugin.deltalake.transactionlog.CommitInfoEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeDataFileCacheEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.MissingTransactionLogException;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.deltalake.transactionlog.RemoveFileEntry;
import io.trino.plugin.deltalake.transactionlog.TableSnapshot;
import io.trino.plugin.deltalake.transactionlog.TransactionLogUtil;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointEntryIterator;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointSchemaManager;
import io.trino.plugin.deltalake.transactionlog.checkpoint.TransactionLogTail;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarbinaryType;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class TransactionLogAccess {
    private static final Logger log = Logger.get(TransactionLogAccess.class);
    private final TypeManager typeManager;
    private final CheckpointSchemaManager checkpointSchemaManager;
    private final FileFormatDataSourceStats fileFormatDataSourceStats;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final ParquetReaderOptions parquetReaderOptions;
    private final Cache<CacheKey, TableSnapshot> tableSnapshots;
    private final Cache<CacheKey, DeltaLakeDataFileCacheEntry> activeDataFileCache;
    private final boolean checkpointRowStatisticsWritingEnabled;
    private final int domainCompactionThreshold;

    @Inject
    public TransactionLogAccess(TypeManager typeManager, CheckpointSchemaManager checkpointSchemaManager, DeltaLakeConfig deltaLakeConfig, FileFormatDataSourceStats fileFormatDataSourceStats, TrinoFileSystemFactory fileSystemFactory, ParquetReaderConfig parquetReaderConfig) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.checkpointSchemaManager = Objects.requireNonNull(checkpointSchemaManager, "checkpointSchemaManager is null");
        this.fileFormatDataSourceStats = Objects.requireNonNull(fileFormatDataSourceStats, "fileFormatDataSourceStats is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.parquetReaderOptions = parquetReaderConfig.toParquetReaderOptions().withBloomFilter(false);
        this.checkpointRowStatisticsWritingEnabled = deltaLakeConfig.isCheckpointRowStatisticsWritingEnabled();
        this.domainCompactionThreshold = deltaLakeConfig.getDomainCompactionThreshold();
        this.tableSnapshots = EvictableCacheBuilder.newBuilder().expireAfterWrite(deltaLakeConfig.getMetadataCacheTtl().toMillis(), TimeUnit.MILLISECONDS).maximumSize(deltaLakeConfig.getMetadataCacheMaxSize()).shareNothingWhenDisabled().recordStats().build();
        this.activeDataFileCache = EvictableCacheBuilder.newBuilder().weigher((key, value) -> Ints.saturatedCast((long)(key.getRetainedSizeInBytes() + value.getRetainedSizeInBytes()))).maximumWeight(deltaLakeConfig.getDataFileCacheSize().toBytes()).expireAfterWrite(deltaLakeConfig.getDataFileCacheTtl().toMillis(), TimeUnit.MILLISECONDS).shareNothingWhenDisabled().recordStats().build();
    }

    @Managed
    @Nested
    public CacheStatsMBean getDataFileMetadataCacheStats() {
        return new CacheStatsMBean(this.activeDataFileCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getMetadataCacheStats() {
        return new CacheStatsMBean(this.tableSnapshots);
    }

    public TableSnapshot loadSnapshot(SchemaTableName table, String tableLocation, ConnectorSession session) throws IOException {
        TableSnapshot snapshot;
        CacheKey cacheKey = new CacheKey(table, tableLocation);
        TableSnapshot cachedSnapshot = (TableSnapshot)this.tableSnapshots.getIfPresent((Object)cacheKey);
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
        if (cachedSnapshot == null) {
            try {
                snapshot = (TableSnapshot)this.tableSnapshots.get((Object)cacheKey, () -> TableSnapshot.load(table, fileSystem, tableLocation, this.parquetReaderOptions, this.checkpointRowStatisticsWritingEnabled, this.domainCompactionThreshold));
            }
            catch (UncheckedExecutionException | ExecutionException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new RuntimeException(e);
            }
        } else {
            Optional<TableSnapshot> updatedSnapshot = cachedSnapshot.getUpdatedSnapshot(fileSystem);
            if (updatedSnapshot.isPresent()) {
                snapshot = updatedSnapshot.get();
                this.tableSnapshots.asMap().replace(cacheKey, cachedSnapshot, snapshot);
            } else {
                snapshot = cachedSnapshot;
            }
        }
        return snapshot;
    }

    public void flushCache() {
        this.tableSnapshots.invalidateAll();
        this.activeDataFileCache.invalidateAll();
    }

    public void invalidateCache(SchemaTableName schemaTableName, Optional<String> tableLocation) {
        Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        tableLocation.ifPresent(location -> {
            CacheUtils.invalidateAllIf(this.tableSnapshots, cacheKey -> cacheKey.location().equals(location));
            CacheUtils.invalidateAllIf(this.activeDataFileCache, cacheKey -> cacheKey.location().equals(location));
        });
        CacheUtils.invalidateAllIf(this.tableSnapshots, cacheKey -> cacheKey.tableName().equals((Object)schemaTableName));
        CacheUtils.invalidateAllIf(this.activeDataFileCache, cacheKey -> cacheKey.tableName().equals((Object)schemaTableName));
    }

    public MetadataEntry getMetadataEntry(TableSnapshot tableSnapshot, ConnectorSession session) {
        if (tableSnapshot.getCachedMetadata().isEmpty()) {
            try (Stream metadataEntries = this.getEntries(tableSnapshot, CheckpointEntryIterator.EntryType.METADATA, (Stream<DeltaLakeTransactionLogEntry> entryStream) -> entryStream.map(DeltaLakeTransactionLogEntry::getMetaData).filter(Objects::nonNull), session, this.fileSystemFactory.create(session), this.fileFormatDataSourceStats);){
                tableSnapshot.setCachedMetadata(metadataEntries.reduce((first, second) -> second));
            }
        }
        return tableSnapshot.getCachedMetadata().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Metadata not found in transaction log for " + tableSnapshot.getTable()));
    }

    public List<AddFileEntry> getActiveFiles(TableSnapshot tableSnapshot, ConnectorSession session) {
        try {
            CacheKey cacheKey = new CacheKey(tableSnapshot.getTable(), tableSnapshot.getTableLocation());
            DeltaLakeDataFileCacheEntry cachedTable = (DeltaLakeDataFileCacheEntry)this.activeDataFileCache.get((Object)cacheKey, () -> {
                List<AddFileEntry> activeFiles = this.loadActiveFiles(tableSnapshot, session);
                return new DeltaLakeDataFileCacheEntry(tableSnapshot.getVersion(), activeFiles);
            });
            if (cachedTable.getVersion() > tableSnapshot.getVersion()) {
                log.warn("Query run with outdated Transaction Log Snapshot, retrieved stale table entries for table: %s and query %s", new Object[]{tableSnapshot.getTable(), session.getQueryId()});
                return this.loadActiveFiles(tableSnapshot, session);
            }
            if (cachedTable.getVersion() < tableSnapshot.getVersion()) {
                DeltaLakeDataFileCacheEntry updatedCacheEntry;
                try {
                    List<DeltaLakeTransactionLogEntry> newEntries = TransactionLogAccess.getJsonEntries(cachedTable.getVersion(), tableSnapshot.getVersion(), tableSnapshot, this.fileSystemFactory.create(session));
                    updatedCacheEntry = cachedTable.withUpdatesApplied(newEntries, tableSnapshot.getVersion());
                }
                catch (MissingTransactionLogException e) {
                    List<AddFileEntry> activeFiles = this.loadActiveFiles(tableSnapshot, session);
                    updatedCacheEntry = new DeltaLakeDataFileCacheEntry(tableSnapshot.getVersion(), activeFiles);
                }
                this.activeDataFileCache.asMap().replace(cacheKey, cachedTable, updatedCacheEntry);
                cachedTable = updatedCacheEntry;
            }
            return cachedTable.getActiveFiles();
        }
        catch (UncheckedExecutionException | IOException | ExecutionException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Failed accessing transaction log for table: " + tableSnapshot.getTable(), e);
        }
    }

    private List<AddFileEntry> loadActiveFiles(TableSnapshot tableSnapshot, ConnectorSession session) {
        try (Stream entries = this.getEntries(tableSnapshot, (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)((Object)CheckpointEntryIterator.EntryType.ADD)), this::activeAddEntries, session, this.fileSystemFactory.create(session), this.fileFormatDataSourceStats);){
            List activeFiles;
            List list = activeFiles = (List)entries.collect(ImmutableList.toImmutableList());
            return list;
        }
    }

    public static List<DeltaLakeColumnMetadata> columnsWithStats(MetadataEntry metadataEntry, TypeManager typeManager) {
        return TransactionLogAccess.columnsWithStats(DeltaLakeSchemaSupport.extractSchema(metadataEntry, typeManager), metadataEntry.getOriginalPartitionColumns());
    }

    public static ImmutableList<DeltaLakeColumnMetadata> columnsWithStats(List<DeltaLakeColumnMetadata> schema, List<String> partitionColumns) {
        return (ImmutableList)schema.stream().filter(column -> !partitionColumns.contains(column.getName())).filter(column -> {
            Type type = column.getType();
            return !(type instanceof MapType) && !(type instanceof ArrayType) && !type.equals(BooleanType.BOOLEAN) && !type.equals(VarbinaryType.VARBINARY);
        }).collect(ImmutableList.toImmutableList());
    }

    private Stream<AddFileEntry> activeAddEntries(Stream<DeltaLakeTransactionLogEntry> checkpointEntries, Stream<DeltaLakeTransactionLogEntry> jsonEntries) {
        LinkedHashMap activeJsonEntries = new LinkedHashMap();
        HashSet removedFiles = new HashSet();
        jsonEntries.forEach(deltaLakeTransactionLogEntry -> {
            RemoveFileEntry removeEntry;
            AddFileEntry addEntry = deltaLakeTransactionLogEntry.getAdd();
            if (addEntry != null) {
                activeJsonEntries.put(addEntry.getPath(), addEntry);
            }
            if ((removeEntry = deltaLakeTransactionLogEntry.getRemove()) != null) {
                activeJsonEntries.remove(removeEntry.getPath());
                removedFiles.add(removeEntry.getPath());
            }
        });
        Stream<AddFileEntry> filteredCheckpointEntries = checkpointEntries.map(DeltaLakeTransactionLogEntry::getAdd).filter(Objects::nonNull).filter(addEntry -> !removedFiles.contains(addEntry.getPath()) && !activeJsonEntries.containsKey(addEntry.getPath()));
        return Stream.concat(filteredCheckpointEntries, activeJsonEntries.values().stream());
    }

    public Stream<RemoveFileEntry> getRemoveEntries(TableSnapshot tableSnapshot, ConnectorSession session) {
        return this.getEntries(tableSnapshot, CheckpointEntryIterator.EntryType.REMOVE, (Stream<DeltaLakeTransactionLogEntry> entryStream) -> entryStream.map(DeltaLakeTransactionLogEntry::getRemove).filter(Objects::nonNull), session, this.fileSystemFactory.create(session), this.fileFormatDataSourceStats);
    }

    public ProtocolEntry getProtocolEntry(ConnectorSession session, TableSnapshot tableSnapshot) {
        return this.getProtocolEntries(tableSnapshot, session).reduce((first, second) -> second).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Protocol entry not found in transaction log for table " + tableSnapshot.getTable()));
    }

    public Stream<ProtocolEntry> getProtocolEntries(TableSnapshot tableSnapshot, ConnectorSession session) {
        return this.getEntries(tableSnapshot, CheckpointEntryIterator.EntryType.PROTOCOL, (Stream<DeltaLakeTransactionLogEntry> entryStream) -> entryStream.map(DeltaLakeTransactionLogEntry::getProtocol).filter(Objects::nonNull), session, this.fileSystemFactory.create(session), this.fileFormatDataSourceStats);
    }

    public Stream<CommitInfoEntry> getCommitInfoEntries(TableSnapshot tableSnapshot, ConnectorSession session) {
        return this.getEntries(tableSnapshot, CheckpointEntryIterator.EntryType.COMMIT, (Stream<DeltaLakeTransactionLogEntry> entryStream) -> entryStream.map(DeltaLakeTransactionLogEntry::getCommitInfo).filter(Objects::nonNull), session, this.fileSystemFactory.create(session), this.fileFormatDataSourceStats);
    }

    private <T> Stream<T> getEntries(TableSnapshot tableSnapshot, Set<CheckpointEntryIterator.EntryType> entryTypes, BiFunction<Stream<DeltaLakeTransactionLogEntry>, Stream<DeltaLakeTransactionLogEntry>, Stream<T>> entryMapper, ConnectorSession session, TrinoFileSystem fileSystem, FileFormatDataSourceStats stats) {
        try {
            Stream jsonEntries = tableSnapshot.getJsonTransactionLogEntries().stream();
            Stream<DeltaLakeTransactionLogEntry> checkpointEntries = tableSnapshot.getCheckpointTransactionLogEntries(session, entryTypes, this.checkpointSchemaManager, this.typeManager, fileSystem, stats);
            return entryMapper.apply(checkpointEntries, jsonEntries);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Error reading transaction log for " + tableSnapshot.getTable(), (Throwable)e);
        }
    }

    private <T> Stream<T> getEntries(TableSnapshot tableSnapshot, CheckpointEntryIterator.EntryType entryType, Function<Stream<DeltaLakeTransactionLogEntry>, Stream<T>> entryMapper, ConnectorSession session, TrinoFileSystem fileSystem, FileFormatDataSourceStats stats) {
        return this.getEntries(tableSnapshot, (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)((Object)entryType)), (Stream<DeltaLakeTransactionLogEntry> checkpointStream, Stream<DeltaLakeTransactionLogEntry> jsonStream) -> (Stream)entryMapper.apply(Stream.concat(checkpointStream, jsonStream)), session, fileSystem, stats);
    }

    public Stream<DeltaLakeTransactionLogEntry> getJsonEntries(TrinoFileSystem fileSystem, String transactionLogDir, List<Long> forVersions) {
        return forVersions.stream().flatMap(version -> {
            try {
                Optional<List<DeltaLakeTransactionLogEntry>> entriesFromJson = TransactionLogTail.getEntriesFromJson(version, transactionLogDir, fileSystem);
                return entriesFromJson.map(Collection::stream).orElseGet(() -> Stream.of(new DeltaLakeTransactionLogEntry[0]));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public List<Long> getPastTableVersions(TrinoFileSystem fileSystem, String transactionLogDir, Instant startAt, long lastVersion) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (long version = lastVersion; version >= 0L; --version) {
            Location entryPath = TransactionLogUtil.getTransactionLogJsonEntryPath(transactionLogDir, version);
            TrinoInputFile inputFile = fileSystem.newInputFile(entryPath);
            try {
                if (inputFile.lastModified().isBefore(startAt)) {
                    break;
                }
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            result.add((Object)version);
        }
        return result.build();
    }

    private static List<DeltaLakeTransactionLogEntry> getJsonEntries(long startVersion, long endVersion, TableSnapshot tableSnapshot, TrinoFileSystem fileSystem) throws IOException {
        Optional<Long> lastCheckpointVersion = tableSnapshot.getLastCheckpointVersion();
        if (lastCheckpointVersion.isPresent() && startVersion < lastCheckpointVersion.get()) {
            return ImmutableList.builder().addAll(TransactionLogTail.loadNewTail(fileSystem, tableSnapshot.getTableLocation(), Optional.of(startVersion), lastCheckpointVersion).getFileEntries()).addAll(tableSnapshot.getJsonTransactionLogEntries()).build();
        }
        return TransactionLogTail.loadNewTail(fileSystem, tableSnapshot.getTableLocation(), Optional.of(startVersion), Optional.of(endVersion)).getFileEntries();
    }

    public static String canonicalizeColumnName(String columnName) {
        return columnName.toLowerCase(Locale.ENGLISH);
    }

    public static <T> Map<CanonicalColumnName, T> toCanonicalNameKeyedMap(Map<String, T> map) {
        return (Map)map.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> new CanonicalColumnName((String)entry.getKey()), Map.Entry::getValue));
    }

    public static <T> Map<CanonicalColumnName, T> toCanonicalNameKeyedMap(Map<String, T> map, Map<String, CanonicalColumnName> canonicalColumnNames) {
        return (Map)map.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> Objects.requireNonNull((CanonicalColumnName)canonicalColumnNames.get(entry.getKey()), String.format("Did not find CanonicalColumnName for %s", entry.getKey())), Map.Entry::getValue));
    }

    @Deprecated
    public static <T> Map<String, T> toOriginalNameKeyedMap(Map<CanonicalColumnName, T> map) {
        return (Map)map.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((CanonicalColumnName)entry.getKey()).getOriginalName(), Map.Entry::getValue));
    }

    private record CacheKey(SchemaTableName tableName, String location) {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(CacheKey.class);

        CacheKey {
            Objects.requireNonNull(tableName, "tableName is null");
            Objects.requireNonNull(location, "location is null");
        }

        long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + this.tableName.getRetainedSizeInBytes() + SizeOf.estimatedSizeOf((String)this.location);
        }
    }
}

