/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog.writer;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.airlift.json.ObjectMapperProvider;
import io.trino.filesystem.Location;
import io.trino.plugin.deltalake.transactionlog.AddFileEntry;
import io.trino.plugin.deltalake.transactionlog.CdcEntry;
import io.trino.plugin.deltalake.transactionlog.CommitInfoEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.deltalake.transactionlog.RemoveFileEntry;
import io.trino.plugin.deltalake.transactionlog.TransactionLogUtil;
import io.trino.plugin.deltalake.transactionlog.writer.TransactionLogSynchronizer;
import io.trino.spi.connector.ConnectorSession;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.parquet.Preconditions;

public class TransactionLogWriter {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperProvider().get();
    private Optional<DeltaLakeTransactionLogEntry> commitInfoEntry = Optional.empty();
    private final List<DeltaLakeTransactionLogEntry> entries = new ArrayList<DeltaLakeTransactionLogEntry>();
    private final TransactionLogSynchronizer logSynchronizer;
    private final ConnectorSession session;
    private final String tableLocation;

    public TransactionLogWriter(TransactionLogSynchronizer logSynchronizer, ConnectorSession session, String tableLocation) {
        this.logSynchronizer = Objects.requireNonNull(logSynchronizer, "logSynchronizer is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.tableLocation = Objects.requireNonNull(tableLocation, "tableLocation is null");
    }

    public void appendCommitInfoEntry(CommitInfoEntry commitInfoEntry) {
        Preconditions.checkState((boolean)this.commitInfoEntry.isEmpty(), (String)"commitInfo already set");
        this.commitInfoEntry = Optional.of(DeltaLakeTransactionLogEntry.commitInfoEntry(commitInfoEntry));
    }

    public void appendMetadataEntry(MetadataEntry metadataEntry) {
        this.entries.add(DeltaLakeTransactionLogEntry.metadataEntry(metadataEntry));
    }

    public void appendProtocolEntry(ProtocolEntry protocolEntry) {
        this.entries.add(DeltaLakeTransactionLogEntry.protocolEntry(protocolEntry));
    }

    public void appendAddFileEntry(AddFileEntry addFileEntry) {
        this.entries.add(DeltaLakeTransactionLogEntry.addFileEntry(addFileEntry));
    }

    public void appendRemoveFileEntry(RemoveFileEntry removeFileEntry) {
        this.entries.add(DeltaLakeTransactionLogEntry.removeFileEntry(removeFileEntry));
    }

    public void appendCdcEntry(CdcEntry cdcEntry) {
        this.entries.add(DeltaLakeTransactionLogEntry.cdcEntry(cdcEntry));
    }

    public boolean isUnsafe() {
        return this.logSynchronizer.isUnsafe();
    }

    public void flush() throws IOException {
        Preconditions.checkState((boolean)this.commitInfoEntry.isPresent(), (String)"commitInfo not set");
        String transactionLogLocation = TransactionLogUtil.getTransactionLogDir(this.tableLocation);
        CommitInfoEntry commitInfo = Objects.requireNonNull(this.commitInfoEntry.get().getCommitInfo(), "commitInfoEntry.get().getCommitInfo() is null");
        Location logEntry = TransactionLogUtil.getTransactionLogJsonEntryPath(transactionLogLocation, commitInfo.getVersion());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.writeEntry(bos, this.commitInfoEntry.get());
        for (DeltaLakeTransactionLogEntry entry : this.entries) {
            this.writeEntry(bos, entry);
        }
        String clusterId = this.commitInfoEntry.get().getCommitInfo().getClusterId();
        this.logSynchronizer.write(this.session, clusterId, logEntry, bos.toByteArray());
    }

    private void writeEntry(OutputStream outputStream, DeltaLakeTransactionLogEntry deltaLakeTransactionLogEntry) throws IOException {
        outputStream.write(OBJECT_MAPPER.writeValueAsString((Object)deltaLakeTransactionLogEntry).getBytes(StandardCharsets.UTF_8));
        outputStream.write("\n".getBytes(StandardCharsets.UTF_8));
    }
}

