/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.base.MoreObjects;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.Type;
import java.util.Objects;
import java.util.OptionalInt;

public class DeltaLakeColumnMetadata {
    private final ColumnMetadata columnMetadata;
    private final String name;
    private final OptionalInt fieldId;
    private final String physicalName;
    private final Type physicalColumnType;

    public DeltaLakeColumnMetadata(ColumnMetadata columnMetadata, String name, OptionalInt fieldId, String physicalName, Type physicalColumnType) {
        this.columnMetadata = Objects.requireNonNull(columnMetadata, "columnMetadata is null");
        this.name = Objects.requireNonNull(name, "name is null");
        this.fieldId = Objects.requireNonNull(fieldId, "fieldId is null");
        this.physicalName = Objects.requireNonNull(physicalName, "physicalName is null");
        this.physicalColumnType = Objects.requireNonNull(physicalColumnType, "physicalColumnType is null");
    }

    public ColumnMetadata getColumnMetadata() {
        return this.columnMetadata;
    }

    public OptionalInt getFieldId() {
        return this.fieldId;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.columnMetadata.getType();
    }

    public String getPhysicalName() {
        return this.physicalName;
    }

    public Type getPhysicalColumnType() {
        return this.physicalColumnType;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columnMetadata", (Object)this.columnMetadata).add("name", (Object)this.name).add("fieldId", (Object)this.fieldId).add("physicalName", (Object)this.physicalName).add("physicalColumnType", (Object)this.physicalColumnType).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeltaLakeColumnMetadata that = (DeltaLakeColumnMetadata)o;
        return Objects.equals(this.columnMetadata, that.columnMetadata) && Objects.equals(this.name, that.name) && Objects.equals(this.fieldId, that.fieldId) && Objects.equals(this.physicalName, that.physicalName) && Objects.equals(this.physicalColumnType, that.physicalColumnType);
    }

    public int hashCode() {
        return Objects.hash(this.columnMetadata, this.name, this.fieldId, this.physicalName, this.physicalColumnType);
    }
}

