/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import io.airlift.json.ObjectMapperProvider;
import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.DeltaLakeParquetSchemaMapping;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Location;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeNotFoundException;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public final class DeltaLakeParquetSchemas {
    private static final int[] PRECISION_TO_BYTE_COUNT = new int[39];
    private static final ObjectMapper OBJECT_MAPPER;

    private DeltaLakeParquetSchemas() {
    }

    public static DeltaLakeParquetSchemaMapping createParquetSchemaMapping(MetadataEntry metadataEntry, ProtocolEntry protocolEntry, TypeManager typeManager) {
        return DeltaLakeParquetSchemas.createParquetSchemaMapping(metadataEntry, protocolEntry, typeManager, false);
    }

    public static DeltaLakeParquetSchemaMapping createParquetSchemaMapping(MetadataEntry metadataEntry, ProtocolEntry protocolEntry, TypeManager typeManager, boolean addChangeDataFeedFields) {
        DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode = DeltaLakeSchemaSupport.getColumnMappingMode(metadataEntry, protocolEntry);
        return DeltaLakeParquetSchemas.createParquetSchemaMapping(metadataEntry.getSchemaString(), typeManager, columnMappingMode, metadataEntry.getOriginalPartitionColumns(), addChangeDataFeedFields);
    }

    public static DeltaLakeParquetSchemaMapping createParquetSchemaMapping(String jsonSchema, TypeManager typeManager, DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode, List<String> partitionColumnNames) {
        return DeltaLakeParquetSchemas.createParquetSchemaMapping(jsonSchema, typeManager, columnMappingMode, partitionColumnNames, false);
    }

    private static DeltaLakeParquetSchemaMapping createParquetSchemaMapping(String jsonSchema, TypeManager typeManager, DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode, List<String> partitionColumnNames, boolean addChangeDataFeedFields) {
        Objects.requireNonNull(typeManager, "typeManager is null");
        Objects.requireNonNull(columnMappingMode, "columnMappingMode is null");
        Objects.requireNonNull(partitionColumnNames, "partitionColumnNames is null");
        Types.MessageTypeBuilder builder = Types.buildMessage();
        ImmutableMap.Builder primitiveTypesBuilder = ImmutableMap.builder();
        try {
            Streams.stream((Iterator)OBJECT_MAPPER.readTree(jsonSchema).get("fields").elements()).filter(fieldNode -> !partitionColumnNames.contains(fieldNode.get("name").asText())).map(fieldNode -> DeltaLakeParquetSchemas.buildType(fieldNode, typeManager, columnMappingMode, (List<String>)ImmutableList.of(), (ImmutableMap.Builder<List<String>, io.trino.spi.type.Type>)primitiveTypesBuilder)).forEach(arg_0 -> ((Types.MessageTypeBuilder)builder).addField(arg_0));
        }
        catch (JsonProcessingException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, DeltaLakeParquetSchemas.getLocation(e), "Failed to parse serialized schema: " + jsonSchema, (Throwable)e);
        }
        if (addChangeDataFeedFields) {
            builder.addField(DeltaLakeParquetSchemas.buildPrimitiveType("string", typeManager, Type.Repetition.OPTIONAL, "_change_type", OptionalInt.empty(), (List<String>)ImmutableList.of(), (ImmutableMap.Builder<List<String>, io.trino.spi.type.Type>)primitiveTypesBuilder));
        }
        return new DeltaLakeParquetSchemaMapping(builder.named("trino_schema"), (Map<List<String>, io.trino.spi.type.Type>)primitiveTypesBuilder.buildOrThrow());
    }

    private static Type buildType(JsonNode fieldNode, TypeManager typeManager, DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode, List<String> parent, ImmutableMap.Builder<List<String>, io.trino.spi.type.Type> primitiveTypesBuilder) {
        String physicalName;
        JsonNode typeNode = fieldNode.get("type");
        OptionalInt fieldId = OptionalInt.empty();
        switch (columnMappingMode) {
            case ID: {
                String columnMappingId = fieldNode.get("metadata").get("delta.columnMapping.id").asText();
                Verify.verify((!Strings.isNullOrEmpty((String)columnMappingId) ? 1 : 0) != 0, (String)"id is null or empty", (Object[])new Object[0]);
                fieldId = OptionalInt.of(Integer.parseInt(columnMappingId));
                physicalName = fieldNode.get("metadata").get("delta.columnMapping.physicalName").asText();
                Verify.verify((!Strings.isNullOrEmpty((String)physicalName) ? 1 : 0) != 0, (String)"physicalName is null or empty", (Object[])new Object[0]);
                break;
            }
            case NAME: {
                physicalName = fieldNode.get("metadata").get("delta.columnMapping.physicalName").asText();
                Verify.verify((!Strings.isNullOrEmpty((String)physicalName) ? 1 : 0) != 0, (String)"physicalName is null or empty", (Object[])new Object[0]);
                break;
            }
            case NONE: {
                physicalName = fieldNode.get("name").asText();
                Verify.verify((!Strings.isNullOrEmpty((String)physicalName) ? 1 : 0) != 0, (String)"name is null or empty", (Object[])new Object[0]);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported parameter columnMappingMode");
            }
        }
        return DeltaLakeParquetSchemas.buildType(typeNode, typeManager, Type.Repetition.OPTIONAL, physicalName, fieldId, columnMappingMode, parent, primitiveTypesBuilder);
    }

    private static Type buildType(JsonNode typeNode, TypeManager typeManager, Type.Repetition repetition, String name, OptionalInt id, DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode, List<String> parent, ImmutableMap.Builder<List<String>, io.trino.spi.type.Type> primitiveTypesBuilder) {
        if (typeNode.isContainerNode()) {
            return DeltaLakeParquetSchemas.buildContainerType(typeNode, typeManager, repetition, name, id, columnMappingMode, parent, primitiveTypesBuilder);
        }
        String primitiveType = typeNode.asText();
        return DeltaLakeParquetSchemas.buildPrimitiveType(primitiveType, typeManager, repetition, name, id, parent, primitiveTypesBuilder);
    }

    private static Type buildPrimitiveType(String primitiveType, TypeManager typeManager, Type.Repetition repetition, String name, OptionalInt id, List<String> parent, ImmutableMap.Builder<List<String>, io.trino.spi.type.Type> primitiveTypesBuilder) {
        Types.PrimitiveBuilder typeBuilder;
        if (primitiveType.startsWith("decimal")) {
            io.trino.spi.type.Type trinoType = typeManager.fromSqlType(primitiveType);
            Verify.verify((boolean)(trinoType instanceof DecimalType), (String)"type %s does not map to Trino decimal".formatted(primitiveType), (Object[])new Object[0]);
            DecimalType trinoDecimalType = (DecimalType)trinoType;
            Types.PrimitiveBuilder typeBuilder2 = trinoDecimalType.getPrecision() <= 9 ? Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition) : (trinoDecimalType.isShort() ? Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition) : (Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).length(PRECISION_TO_BYTE_COUNT[trinoDecimalType.getPrecision()]));
            typeBuilder2 = (Types.PrimitiveBuilder)typeBuilder2.as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)trinoDecimalType.getScale(), (int)trinoDecimalType.getPrecision()));
            return DeltaLakeParquetSchemas.buildType(name, id, parent, (Types.PrimitiveBuilder<PrimitiveType>)typeBuilder2, trinoType, primitiveTypesBuilder);
        }
        return DeltaLakeParquetSchemas.buildType(name, id, parent, (Types.PrimitiveBuilder<PrimitiveType>)typeBuilder, (io.trino.spi.type.Type)(switch (primitiveType) {
            case "string" -> {
                typeBuilder = (Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType());
                yield VarcharType.VARCHAR;
            }
            case "byte" -> {
                typeBuilder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition);
                yield TinyintType.TINYINT;
            }
            case "short" -> {
                typeBuilder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition);
                yield SmallintType.SMALLINT;
            }
            case "integer" -> {
                typeBuilder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition);
                yield IntegerType.INTEGER;
            }
            case "long" -> {
                typeBuilder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition);
                yield BigintType.BIGINT;
            }
            case "float" -> {
                typeBuilder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)repetition);
                yield RealType.REAL;
            }
            case "double" -> {
                typeBuilder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition);
                yield DoubleType.DOUBLE;
            }
            case "boolean" -> {
                typeBuilder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition);
                yield BooleanType.BOOLEAN;
            }
            case "binary" -> {
                typeBuilder = Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition);
                yield VarbinaryType.VARBINARY;
            }
            case "date" -> {
                typeBuilder = (Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.dateType());
                yield DateType.DATE;
            }
            case "timestamp" -> {
                typeBuilder = (Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS));
                yield TimestampType.TIMESTAMP_MILLIS;
            }
            case "timestamp_ntz" -> {
                typeBuilder = (Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS));
                yield TimestampType.TIMESTAMP_MICROS;
            }
            default -> throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported primitive type: %s", primitiveType));
        }), primitiveTypesBuilder);
    }

    private static PrimitiveType buildType(String name, OptionalInt id, List<String> parent, Types.PrimitiveBuilder<PrimitiveType> typeBuilder, io.trino.spi.type.Type trinoType, ImmutableMap.Builder<List<String>, io.trino.spi.type.Type> primitiveTypesBuilder) {
        if (id.isPresent()) {
            typeBuilder.id(id.getAsInt());
        }
        ImmutableList fullName = ImmutableList.builder().addAll(parent).add((Object)name).build();
        primitiveTypesBuilder.put((Object)fullName, (Object)trinoType);
        return (PrimitiveType)typeBuilder.named(name);
    }

    private static Type buildContainerType(JsonNode typeNode, TypeManager typeManager, Type.Repetition repetition, String name, OptionalInt id, DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode, List<String> parent, ImmutableMap.Builder<List<String>, io.trino.spi.type.Type> primitiveTypesBuilder) {
        String containerType;
        return switch (containerType = typeNode.get("type").asText()) {
            case "array" -> DeltaLakeParquetSchemas.buildArrayType(typeNode, typeManager, repetition, name, id, columnMappingMode, parent, primitiveTypesBuilder);
            case "map" -> DeltaLakeParquetSchemas.buildMapType(typeNode, typeManager, repetition, name, id, columnMappingMode, parent, primitiveTypesBuilder);
            case "struct" -> DeltaLakeParquetSchemas.buildRowType(typeNode, typeManager, repetition, name, id, columnMappingMode, parent, primitiveTypesBuilder);
            default -> throw new TypeNotFoundException(new TypeSignature(containerType, new TypeSignatureParameter[0]));
        };
    }

    private static Type buildArrayType(JsonNode typeNode, TypeManager typeManager, Type.Repetition repetition, String name, OptionalInt id, DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode, List<String> parent, ImmutableMap.Builder<List<String>, io.trino.spi.type.Type> primitiveTypesBuilder) {
        parent = ImmutableList.builder().addAll(parent).add((Object)name).add((Object)"list").build();
        JsonNode elementTypeNode = typeNode.get("elementType");
        Type elementType = elementTypeNode.isContainerNode() ? DeltaLakeParquetSchemas.buildContainerType(elementTypeNode, typeManager, Type.Repetition.OPTIONAL, "element", OptionalInt.empty(), columnMappingMode, (List<String>)parent, primitiveTypesBuilder) : DeltaLakeParquetSchemas.buildType(elementTypeNode, typeManager, Type.Repetition.OPTIONAL, "element", OptionalInt.empty(), columnMappingMode, (List<String>)parent, primitiveTypesBuilder);
        GroupType arrayType = (GroupType)Types.list((Type.Repetition)repetition).element(elementType).named(name);
        if (id.isPresent()) {
            arrayType = arrayType.withId(id.getAsInt());
        }
        return arrayType;
    }

    private static Type buildMapType(JsonNode typeNode, TypeManager typeManager, Type.Repetition repetition, String name, OptionalInt id, DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode, List<String> parent, ImmutableMap.Builder<List<String>, io.trino.spi.type.Type> primitiveTypesBuilder) {
        Types.MapBuilder builder = Types.map((Type.Repetition)repetition);
        if (id.isPresent()) {
            builder.id(id.getAsInt());
        }
        parent = ImmutableList.builder().addAll(parent).add((Object)name).add((Object)"key_value").build();
        JsonNode keyTypeNode = typeNode.get("keyType");
        Type keyType = keyTypeNode.isContainerNode() ? DeltaLakeParquetSchemas.buildContainerType(keyTypeNode, typeManager, Type.Repetition.REQUIRED, "key", OptionalInt.empty(), columnMappingMode, (List<String>)parent, primitiveTypesBuilder) : DeltaLakeParquetSchemas.buildType(keyTypeNode, typeManager, Type.Repetition.REQUIRED, "key", OptionalInt.empty(), columnMappingMode, (List<String>)parent, primitiveTypesBuilder);
        JsonNode valueTypeNode = typeNode.get("valueType");
        Type valueType = valueTypeNode.isContainerNode() ? DeltaLakeParquetSchemas.buildContainerType(valueTypeNode, typeManager, Type.Repetition.OPTIONAL, "value", OptionalInt.empty(), columnMappingMode, (List<String>)parent, primitiveTypesBuilder) : DeltaLakeParquetSchemas.buildType(valueTypeNode, typeManager, Type.Repetition.OPTIONAL, "value", OptionalInt.empty(), columnMappingMode, (List<String>)parent, primitiveTypesBuilder);
        return (Type)((Types.MapBuilder)((Types.MapBuilder)builder.key(keyType)).value(valueType)).named(name);
    }

    private static Type buildRowType(JsonNode typeNode, TypeManager typeManager, Type.Repetition repetition, String name, OptionalInt id, DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode, List<String> parent, ImmutableMap.Builder<List<String>, io.trino.spi.type.Type> primitiveTypesBuilder) {
        Types.GroupBuilder builder = Types.buildGroup((Type.Repetition)repetition);
        if (id.isPresent()) {
            builder.id(id.getAsInt());
        }
        ImmutableList currentParent = ImmutableList.builder().addAll(parent).add((Object)name).build();
        Streams.stream((Iterator)typeNode.get("fields").elements()).map(arg_0 -> DeltaLakeParquetSchemas.lambda$buildRowType$2(typeManager, columnMappingMode, (List)currentParent, primitiveTypesBuilder, arg_0)).forEach(arg_0 -> ((Types.GroupBuilder)builder).addField(arg_0));
        return (Type)builder.named(name);
    }

    private static Optional<Location> getLocation(JsonProcessingException e) {
        return Optional.ofNullable(e.getLocation()).map(location -> new Location(location.getLineNr(), location.getColumnNr()));
    }

    private static /* synthetic */ Type lambda$buildRowType$2(TypeManager typeManager, DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode, List currentParent, ImmutableMap.Builder primitiveTypesBuilder, JsonNode node) {
        return DeltaLakeParquetSchemas.buildType(node, typeManager, columnMappingMode, currentParent, (ImmutableMap.Builder<List<String>, io.trino.spi.type.Type>)primitiveTypesBuilder);
    }

    static {
        for (int precision = 1; precision <= 38; ++precision) {
            DeltaLakeParquetSchemas.PRECISION_TO_BYTE_COUNT[precision] = (int)Math.ceil((Math.log(Math.pow(10.0, precision) - 1.0) / Math.log(2.0) + 1.0) / 8.0);
        }
        OBJECT_MAPPER = new ObjectMapperProvider().get();
    }
}

