/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeParquetStatisticsUtils;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeJsonFileStatistics;
import io.trino.spi.block.Block;
import io.trino.spi.statistics.ColumnStatisticMetadata;
import io.trino.spi.statistics.ColumnStatisticType;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.statistics.TableStatisticType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import io.trino.spi.type.VarbinaryType;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;

public final class DeltaLakeComputedStatistics {
    private DeltaLakeComputedStatistics() {
    }

    public static DeltaLakeJsonFileStatistics toDeltaLakeJsonFileStatistics(ComputedStatistics stats, Map<String, DeltaLakeColumnHandle> lowercaseToColumnsHandles) {
        Optional<Long> rowCount = DeltaLakeComputedStatistics.getLongValue((Block)stats.getTableStatistics().get(TableStatisticType.ROW_COUNT)).stream().boxed().findFirst();
        Optional<Map<String, Object>> minValues = Optional.of(DeltaLakeComputedStatistics.getColumnStatistics(stats, ColumnStatisticType.MIN_VALUE, lowercaseToColumnsHandles));
        Optional<Map<String, Object>> maxValues = Optional.of(DeltaLakeComputedStatistics.getColumnStatistics(stats, ColumnStatisticType.MAX_VALUE, lowercaseToColumnsHandles));
        Optional<Map<String, Object>> nullCount = Optional.empty();
        if (rowCount.isPresent()) {
            nullCount = Optional.of(DeltaLakeComputedStatistics.getNullCount(stats, rowCount.get(), lowercaseToColumnsHandles));
        }
        return new DeltaLakeJsonFileStatistics(rowCount, minValues, maxValues, nullCount);
    }

    private static Map<String, Object> getNullCount(ComputedStatistics statistics, long rowCount, Map<String, DeltaLakeColumnHandle> lowercaseToColumnsHandles) {
        return (Map)statistics.getColumnStatistics().entrySet().stream().filter(stats -> ((ColumnStatisticMetadata)stats.getKey()).getStatisticType() == ColumnStatisticType.NUMBER_OF_NON_NULL_VALUES && lowercaseToColumnsHandles.containsKey(((ColumnStatisticMetadata)stats.getKey()).getColumnName())).map(stats -> Map.entry(((DeltaLakeColumnHandle)lowercaseToColumnsHandles.get(((ColumnStatisticMetadata)stats.getKey()).getColumnName())).getBasePhysicalColumnName(), DeltaLakeComputedStatistics.getLongValue((Block)stats.getValue()))).filter(stats -> ((OptionalLong)stats.getValue()).isPresent()).map(nonNullCount -> Map.entry((String)nonNullCount.getKey(), rowCount - ((OptionalLong)nonNullCount.getValue()).getAsLong())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Map<String, Object> getColumnStatistics(ComputedStatistics statistics, ColumnStatisticType statisticType, Map<String, DeltaLakeColumnHandle> lowercaseToColumnsHandles) {
        return (Map)statistics.getColumnStatistics().entrySet().stream().filter(stats -> ((ColumnStatisticMetadata)stats.getKey()).getStatisticType().equals((Object)statisticType) && lowercaseToColumnsHandles.containsKey(((ColumnStatisticMetadata)stats.getKey()).getColumnName())).map(stats -> DeltaLakeComputedStatistics.mapSingleStatisticsValueToJsonRepresentation(stats, lowercaseToColumnsHandles)).filter(Optional::isPresent).flatMap(Optional::stream).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Optional<Map.Entry<String, Object>> mapSingleStatisticsValueToJsonRepresentation(Map.Entry<ColumnStatisticMetadata, Block> statistics, Map<String, DeltaLakeColumnHandle> lowercaseToColumnsHandles) {
        Type columnType = lowercaseToColumnsHandles.get(statistics.getKey().getColumnName()).getBasePhysicalType();
        String physicalName = lowercaseToColumnsHandles.get(statistics.getKey().getColumnName()).getBasePhysicalColumnName();
        if (columnType.equals(BooleanType.BOOLEAN) || columnType.equals(VarbinaryType.VARBINARY)) {
            return Optional.empty();
        }
        Object value = TypeUtils.readNativeValue((Type)columnType, (Block)statistics.getValue(), (int)0);
        Object jsonValue = DeltaLakeParquetStatisticsUtils.toJsonValue(columnType, value);
        if (jsonValue != null) {
            return Optional.of(Map.entry(physicalName, jsonValue));
        }
        return Optional.empty();
    }

    private static OptionalLong getLongValue(Block block) {
        if (block == null || block.isNull(0)) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(block.getLong(0, 0));
    }
}

