/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoInputFile;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.deltalake.transactionlog.Transaction;
import io.trino.plugin.deltalake.transactionlog.TransactionLogParser;
import io.trino.plugin.deltalake.transactionlog.TransactionLogUtil;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointEntryIterator;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointSchemaManager;
import io.trino.plugin.deltalake.transactionlog.checkpoint.LastCheckpoint;
import io.trino.plugin.deltalake.transactionlog.checkpoint.TransactionLogTail;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.TypeManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class TableSnapshot {
    private final Optional<LastCheckpoint> lastCheckpoint;
    private final SchemaTableName table;
    private final TransactionLogTail logTail;
    private final String tableLocation;
    private final ParquetReaderOptions parquetReaderOptions;
    private final boolean checkpointRowStatisticsWritingEnabled;
    private final int domainCompactionThreshold;
    private Optional<MetadataEntry> cachedMetadata = Optional.empty();

    private TableSnapshot(SchemaTableName table, Optional<LastCheckpoint> lastCheckpoint, TransactionLogTail logTail, String tableLocation, ParquetReaderOptions parquetReaderOptions, boolean checkpointRowStatisticsWritingEnabled, int domainCompactionThreshold) {
        this.table = Objects.requireNonNull(table, "table is null");
        this.lastCheckpoint = Objects.requireNonNull(lastCheckpoint, "lastCheckpoint is null");
        this.logTail = Objects.requireNonNull(logTail, "logTail is null");
        this.tableLocation = Objects.requireNonNull(tableLocation, "tableLocation is null");
        this.parquetReaderOptions = Objects.requireNonNull(parquetReaderOptions, "parquetReaderOptions is null");
        this.checkpointRowStatisticsWritingEnabled = checkpointRowStatisticsWritingEnabled;
        this.domainCompactionThreshold = domainCompactionThreshold;
    }

    public static TableSnapshot load(SchemaTableName table, Optional<LastCheckpoint> lastCheckpoint, TrinoFileSystem fileSystem, String tableLocation, ParquetReaderOptions parquetReaderOptions, boolean checkpointRowStatisticsWritingEnabled, int domainCompactionThreshold) throws IOException {
        Optional<Long> lastCheckpointVersion = lastCheckpoint.map(LastCheckpoint::getVersion);
        TransactionLogTail transactionLogTail = TransactionLogTail.loadNewTail(fileSystem, tableLocation, lastCheckpointVersion);
        return new TableSnapshot(table, lastCheckpoint, transactionLogTail, tableLocation, parquetReaderOptions, checkpointRowStatisticsWritingEnabled, domainCompactionThreshold);
    }

    public Optional<TableSnapshot> getUpdatedSnapshot(TrinoFileSystem fileSystem, Optional<Long> toVersion) throws IOException {
        long ourCheckpointVersion;
        Optional<LastCheckpoint> lastCheckpoint;
        if (toVersion.isEmpty() && (lastCheckpoint = TransactionLogParser.readLastCheckpoint(fileSystem, this.tableLocation)).isPresent() && (ourCheckpointVersion = this.getLastCheckpointVersion().orElse(0L).longValue()) != lastCheckpoint.get().getVersion()) {
            return Optional.of(TableSnapshot.load(this.table, lastCheckpoint, fileSystem, this.tableLocation, this.parquetReaderOptions, this.checkpointRowStatisticsWritingEnabled, this.domainCompactionThreshold));
        }
        Optional<TransactionLogTail> updatedLogTail = this.logTail.getUpdatedTail(fileSystem, this.tableLocation, toVersion);
        return updatedLogTail.map(transactionLogTail -> new TableSnapshot(this.table, this.lastCheckpoint, (TransactionLogTail)transactionLogTail, this.tableLocation, this.parquetReaderOptions, this.checkpointRowStatisticsWritingEnabled, this.domainCompactionThreshold));
    }

    public long getVersion() {
        return this.logTail.getVersion();
    }

    public SchemaTableName getTable() {
        return this.table;
    }

    public Optional<MetadataEntry> getCachedMetadata() {
        return this.cachedMetadata;
    }

    public String getTableLocation() {
        return this.tableLocation;
    }

    public void setCachedMetadata(Optional<MetadataEntry> cachedMetadata) {
        this.cachedMetadata = cachedMetadata;
    }

    public List<DeltaLakeTransactionLogEntry> getJsonTransactionLogEntries() {
        return this.logTail.getFileEntries();
    }

    public List<Transaction> getTransactions() {
        return this.logTail.getTransactions();
    }

    public Stream<DeltaLakeTransactionLogEntry> getCheckpointTransactionLogEntries(ConnectorSession session, Set<CheckpointEntryIterator.EntryType> entryTypes, CheckpointSchemaManager checkpointSchemaManager, TypeManager typeManager, TrinoFileSystem fileSystem, FileFormatDataSourceStats stats) throws IOException {
        if (this.lastCheckpoint.isEmpty()) {
            return Stream.empty();
        }
        LastCheckpoint checkpoint = this.lastCheckpoint.get();
        Optional<Object> metadataAndProtocol = Optional.empty();
        if (entryTypes.contains((Object)CheckpointEntryIterator.EntryType.ADD)) {
            metadataAndProtocol = Optional.of(this.getCheckpointMetadataAndProtocolEntries(session, checkpointSchemaManager, typeManager, fileSystem, stats, checkpoint));
        }
        Stream<DeltaLakeTransactionLogEntry> resultStream = Stream.empty();
        for (Location checkpointPath : this.getCheckpointPartPaths(checkpoint)) {
            TrinoInputFile checkpointFile = fileSystem.newInputFile(checkpointPath);
            resultStream = Stream.concat(resultStream, Streams.stream(this.getCheckpointTransactionLogEntries(session, entryTypes, metadataAndProtocol.map(MetadataAndProtocolEntry::metadataEntry), metadataAndProtocol.map(MetadataAndProtocolEntry::protocolEntry), checkpointSchemaManager, typeManager, stats, checkpoint, checkpointFile)));
        }
        return resultStream;
    }

    public Optional<Long> getLastCheckpointVersion() {
        return this.lastCheckpoint.map(LastCheckpoint::getVersion);
    }

    private Iterator<DeltaLakeTransactionLogEntry> getCheckpointTransactionLogEntries(ConnectorSession session, Set<CheckpointEntryIterator.EntryType> entryTypes, Optional<MetadataEntry> metadataEntry, Optional<ProtocolEntry> protocolEntry, CheckpointSchemaManager checkpointSchemaManager, TypeManager typeManager, FileFormatDataSourceStats stats, LastCheckpoint checkpoint, TrinoInputFile checkpointFile) throws IOException {
        long fileSize;
        try {
            fileSize = checkpointFile.length();
        }
        catch (FileNotFoundException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, String.format("%s mentions a non-existent checkpoint file for table: %s", checkpoint, this.table));
        }
        return new CheckpointEntryIterator(checkpointFile, session, fileSize, checkpointSchemaManager, typeManager, entryTypes, metadataEntry, protocolEntry, stats, this.parquetReaderOptions, this.checkpointRowStatisticsWritingEnabled, this.domainCompactionThreshold);
    }

    private MetadataAndProtocolEntry getCheckpointMetadataAndProtocolEntries(ConnectorSession session, CheckpointSchemaManager checkpointSchemaManager, TypeManager typeManager, TrinoFileSystem fileSystem, FileFormatDataSourceStats stats, LastCheckpoint checkpoint) throws IOException {
        MetadataEntry metadata = null;
        ProtocolEntry protocol = null;
        block0: for (Location checkpointPath : this.getCheckpointPartPaths(checkpoint)) {
            TrinoInputFile checkpointFile = fileSystem.newInputFile(checkpointPath);
            Iterator<DeltaLakeTransactionLogEntry> entries = this.getCheckpointTransactionLogEntries(session, (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)((Object)CheckpointEntryIterator.EntryType.METADATA), (Object)((Object)CheckpointEntryIterator.EntryType.PROTOCOL)), Optional.empty(), Optional.empty(), checkpointSchemaManager, typeManager, stats, checkpoint, checkpointFile);
            while (entries.hasNext()) {
                DeltaLakeTransactionLogEntry entry = entries.next();
                if (metadata == null && entry.getMetaData() != null) {
                    metadata = entry.getMetaData();
                }
                if (protocol == null && entry.getProtocol() != null) {
                    protocol = entry.getProtocol();
                }
                if (metadata == null || protocol == null) continue;
                continue block0;
            }
        }
        if (metadata == null || protocol == null) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_DATA, "Checkpoint found without metadata and protocol entry: " + checkpoint);
        }
        return new MetadataAndProtocolEntry(metadata, protocol);
    }

    private List<Location> getCheckpointPartPaths(LastCheckpoint checkpoint) {
        Location transactionLogDir = Location.of((String)TransactionLogUtil.getTransactionLogDir(this.tableLocation));
        ImmutableList.Builder paths = ImmutableList.builder();
        if (checkpoint.getParts().isEmpty()) {
            paths.add((Object)transactionLogDir.appendPath("%020d.checkpoint.parquet".formatted(checkpoint.getVersion())));
        } else {
            int partsCount = checkpoint.getParts().get();
            for (int i = 1; i <= partsCount; ++i) {
                paths.add((Object)transactionLogDir.appendPath("%020d.checkpoint.%010d.%010d.parquet".formatted(checkpoint.getVersion(), i, partsCount)));
            }
        }
        return paths.build();
    }

    private record MetadataAndProtocolEntry(MetadataEntry metadataEntry, ProtocolEntry protocolEntry) {
        private MetadataAndProtocolEntry {
            Objects.requireNonNull(metadataEntry, "metadataEntry is null");
            Objects.requireNonNull(protocolEntry, "protocolEntry is null");
        }
    }
}

