/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog.checkpoint;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoInputFile;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.MissingTransactionLogException;
import io.trino.plugin.deltalake.transactionlog.Transaction;
import io.trino.plugin.deltalake.transactionlog.TransactionLogParser;
import io.trino.plugin.deltalake.transactionlog.TransactionLogUtil;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TransactionLogTail {
    private static final int JSON_LOG_ENTRY_READ_BUFFER_SIZE = 0x100000;
    private final List<Transaction> entries;
    private final long version;

    private TransactionLogTail(List<Transaction> entries, long version) {
        this.entries = ImmutableList.copyOf((Collection)Objects.requireNonNull(entries, "entries is null"));
        this.version = version;
    }

    public static TransactionLogTail loadNewTail(TrinoFileSystem fileSystem, String tableLocation, Optional<Long> startVersion) throws IOException {
        return TransactionLogTail.loadNewTail(fileSystem, tableLocation, startVersion, Optional.empty());
    }

    public static TransactionLogTail loadNewTail(TrinoFileSystem fileSystem, String tableLocation, Optional<Long> startVersion, Optional<Long> endVersion) throws IOException {
        ImmutableList.Builder entriesBuilder = ImmutableList.builder();
        long version = startVersion.orElse(0L);
        long entryNumber = startVersion.map(start -> start + 1L).orElse(0L);
        Preconditions.checkArgument((endVersion.isEmpty() || entryNumber <= endVersion.get() ? 1 : 0) != 0, (String)"Invalid start/end versions: %s, %s", startVersion, endVersion);
        String transactionLogDir = TransactionLogUtil.getTransactionLogDir(tableLocation);
        boolean endOfTail = false;
        while (!endOfTail) {
            Optional<List<DeltaLakeTransactionLogEntry>> results = TransactionLogTail.getEntriesFromJson(entryNumber, transactionLogDir, fileSystem);
            if (results.isPresent()) {
                entriesBuilder.add((Object)new Transaction(entryNumber, results.get()));
                version = entryNumber++;
            } else {
                if (endVersion.isPresent()) {
                    throw new MissingTransactionLogException(TransactionLogUtil.getTransactionLogJsonEntryPath(transactionLogDir, entryNumber).toString());
                }
                endOfTail = true;
            }
            if (!endVersion.isPresent() || version != endVersion.get()) continue;
            endOfTail = true;
        }
        return new TransactionLogTail((List<Transaction>)entriesBuilder.build(), version);
    }

    public Optional<TransactionLogTail> getUpdatedTail(TrinoFileSystem fileSystem, String tableLocation, Optional<Long> endVersion) throws IOException {
        Preconditions.checkArgument((endVersion.isEmpty() || endVersion.get() > this.version ? 1 : 0) != 0, (String)"Invalid endVersion, expected higher than %s, but got %s", (long)this.version, endVersion);
        TransactionLogTail newTail = TransactionLogTail.loadNewTail(fileSystem, tableLocation, Optional.of(this.version), endVersion);
        if (newTail.version == this.version) {
            return Optional.empty();
        }
        return Optional.of(new TransactionLogTail((List<Transaction>)ImmutableList.builder().addAll(this.entries).addAll(newTail.entries).build(), newTail.version));
    }

    public static Optional<List<DeltaLakeTransactionLogEntry>> getEntriesFromJson(long entryNumber, String transactionLogDir, TrinoFileSystem fileSystem) throws IOException {
        Optional<ImmutableList> optional;
        Location transactionLogFilePath = TransactionLogUtil.getTransactionLogJsonEntryPath(transactionLogDir, entryNumber);
        TrinoInputFile inputFile = fileSystem.newInputFile(transactionLogFilePath);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputFile.newStream(), StandardCharsets.UTF_8), 0x100000);
        try {
            ImmutableList.Builder resultsBuilder = ImmutableList.builder();
            String line = reader.readLine();
            while (line != null) {
                DeltaLakeTransactionLogEntry deltaLakeTransactionLogEntry = TransactionLogParser.parseJson(line);
                if (deltaLakeTransactionLogEntry.getCommitInfo() != null && deltaLakeTransactionLogEntry.getCommitInfo().getVersion() == 0L) {
                    deltaLakeTransactionLogEntry = deltaLakeTransactionLogEntry.withCommitInfo(deltaLakeTransactionLogEntry.getCommitInfo().withVersion(entryNumber));
                }
                resultsBuilder.add((Object)deltaLakeTransactionLogEntry);
                line = reader.readLine();
            }
            optional = Optional.of(resultsBuilder.build());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                return Optional.empty();
            }
        }
        reader.close();
        return optional;
    }

    public List<DeltaLakeTransactionLogEntry> getFileEntries() {
        return (List)this.entries.stream().map(Transaction::transactionEntries).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    public List<Transaction> getTransactions() {
        return this.entries;
    }

    public long getVersion() {
        return this.version;
    }
}

