/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog.writer;

import com.google.inject.Inject;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.deltalake.transactionlog.writer.TransactionConflictException;
import io.trino.plugin.deltalake.transactionlog.writer.TransactionLogSynchronizer;
import io.trino.spi.connector.ConnectorSession;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.UUID;

public class AzureTransactionLogSynchronizer
implements TransactionLogSynchronizer {
    private final TrinoFileSystemFactory fileSystemFactory;

    @Inject
    public AzureTransactionLogSynchronizer(TrinoFileSystemFactory fileSystemFactory) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
    }

    @Override
    public void write(ConnectorSession session, String clusterId, Location newLogEntryPath, byte[] entryContents) {
        Location tmpFilePath = newLogEntryPath.appendSuffix("." + UUID.randomUUID() + ".tmp");
        boolean conflict = false;
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
        try {
            try (OutputStream outputStream = fileSystem.newOutputFile(tmpFilePath).create();){
                outputStream.write(entryContents);
            }
            try {
                fileSystem.renameFile(tmpFilePath, newLogEntryPath);
            }
            catch (IOException e) {
                conflict = true;
                throw e;
            }
        }
        catch (IOException e) {
            block15: {
                try {
                    fileSystem.deleteFile(tmpFilePath);
                }
                catch (IOException | RuntimeException ex) {
                    if (e.equals(ex)) break block15;
                    e.addSuppressed(ex);
                }
            }
            if (conflict) {
                throw new TransactionConflictException("Conflict detected while writing Transaction Log entry to ADLS", e);
            }
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean isUnsafe() {
        return false;
    }
}

