/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop;

import io.trino.spi.classloader.ThreadContextClassLoader;
import org.apache.hadoop.conf.Configuration;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;

public final class ConfigurationInstantiator {
    private ConfigurationInstantiator() {
    }

    public static Configuration newEmptyConfiguration() {
        return ConfigurationInstantiator.newConfiguration(false);
    }

    public static Configuration newConfigurationWithDefaultResources() {
        return ConfigurationInstantiator.newConfiguration(true);
    }

    private static Configuration newConfiguration(boolean loadDefaults) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(ConfigurationInstantiator.class.getClassLoader());){
            Configuration configuration = ConfigurationInstantiator.newConfigurationWithTccl(loadDefaults);
            return configuration;
        }
    }

    @SuppressModernizer
    private static Configuration newConfigurationWithTccl(boolean loadDefaults) {
        return new Configuration(loadDefaults);
    }
}

