/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.encodings.text;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.hive.formats.FileCorruptionException;
import io.trino.hive.formats.encodings.text.BlockEncoding;
import io.trino.hive.formats.encodings.text.TextColumnEncoding;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;

public class ListEncoding
extends BlockEncoding {
    private final byte separator;
    private final TextColumnEncoding elementEncoding;

    public ListEncoding(Type type, Slice nullSequence, byte separator, Byte escapeByte, TextColumnEncoding elementEncoding) {
        super(type, nullSequence, escapeByte);
        this.separator = separator;
        this.elementEncoding = elementEncoding;
    }

    @Override
    public void encodeValueInto(Block block, int position, SliceOutput output) throws FileCorruptionException {
        Block list = (Block)block.getObject(position, Block.class);
        for (int elementIndex = 0; elementIndex < list.getPositionCount(); ++elementIndex) {
            if (elementIndex > 0) {
                output.writeByte((int)this.separator);
            }
            if (list.isNull(elementIndex)) {
                output.writeBytes(this.nullSequence);
                continue;
            }
            this.elementEncoding.encodeValueInto(list, elementIndex, output);
        }
    }

    @Override
    public void decodeValueInto(BlockBuilder builder, Slice slice, int offset, int length) throws FileCorruptionException {
        ((ArrayBlockBuilder)builder).buildEntry(elementBuilder -> this.decodeArrayInto(elementBuilder, slice, offset, length));
    }

    private void decodeArrayInto(BlockBuilder elementBuilder, Slice slice, int offset, int length) throws FileCorruptionException {
        if (length <= 0) {
            return;
        }
        int end = offset + length;
        int elementOffset = offset;
        while (offset < end) {
            byte currentByte = slice.getByte(offset);
            if (currentByte == this.separator) {
                this.decodeElementValueInto(elementBuilder, slice, elementOffset, offset - elementOffset);
                elementOffset = offset + 1;
            } else if (this.isEscapeByte(currentByte) && offset + 1 < length) {
                ++offset;
            }
            ++offset;
        }
        this.decodeElementValueInto(elementBuilder, slice, elementOffset, offset - elementOffset);
    }

    private void decodeElementValueInto(BlockBuilder blockBuilder, Slice slice, int offset, int length) throws FileCorruptionException {
        if (this.nullSequence.equals(0, this.nullSequence.length(), slice, offset, length)) {
            blockBuilder.appendNull();
        } else {
            this.elementEncoding.decodeValueInto(blockBuilder, slice, offset, length);
        }
    }
}

