/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.decoders;

import com.google.common.base.Preconditions;
import io.trino.parquet.ParquetReaderUtils;
import io.trino.parquet.reader.SimpleSliceInputStream;

public class ShortDecimalFixedWidthByteArrayBatchDecoder {
    private static final ShortDecimalDecoder[] VALUE_DECODERS = new ShortDecimalDecoder[]{new BigEndianReader1(), new BigEndianReader2(), new BigEndianReader3(), new BigEndianReader4(), new BigEndianReader5(), new BigEndianReader6(), new BigEndianReader7(), new BigEndianReader8()};
    private final ShortDecimalDecoder decoder;

    public ShortDecimalFixedWidthByteArrayBatchDecoder(int length) {
        Preconditions.checkArgument((length > 0 && length <= 8 ? 1 : 0) != 0, (String)"Short decimal length %s must be in range 1-8", (int)length);
        this.decoder = VALUE_DECODERS[length - 1];
    }

    public void getShortDecimalValues(SimpleSliceInputStream input, long[] values, int offset, int length) {
        this.decoder.decode(input, values, offset, length);
    }

    public static interface ShortDecimalDecoder {
        public void decode(SimpleSliceInputStream var1, long[] var2, int var3, int var4);
    }

    private static final class BigEndianReader1
    implements ShortDecimalDecoder {
        private BigEndianReader1() {
        }

        @Override
        public void decode(SimpleSliceInputStream input, long[] values, int offset, int length) {
            byte[] inputArr = input.getByteArray();
            int inputOffset = input.getByteArrayOffset();
            int inputBytesRead = 0;
            int outputOffset = offset;
            while (length > 0) {
                values[outputOffset++] = inputArr[inputOffset + inputBytesRead];
                ++inputBytesRead;
                --length;
            }
            input.skip(inputBytesRead);
        }
    }

    private static final class BigEndianReader2
    implements ShortDecimalDecoder {
        private BigEndianReader2() {
        }

        @Override
        public void decode(SimpleSliceInputStream input, long[] values, int offset, int length) {
            while (length > 3) {
                long value = input.readLongUnsafe();
                value = Long.reverseBytes(value);
                values[offset] = value >> 48;
                values[offset + 1] = value << 16 >> 48;
                values[offset + 2] = value << 32 >> 48;
                values[offset + 3] = value << 48 >> 48;
                offset += 4;
                length -= 4;
            }
            while (length > 0) {
                values[offset++] = Short.reverseBytes(input.readShort());
                --length;
            }
        }
    }

    private static final class BigEndianReader3
    implements ShortDecimalDecoder {
        private BigEndianReader3() {
        }

        @Override
        public void decode(SimpleSliceInputStream input, long[] values, int offset, int length) {
            int i;
            int bytesOffSet = 0;
            int endOffset = offset + length;
            for (i = offset; i < endOffset - 2; i += 2) {
                long value = Long.reverseBytes(input.getLongUnsafe(bytesOffSet));
                values[i] = value >> 40;
                values[i + 1] = value << 24 >> 40;
                bytesOffSet += 6;
            }
            while (i < endOffset) {
                values[i++] = this.decode(input, bytesOffSet);
                bytesOffSet += 3;
            }
            input.skip(bytesOffSet);
        }

        private long decode(SimpleSliceInputStream input, int index) {
            long value = (long)input.getByteUnsafe(index + 2) & 0xFFL | ((long)input.getByteUnsafe(index + 1) & 0xFFL) << 8 | ((long)input.getByteUnsafe(index) & 0xFFL) << 16;
            return ParquetReaderUtils.propagateSignBit(value, 40);
        }
    }

    private static final class BigEndianReader4
    implements ShortDecimalDecoder {
        private BigEndianReader4() {
        }

        @Override
        public void decode(SimpleSliceInputStream input, long[] values, int offset, int length) {
            while (length > 1) {
                long value = Long.reverseBytes(input.readLongUnsafe());
                values[offset] = (int)(value >> 32);
                values[offset + 1] = (int)value;
                offset += 2;
                length -= 2;
            }
            if (length > 0) {
                int value = input.readIntUnsafe();
                values[offset] = Integer.reverseBytes(value);
            }
        }
    }

    private static final class BigEndianReader5
    implements ShortDecimalDecoder {
        private BigEndianReader5() {
        }

        @Override
        public void decode(SimpleSliceInputStream input, long[] values, int offset, int length) {
            int bytesOffSet = 0;
            int endOffset = offset + length;
            for (int i = offset; i < endOffset - 1; ++i) {
                values[i] = Long.reverseBytes(input.getLongUnsafe(bytesOffSet)) >> 24;
                bytesOffSet += 5;
            }
            values[endOffset - 1] = this.decode(input, bytesOffSet);
            input.skip(bytesOffSet + 5);
        }

        private long decode(SimpleSliceInputStream input, int index) {
            long value = (long)input.getByteUnsafe(index + 4) & 0xFFL | ((long)Integer.reverseBytes(input.getIntUnsafe(index)) & 0xFFFFFFFFL) << 8;
            return ParquetReaderUtils.propagateSignBit(value, 24);
        }
    }

    private static final class BigEndianReader6
    implements ShortDecimalDecoder {
        private BigEndianReader6() {
        }

        @Override
        public void decode(SimpleSliceInputStream input, long[] values, int offset, int length) {
            int bytesOffSet = 0;
            int endOffset = offset + length;
            for (int i = offset; i < endOffset - 1; ++i) {
                values[i] = Long.reverseBytes(input.getLongUnsafe(bytesOffSet)) >> 16;
                bytesOffSet += 6;
            }
            values[endOffset - 1] = this.decode(input, bytesOffSet);
            input.skip(bytesOffSet + 6);
        }

        private long decode(SimpleSliceInputStream input, int index) {
            long value = (long)input.getByteUnsafe(index + 5) & 0xFFL | ((long)input.getByteUnsafe(index + 4) & 0xFFL) << 8 | ((long)Integer.reverseBytes(input.getIntUnsafe(index)) & 0xFFFFFFFFL) << 16;
            return ParquetReaderUtils.propagateSignBit(value, 16);
        }
    }

    private static final class BigEndianReader7
    implements ShortDecimalDecoder {
        private BigEndianReader7() {
        }

        @Override
        public void decode(SimpleSliceInputStream input, long[] values, int offset, int length) {
            int bytesOffSet = 0;
            int endOffset = offset + length;
            for (int i = offset; i < endOffset - 1; ++i) {
                values[i] = Long.reverseBytes(input.getLongUnsafe(bytesOffSet)) >> 8;
                bytesOffSet += 7;
            }
            values[endOffset - 1] = this.decode(input, bytesOffSet);
            input.skip(bytesOffSet + 7);
        }

        private long decode(SimpleSliceInputStream input, int index) {
            long value = (long)input.getByteUnsafe(index + 6) & 0xFFL | ((long)input.getByteUnsafe(index + 5) & 0xFFL) << 8 | ((long)input.getByteUnsafe(index + 4) & 0xFFL) << 16 | ((long)Integer.reverseBytes(input.getIntUnsafe(index)) & 0xFFFFFFFFL) << 24;
            return ParquetReaderUtils.propagateSignBit(value, 8);
        }
    }

    private static final class BigEndianReader8
    implements ShortDecimalDecoder {
        private BigEndianReader8() {
        }

        @Override
        public void decode(SimpleSliceInputStream input, long[] values, int offset, int length) {
            int endOffset = offset + length;
            for (int i = offset; i < endOffset; ++i) {
                values[i] = Long.reverseBytes(input.readLongUnsafe());
            }
        }
    }
}

