/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer.repdef;

import com.google.common.base.Preconditions;
import io.trino.parquet.writer.repdef.RepLevelWriterProvider;
import io.trino.spi.block.Block;
import io.trino.spi.block.ColumnarArray;
import io.trino.spi.block.ColumnarMap;
import io.trino.spi.block.ColumnarRow;
import java.util.Objects;
import java.util.Optional;
import org.apache.parquet.column.values.ValuesWriter;

public class RepLevelWriterProviders {
    private RepLevelWriterProviders() {
    }

    public static RepLevelWriterProvider of(Block block) {
        return new PrimitiveRepLevelWriterProvider(block);
    }

    public static RepLevelWriterProvider of(ColumnarRow columnarRow) {
        return new ColumnRowRepLevelWriterProvider(columnarRow);
    }

    public static RepLevelWriterProvider of(ColumnarArray columnarArray, int maxRepetitionLevel) {
        return new ColumnArrayRepLevelWriterProvider(columnarArray, maxRepetitionLevel);
    }

    public static RepLevelWriterProvider of(ColumnarMap columnarMap, int maxRepetitionLevel) {
        return new ColumnMapRepLevelWriterProvider(columnarMap, maxRepetitionLevel);
    }

    private static void checkValidPosition(int offset, int positionsCount, int totalPositionsCount) {
        if (offset < 0 || positionsCount < 0 || offset + positionsCount > totalPositionsCount) {
            throw new IndexOutOfBoundsException(String.format("Invalid offset %s and positionsCount %s in block with %s positions", offset, positionsCount, totalPositionsCount));
        }
    }

    static class PrimitiveRepLevelWriterProvider
    implements RepLevelWriterProvider {
        private final Block block;

        PrimitiveRepLevelWriterProvider(Block block) {
            this.block = Objects.requireNonNull(block, "block is null");
        }

        @Override
        public RepLevelWriterProvider.RepetitionLevelWriter getRepetitionLevelWriter(Optional<RepLevelWriterProvider.RepetitionLevelWriter> nestedWriter, final ValuesWriter encoder) {
            Preconditions.checkArgument((boolean)nestedWriter.isEmpty(), (Object)"nestedWriter should be empty for primitive repetition level writer");
            return new RepLevelWriterProvider.RepetitionLevelWriter(){
                private int offset;

                @Override
                public void writeRepetitionLevels(int parentLevel) {
                    this.writeRepetitionLevels(parentLevel, block.getPositionCount());
                }

                @Override
                public void writeRepetitionLevels(int parentLevel, int positionsCount) {
                    RepLevelWriterProviders.checkValidPosition(this.offset, positionsCount, block.getPositionCount());
                    for (int i = 0; i < positionsCount; ++i) {
                        encoder.writeInteger(parentLevel);
                    }
                    this.offset += positionsCount;
                }
            };
        }
    }

    static class ColumnRowRepLevelWriterProvider
    implements RepLevelWriterProvider {
        private final ColumnarRow columnarRow;

        ColumnRowRepLevelWriterProvider(ColumnarRow columnarRow) {
            this.columnarRow = Objects.requireNonNull(columnarRow, "columnarRow is null");
        }

        @Override
        public RepLevelWriterProvider.RepetitionLevelWriter getRepetitionLevelWriter(final Optional<RepLevelWriterProvider.RepetitionLevelWriter> nestedWriterOptional, final ValuesWriter encoder) {
            Preconditions.checkArgument((boolean)nestedWriterOptional.isPresent(), (Object)"nestedWriter should be present for column row repetition level writer");
            return new RepLevelWriterProvider.RepetitionLevelWriter(){
                private final RepLevelWriterProvider.RepetitionLevelWriter nestedWriter;
                private int offset;
                {
                    this.nestedWriter = (RepLevelWriterProvider.RepetitionLevelWriter)nestedWriterOptional.orElseThrow();
                }

                @Override
                public void writeRepetitionLevels(int parentLevel) {
                    this.writeRepetitionLevels(parentLevel, columnarRow.getPositionCount());
                }

                @Override
                public void writeRepetitionLevels(int parentLevel, int positionsCount) {
                    RepLevelWriterProviders.checkValidPosition(this.offset, positionsCount, columnarRow.getPositionCount());
                    if (!columnarRow.mayHaveNull()) {
                        this.nestedWriter.writeRepetitionLevels(parentLevel, positionsCount);
                        this.offset += positionsCount;
                        return;
                    }
                    int position = this.offset;
                    while (position < this.offset + positionsCount) {
                        if (columnarRow.isNull(position)) {
                            encoder.writeInteger(parentLevel);
                            ++position;
                            continue;
                        }
                        int consecutiveNonNullsCount = 1;
                        ++position;
                        while (position < this.offset + positionsCount && !columnarRow.isNull(position)) {
                            ++position;
                            ++consecutiveNonNullsCount;
                        }
                        this.nestedWriter.writeRepetitionLevels(parentLevel, consecutiveNonNullsCount);
                    }
                    this.offset += positionsCount;
                }
            };
        }
    }

    static class ColumnArrayRepLevelWriterProvider
    implements RepLevelWriterProvider {
        private final ColumnarArray columnarArray;
        private final int maxRepetitionLevel;

        ColumnArrayRepLevelWriterProvider(ColumnarArray columnarArray, int maxRepetitionLevel) {
            this.columnarArray = Objects.requireNonNull(columnarArray, "columnarArray is null");
            this.maxRepetitionLevel = maxRepetitionLevel;
        }

        @Override
        public RepLevelWriterProvider.RepetitionLevelWriter getRepetitionLevelWriter(final Optional<RepLevelWriterProvider.RepetitionLevelWriter> nestedWriterOptional, final ValuesWriter encoder) {
            Preconditions.checkArgument((boolean)nestedWriterOptional.isPresent(), (Object)"nestedWriter should be present for column map repetition level writer");
            return new RepLevelWriterProvider.RepetitionLevelWriter(){
                private final RepLevelWriterProvider.RepetitionLevelWriter nestedWriter;
                private int offset;
                {
                    this.nestedWriter = (RepLevelWriterProvider.RepetitionLevelWriter)nestedWriterOptional.orElseThrow();
                }

                @Override
                public void writeRepetitionLevels(int parentLevel) {
                    this.writeRepetitionLevels(parentLevel, columnarArray.getPositionCount());
                }

                @Override
                public void writeRepetitionLevels(int parentLevel, int positionsCount) {
                    RepLevelWriterProviders.checkValidPosition(this.offset, positionsCount, columnarArray.getPositionCount());
                    if (!columnarArray.mayHaveNull()) {
                        for (int position = this.offset; position < this.offset + positionsCount; ++position) {
                            this.writeNonNullableLevels(parentLevel, position);
                        }
                    } else {
                        for (int position = this.offset; position < this.offset + positionsCount; ++position) {
                            if (columnarArray.isNull(position)) {
                                encoder.writeInteger(parentLevel);
                                continue;
                            }
                            this.writeNonNullableLevels(parentLevel, position);
                        }
                    }
                    this.offset += positionsCount;
                }

                private void writeNonNullableLevels(int parentLevel, int position) {
                    int arrayLength = columnarArray.getLength(position);
                    if (arrayLength == 0) {
                        encoder.writeInteger(parentLevel);
                    } else {
                        this.nestedWriter.writeRepetitionLevels(parentLevel, 1);
                        this.nestedWriter.writeRepetitionLevels(maxRepetitionLevel, arrayLength - 1);
                    }
                }
            };
        }
    }

    static class ColumnMapRepLevelWriterProvider
    implements RepLevelWriterProvider {
        private final ColumnarMap columnarMap;
        private final int maxRepetitionLevel;

        ColumnMapRepLevelWriterProvider(ColumnarMap columnarMap, int maxRepetitionLevel) {
            this.columnarMap = Objects.requireNonNull(columnarMap, "columnarMap is null");
            this.maxRepetitionLevel = maxRepetitionLevel;
        }

        @Override
        public RepLevelWriterProvider.RepetitionLevelWriter getRepetitionLevelWriter(final Optional<RepLevelWriterProvider.RepetitionLevelWriter> nestedWriterOptional, final ValuesWriter encoder) {
            Preconditions.checkArgument((boolean)nestedWriterOptional.isPresent(), (Object)"nestedWriter should be present for column map repetition level writer");
            return new RepLevelWriterProvider.RepetitionLevelWriter(){
                private final RepLevelWriterProvider.RepetitionLevelWriter nestedWriter;
                private int offset;
                {
                    this.nestedWriter = (RepLevelWriterProvider.RepetitionLevelWriter)nestedWriterOptional.orElseThrow();
                }

                @Override
                public void writeRepetitionLevels(int parentLevel) {
                    this.writeRepetitionLevels(parentLevel, columnarMap.getPositionCount());
                }

                @Override
                public void writeRepetitionLevels(int parentLevel, int positionsCount) {
                    RepLevelWriterProviders.checkValidPosition(this.offset, positionsCount, columnarMap.getPositionCount());
                    if (!columnarMap.mayHaveNull()) {
                        for (int position = this.offset; position < this.offset + positionsCount; ++position) {
                            this.writeNonNullableLevels(parentLevel, position);
                        }
                    } else {
                        for (int position = this.offset; position < this.offset + positionsCount; ++position) {
                            if (columnarMap.isNull(position)) {
                                encoder.writeInteger(parentLevel);
                                continue;
                            }
                            this.writeNonNullableLevels(parentLevel, position);
                        }
                    }
                    this.offset += positionsCount;
                }

                private void writeNonNullableLevels(int parentLevel, int position) {
                    int entryLength = columnarMap.getEntryCount(position);
                    if (entryLength == 0) {
                        encoder.writeInteger(parentLevel);
                    } else {
                        this.nestedWriter.writeRepetitionLevels(parentLevel, 1);
                        this.nestedWriter.writeRepetitionLevels(maxRepetitionLevel, entryLength - 1);
                    }
                }
            };
        }
    }
}

