/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.trino.plugin.deltalake.DeltaHiveTypeTranslator;
import io.trino.plugin.deltalake.DeltaLakeColumnProjectionInfo;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class DeltaLakeColumnHandle
implements ColumnHandle {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(DeltaLakeColumnHandle.class);
    public static final String ROW_POSITION_COLUMN_NAME = "$row_position";
    public static final String ROW_ID_COLUMN_NAME = "$row_id";
    public static final Type MERGE_ROW_ID_TYPE = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"path", (Type)VarcharType.VARCHAR), RowType.field((String)"position", (Type)BigintType.BIGINT), RowType.field((String)"partition", (Type)VarcharType.VARCHAR)});
    public static final String PATH_COLUMN_NAME = "$path";
    public static final Type PATH_TYPE = VarcharType.VARCHAR;
    public static final String FILE_SIZE_COLUMN_NAME = "$file_size";
    public static final Type FILE_SIZE_TYPE = BigintType.BIGINT;
    public static final String FILE_MODIFIED_TIME_COLUMN_NAME = "$file_modified_time";
    public static final Type FILE_MODIFIED_TIME_TYPE = TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS;
    private final String baseColumnName;
    private final Type baseType;
    private final OptionalInt baseFieldId;
    private final String basePhysicalColumnName;
    private final Type basePhysicalType;
    private final DeltaLakeColumnType columnType;
    private final Optional<DeltaLakeColumnProjectionInfo> projectionInfo;

    @JsonCreator
    public DeltaLakeColumnHandle(@JsonProperty(value="baseColumnName") String baseColumnName, @JsonProperty(value="baseType") Type baseType, @JsonProperty(value="baseFieldId") OptionalInt baseFieldId, @JsonProperty(value="basePhysicalColumnName") String basePhysicalColumnName, @JsonProperty(value="basePhysicalType") Type basePhysicalType, @JsonProperty(value="columnType") DeltaLakeColumnType columnType, @JsonProperty(value="projectionInfo") Optional<DeltaLakeColumnProjectionInfo> projectionInfo) {
        this.baseColumnName = Objects.requireNonNull(baseColumnName, "baseColumnName is null");
        this.baseType = Objects.requireNonNull(baseType, "baseType is null");
        this.baseFieldId = Objects.requireNonNull(baseFieldId, "baseFieldId is null");
        this.basePhysicalColumnName = Objects.requireNonNull(basePhysicalColumnName, "basePhysicalColumnName is null");
        this.basePhysicalType = Objects.requireNonNull(basePhysicalType, "basePhysicalType is null");
        this.columnType = Objects.requireNonNull(columnType, "columnType is null");
        Preconditions.checkArgument((projectionInfo.isEmpty() || columnType == DeltaLakeColumnType.REGULAR ? 1 : 0) != 0, (String)"Projection info present for column type: %s", (Object)((Object)columnType));
        this.projectionInfo = projectionInfo;
    }

    @JsonProperty
    public String getBaseColumnName() {
        return this.baseColumnName;
    }

    @JsonProperty
    public Type getBaseType() {
        return this.baseType;
    }

    @JsonProperty
    public OptionalInt getBaseFieldId() {
        return this.baseFieldId;
    }

    @JsonProperty
    public String getBasePhysicalColumnName() {
        return this.basePhysicalColumnName;
    }

    @JsonProperty
    public Type getBasePhysicalType() {
        return this.basePhysicalType;
    }

    @JsonProperty
    public DeltaLakeColumnType getColumnType() {
        return this.columnType;
    }

    @JsonProperty
    public Optional<DeltaLakeColumnProjectionInfo> getProjectionInfo() {
        return this.projectionInfo;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DeltaLakeColumnHandle other = (DeltaLakeColumnHandle)obj;
        return Objects.equals(this.baseColumnName, other.baseColumnName) && Objects.equals(this.baseType, other.baseType) && Objects.equals(this.baseFieldId, other.baseFieldId) && Objects.equals(this.basePhysicalColumnName, other.basePhysicalColumnName) && Objects.equals(this.basePhysicalType, other.basePhysicalType) && this.columnType == other.columnType && Objects.equals(this.projectionInfo, other.projectionInfo);
    }

    @JsonIgnore
    public String getColumnName() {
        Preconditions.checkState((boolean)this.isBaseColumn(), (String)"Unexpected dereference: %s", (Object)this);
        return this.baseColumnName;
    }

    @JsonIgnore
    public String getQualifiedPhysicalName() {
        return this.projectionInfo.map(projectionInfo -> this.basePhysicalColumnName + "#" + projectionInfo.getPartialName()).orElse(this.basePhysicalColumnName);
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.baseColumnName) + SizeOf.sizeOf((OptionalInt)this.baseFieldId) + SizeOf.estimatedSizeOf((String)this.basePhysicalColumnName) + this.projectionInfo.map(DeltaLakeColumnProjectionInfo::getRetainedSizeInBytes).orElse(0L);
    }

    @JsonIgnore
    public boolean isBaseColumn() {
        return this.projectionInfo.isEmpty();
    }

    @JsonIgnore
    public Type getType() {
        return this.projectionInfo.map(DeltaLakeColumnProjectionInfo::getType).orElse(this.baseType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.baseColumnName, this.baseType, this.baseFieldId, this.basePhysicalColumnName, this.basePhysicalType, this.columnType, this.projectionInfo});
    }

    public String toString() {
        return this.getQualifiedPhysicalName() + ":" + this.projectionInfo.map(DeltaLakeColumnProjectionInfo::getType).orElse(this.baseType).getDisplayName() + ":" + this.columnType;
    }

    public HiveColumnHandle toHiveColumnHandle() {
        return new HiveColumnHandle(this.basePhysicalColumnName, 0, DeltaHiveTypeTranslator.toHiveType(this.basePhysicalType), this.basePhysicalType, this.projectionInfo.map(DeltaLakeColumnProjectionInfo::toHiveColumnProjectionInfo), this.columnType.toHiveColumnType(), Optional.empty());
    }

    public static DeltaLakeColumnHandle rowPositionColumnHandle() {
        return new DeltaLakeColumnHandle(ROW_POSITION_COLUMN_NAME, (Type)BigintType.BIGINT, OptionalInt.empty(), ROW_POSITION_COLUMN_NAME, (Type)BigintType.BIGINT, DeltaLakeColumnType.SYNTHESIZED, Optional.empty());
    }

    public static DeltaLakeColumnHandle pathColumnHandle() {
        return new DeltaLakeColumnHandle(PATH_COLUMN_NAME, PATH_TYPE, OptionalInt.empty(), PATH_COLUMN_NAME, PATH_TYPE, DeltaLakeColumnType.SYNTHESIZED, Optional.empty());
    }

    public static DeltaLakeColumnHandle fileSizeColumnHandle() {
        return new DeltaLakeColumnHandle(FILE_SIZE_COLUMN_NAME, FILE_SIZE_TYPE, OptionalInt.empty(), FILE_SIZE_COLUMN_NAME, FILE_SIZE_TYPE, DeltaLakeColumnType.SYNTHESIZED, Optional.empty());
    }

    public static DeltaLakeColumnHandle fileModifiedTimeColumnHandle() {
        return new DeltaLakeColumnHandle(FILE_MODIFIED_TIME_COLUMN_NAME, FILE_MODIFIED_TIME_TYPE, OptionalInt.empty(), FILE_MODIFIED_TIME_COLUMN_NAME, FILE_MODIFIED_TIME_TYPE, DeltaLakeColumnType.SYNTHESIZED, Optional.empty());
    }

    public static DeltaLakeColumnHandle mergeRowIdColumnHandle() {
        return new DeltaLakeColumnHandle(ROW_ID_COLUMN_NAME, MERGE_ROW_ID_TYPE, OptionalInt.empty(), ROW_ID_COLUMN_NAME, MERGE_ROW_ID_TYPE, DeltaLakeColumnType.SYNTHESIZED, Optional.empty());
    }
}

