/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigurationAwareModule;
import io.trino.plugin.base.security.FileBasedAccessControlModule;
import io.trino.plugin.base.security.ReadOnlySecurityModule;
import io.trino.plugin.deltalake.DeltaLakeAccessControlMetadataFactory;
import io.trino.plugin.deltalake.DeltaLakeSecurityConfig;
import io.trino.plugin.hive.security.AllowAllSecurityModule;

public class DeltaLakeSecurityModule
extends AbstractConfigurationAwareModule {
    public static final String FILE = "file";
    public static final String READ_ONLY = "read_only";
    public static final String ALLOW_ALL = "allow_all";

    protected void setup(Binder binder) {
        this.bindSecurityModule(ALLOW_ALL, ConfigurationAwareModule.combine((Module[])new Module[]{new AllowAllSecurityModule(), new StaticAccessControlMetadataModule()}));
        this.bindSecurityModule(READ_ONLY, ConfigurationAwareModule.combine((Module[])new Module[]{new ReadOnlySecurityModule(), new StaticAccessControlMetadataModule()}));
        this.bindSecurityModule(FILE, ConfigurationAwareModule.combine((Module[])new Module[]{new FileBasedAccessControlModule(), new StaticAccessControlMetadataModule()}));
    }

    protected void bindSecurityModule(String name, Module module) {
        this.install(ConditionalModule.conditionalModule(DeltaLakeSecurityConfig.class, security -> name.equalsIgnoreCase(security.getSecuritySystem().replace("-", "_")), (Module)module));
    }

    private static class StaticAccessControlMetadataModule
    implements Module {
        private StaticAccessControlMetadataModule() {
        }

        public void configure(Binder binder) {
            OptionalBinder.newOptionalBinder((Binder)binder, DeltaLakeAccessControlMetadataFactory.class).setBinding().toInstance((Object)DeltaLakeAccessControlMetadataFactory.DEFAULT);
        }
    }
}

