/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.delete;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoInputFile;
import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.delete.Base85Codec;
import io.trino.plugin.deltalake.transactionlog.DeletionVectorEntry;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;
import org.roaringbitmap.RoaringBitmap;
import org.roaringbitmap.longlong.Roaring64NavigableMap;

public final class DeletionVectors {
    private static final int PORTABLE_ROARING_BITMAP_MAGIC_NUMBER = 1681511377;
    private static final String UUID_MARKER = "u";
    private static final String PATH_MARKER = "p";
    private static final String INLINE_MARKER = "i";
    private static final CharMatcher ALPHANUMERIC = CharMatcher.inRange((char)'A', (char)'Z').or(CharMatcher.inRange((char)'a', (char)'z')).or(CharMatcher.inRange((char)'0', (char)'9')).precomputed();

    private DeletionVectors() {
    }

    public static Roaring64NavigableMap readDeletionVectors(TrinoFileSystem fileSystem, Location location, DeletionVectorEntry deletionVector) throws IOException {
        if (deletionVector.storageType().equals(UUID_MARKER)) {
            TrinoInputFile inputFile = fileSystem.newInputFile(location.appendPath(DeletionVectors.toFileName(deletionVector.pathOrInlineDv())));
            byte[] buffer = DeletionVectors.readDeletionVector(inputFile, deletionVector.offset().orElseThrow(), deletionVector.sizeInBytes());
            Roaring64NavigableMap bitmaps = DeletionVectors.deserializeDeletionVectors(buffer);
            if (bitmaps.getLongCardinality() != deletionVector.cardinality()) {
                throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "The number of deleted rows expects %s but got %s".formatted(deletionVector.cardinality(), bitmaps.getLongCardinality()));
            }
            return bitmaps;
        }
        if (deletionVector.storageType().equals(INLINE_MARKER) || deletionVector.storageType().equals(PATH_MARKER)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported storage type for deletion vector: " + deletionVector.storageType());
        }
        throw new IllegalArgumentException("Unexpected storage type: " + deletionVector.storageType());
    }

    public static String toFileName(String pathOrInlineDv) {
        int randomPrefixLength = pathOrInlineDv.length() - 20;
        String randomPrefix = pathOrInlineDv.substring(0, randomPrefixLength);
        Preconditions.checkArgument((boolean)ALPHANUMERIC.matchesAllOf((CharSequence)randomPrefix), (String)"Random prefix must be alphanumeric: %s", (Object)randomPrefix);
        Object prefix = randomPrefix.isEmpty() ? "" : randomPrefix + "/";
        String encodedUuid = pathOrInlineDv.substring(randomPrefixLength);
        UUID uuid = DeletionVectors.decodeUuid(encodedUuid);
        return "%sdeletion_vector_%s.bin".formatted(prefix, uuid);
    }

    public static byte[] readDeletionVector(TrinoInputFile inputFile, int offset, int expectedSize) throws IOException {
        byte[] bytes = new byte[expectedSize];
        try (DataInputStream inputStream = new DataInputStream((InputStream)inputFile.newStream());){
            Preconditions.checkState((inputStream.skip(offset) == (long)offset ? 1 : 0) != 0);
            int actualSize = inputStream.readInt();
            if (actualSize != expectedSize) {
                throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "The size of deletion vector %s expects %s but got %s".formatted(inputFile.location(), expectedSize, actualSize));
            }
            inputStream.readFully(bytes);
        }
        return bytes;
    }

    private static Roaring64NavigableMap deserializeDeletionVectors(byte[] bytes) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
        Preconditions.checkArgument((buffer.order() == ByteOrder.LITTLE_ENDIAN ? 1 : 0) != 0, (String)"Byte order must be little endian: %s", (Object)buffer.order());
        int magicNumber = buffer.getInt();
        if (magicNumber == 1681511377) {
            int size = Math.toIntExact(buffer.getLong());
            Roaring64NavigableMap bitmaps = new Roaring64NavigableMap();
            for (int i = 0; i < size; ++i) {
                int key = buffer.getInt();
                Preconditions.checkArgument((key >= 0 ? 1 : 0) != 0, (String)"key must not be negative: %s", (int)key);
                RoaringBitmap bitmap = new RoaringBitmap();
                bitmap.deserialize(buffer);
                bitmap.stream().forEach(xva$0 -> bitmaps.add(new long[]{xva$0}));
                int consumedBytes = bitmap.serializedSizeInBytes();
                buffer.position(buffer.position() + consumedBytes);
            }
            return bitmaps;
        }
        throw new IllegalArgumentException("Unsupported magic number: " + magicNumber);
    }

    public static UUID decodeUuid(String encoded) {
        byte[] bytes = Base85Codec.decode(encoded);
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        Preconditions.checkArgument((buffer.remaining() == 16 ? 1 : 0) != 0);
        long highBits = buffer.getLong();
        long lowBits = buffer.getLong();
        return new UUID(highBits, lowBits);
    }
}

