/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.functions.tablechanges;

import com.google.inject.Inject;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.plugin.deltalake.DeltaLakeConfig;
import io.trino.plugin.deltalake.functions.tablechanges.TableChangesFunctionProcessor;
import io.trino.plugin.deltalake.functions.tablechanges.TableChangesSplit;
import io.trino.plugin.deltalake.functions.tablechanges.TableChangesTableFunctionHandle;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.function.table.TableFunctionProcessorProvider;
import io.trino.spi.function.table.TableFunctionSplitProcessor;
import java.util.Objects;
import org.joda.time.DateTimeZone;

public class TableChangesProcessorProvider
implements TableFunctionProcessorProvider {
    private final TrinoFileSystemFactory fileSystemFactory;
    private final DateTimeZone parquetDateTimeZone;
    private final int domainCompactionThreshold;
    private final FileFormatDataSourceStats fileFormatDataSourceStats;
    private final ParquetReaderOptions parquetReaderOptions;

    @Inject
    public TableChangesProcessorProvider(TrinoFileSystemFactory fileSystemFactory, DeltaLakeConfig deltaLakeConfig, FileFormatDataSourceStats fileFormatDataSourceStats, ParquetReaderConfig parquetReaderConfig) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.parquetDateTimeZone = deltaLakeConfig.getParquetDateTimeZone();
        this.domainCompactionThreshold = deltaLakeConfig.getDomainCompactionThreshold();
        this.fileFormatDataSourceStats = Objects.requireNonNull(fileFormatDataSourceStats, "fileFormatDataSourceStats is null");
        this.parquetReaderOptions = parquetReaderConfig.toParquetReaderOptions();
    }

    public TableFunctionSplitProcessor getSplitProcessor(ConnectorSession session, ConnectorTableFunctionHandle handle, ConnectorSplit split) {
        return new TableChangesFunctionProcessor(session, this.fileSystemFactory, this.parquetDateTimeZone, this.domainCompactionThreshold, this.fileFormatDataSourceStats, this.parquetReaderOptions, (TableChangesTableFunctionHandle)handle, (TableChangesSplit)split);
    }
}

