/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.metastore;

import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.metastore.DeltaLakeMetastore;
import io.trino.plugin.deltalake.metastore.DeltaMetastoreTable;
import io.trino.plugin.deltalake.metastore.NotADeltaLakeTableException;
import io.trino.plugin.hive.TableType;
import io.trino.plugin.hive.ViewReaderUtil;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.Table;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class HiveMetastoreBackedDeltaLakeMetastore
implements DeltaLakeMetastore {
    public static final String TABLE_PROVIDER_PROPERTY = "spark.sql.sources.provider";
    public static final String TABLE_PROVIDER_VALUE = "DELTA";
    private final HiveMetastore delegate;

    public HiveMetastoreBackedDeltaLakeMetastore(HiveMetastore delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    @Override
    public List<String> getAllDatabases() {
        return this.delegate.getAllDatabases();
    }

    @Override
    public Optional<Database> getDatabase(String databaseName) {
        return this.delegate.getDatabase(databaseName);
    }

    @Override
    public List<String> getAllTables(String databaseName) {
        return this.delegate.getAllTables(databaseName);
    }

    @Override
    public Optional<Table> getRawMetastoreTable(String databaseName, String tableName) {
        return this.delegate.getTable(databaseName, tableName);
    }

    @Override
    public Optional<DeltaMetastoreTable> getTable(String databaseName, String tableName) {
        return this.getRawMetastoreTable(databaseName, tableName).map(table -> {
            HiveMetastoreBackedDeltaLakeMetastore.verifyDeltaLakeTable(table);
            return new DeltaMetastoreTable(new SchemaTableName(databaseName, tableName), table.getTableType().equals(TableType.MANAGED_TABLE.name()), HiveMetastoreBackedDeltaLakeMetastore.getTableLocation(table));
        });
    }

    public static void verifyDeltaLakeTable(Table table) {
        if (ViewReaderUtil.isSomeKindOfAView((Table)table)) {
            throw new NotADeltaLakeTableException(table.getDatabaseName(), table.getTableName());
        }
        if (!TABLE_PROVIDER_VALUE.equalsIgnoreCase((String)table.getParameters().get(TABLE_PROVIDER_PROPERTY))) {
            throw new NotADeltaLakeTableException(table.getDatabaseName(), table.getTableName());
        }
    }

    @Override
    public void createDatabase(Database database) {
        this.delegate.createDatabase(database);
    }

    @Override
    public void dropDatabase(String databaseName, boolean deleteData) {
        this.delegate.dropDatabase(databaseName, deleteData);
    }

    @Override
    public void createTable(ConnectorSession session, Table table, PrincipalPrivileges principalPrivileges) {
        this.delegate.createTable(table, principalPrivileges);
    }

    @Override
    public void dropTable(ConnectorSession session, SchemaTableName schemaTableName, String tableLocation, boolean deleteData) {
        this.delegate.dropTable(schemaTableName.getSchemaName(), schemaTableName.getTableName(), deleteData);
    }

    @Override
    public void renameTable(ConnectorSession session, SchemaTableName from, SchemaTableName to) {
        this.delegate.renameTable(from.getSchemaName(), from.getTableName(), to.getSchemaName(), to.getTableName());
    }

    public static String getTableLocation(Table table) {
        Map serdeParameters = table.getStorage().getSerdeParameters();
        String location = (String)serdeParameters.get("path");
        if (location == null) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, String.format("No %s property defined for table: %s", "path", table));
        }
        return location;
    }
}

