/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.procedure;

import com.google.inject.Inject;
import com.google.inject.Provider;
import io.trino.plugin.base.util.Procedures;
import io.trino.plugin.deltalake.DeltaLakeMetadata;
import io.trino.plugin.deltalake.DeltaLakeMetadataFactory;
import io.trino.plugin.deltalake.LocatedTableHandle;
import io.trino.plugin.deltalake.statistics.ExtendedStatisticsAccess;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;

public class DropExtendedStatsProcedure
implements Provider<Procedure> {
    private static final MethodHandle PROCEDURE_METHOD;
    private final DeltaLakeMetadataFactory metadataFactory;
    private final ExtendedStatisticsAccess statsAccess;

    @Inject
    public DropExtendedStatsProcedure(DeltaLakeMetadataFactory metadataFactory, ExtendedStatisticsAccess statsAccess) {
        this.metadataFactory = Objects.requireNonNull(metadataFactory, "metadataFactory");
        this.statsAccess = Objects.requireNonNull(statsAccess, "statsAccess");
    }

    public Procedure get() {
        return new Procedure("system", "drop_extended_stats", List.of(new Procedure.Argument("SCHEMA_NAME", (Type)VarcharType.VARCHAR), new Procedure.Argument("TABLE_NAME", (Type)VarcharType.VARCHAR)), PROCEDURE_METHOD.bindTo(this));
    }

    public void dropStats(ConnectorSession session, ConnectorAccessControl accessControl, String schema, String table) {
        Procedures.checkProcedureArgument((schema != null ? 1 : 0) != 0, (String)"schema_name cannot be null", (Object[])new Object[0]);
        Procedures.checkProcedureArgument((table != null ? 1 : 0) != 0, (String)"table_name cannot be null", (Object[])new Object[0]);
        SchemaTableName name = new SchemaTableName(schema, table);
        DeltaLakeMetadata metadata = this.metadataFactory.create(session.getIdentity());
        LocatedTableHandle tableHandle = metadata.getTableHandle(session, name);
        if (tableHandle == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, String.format("Table '%s' does not exist", name));
        }
        accessControl.checkCanInsertIntoTable(null, name);
        this.statsAccess.deleteExtendedStatistics(session, name, tableHandle.location());
    }

    static {
        try {
            PROCEDURE_METHOD = MethodHandles.lookup().unreflect(DropExtendedStatsProcedure.class.getMethod("dropStats", ConnectorSession.class, ConnectorAccessControl.class, String.class, String.class));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

