/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.procedure;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.filesystem.FileEntry;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.base.util.Procedures;
import io.trino.plugin.deltalake.DeltaLakeMetadata;
import io.trino.plugin.deltalake.DeltaLakeMetadataFactory;
import io.trino.plugin.deltalake.DeltaLakeSessionProperties;
import io.trino.plugin.deltalake.DeltaLakeTableHandle;
import io.trino.plugin.deltalake.LocatedTableHandle;
import io.trino.plugin.deltalake.transactionlog.AddFileEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.deltalake.transactionlog.RemoveFileEntry;
import io.trino.plugin.deltalake.transactionlog.TableSnapshot;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.deltalake.transactionlog.TransactionLogUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class VacuumProcedure
implements Provider<Procedure> {
    private static final Logger log = Logger.get(VacuumProcedure.class);
    private static final int DELETE_BATCH_SIZE = 1000;
    private static final MethodHandle VACUUM;
    private final CatalogName catalogName;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final DeltaLakeMetadataFactory metadataFactory;
    private final TransactionLogAccess transactionLogAccess;

    @Inject
    public VacuumProcedure(CatalogName catalogName, TrinoFileSystemFactory fileSystemFactory, DeltaLakeMetadataFactory metadataFactory, TransactionLogAccess transactionLogAccess) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.metadataFactory = Objects.requireNonNull(metadataFactory, "metadataFactory is null");
        this.transactionLogAccess = Objects.requireNonNull(transactionLogAccess, "transactionLogAccess is null");
    }

    public Procedure get() {
        return new Procedure("system", "vacuum", (List)ImmutableList.of((Object)new Procedure.Argument("SCHEMA_NAME", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("TABLE_NAME", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("RETENTION", (Type)VarcharType.VARCHAR)), VACUUM.bindTo(this));
    }

    public void vacuum(ConnectorSession session, ConnectorAccessControl accessControl, String schema, String table, String retention) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            this.doVacuum(session, accessControl, schema, table, retention);
        }
        catch (TrinoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failure when vacuuming %s.%s with retention %s: %s", schema, table, retention, e), e);
        }
    }

    private void doVacuum(ConnectorSession session, ConnectorAccessControl accessControl, String schema, String table, String retention) throws IOException {
        Procedures.checkProcedureArgument((schema != null ? 1 : 0) != 0, (String)"schema_name cannot be null", (Object[])new Object[0]);
        Procedures.checkProcedureArgument((!schema.isEmpty() ? 1 : 0) != 0, (String)"schema_name cannot be empty", (Object[])new Object[0]);
        Procedures.checkProcedureArgument((table != null ? 1 : 0) != 0, (String)"table_name cannot be null", (Object[])new Object[0]);
        Procedures.checkProcedureArgument((!table.isEmpty() ? 1 : 0) != 0, (String)"table_name cannot be empty", (Object[])new Object[0]);
        Procedures.checkProcedureArgument((retention != null ? 1 : 0) != 0, (String)"retention cannot be null", (Object[])new Object[0]);
        Duration retentionDuration = Duration.valueOf((String)retention);
        Duration minRetention = DeltaLakeSessionProperties.getVacuumMinRetention(session);
        Procedures.checkProcedureArgument((retentionDuration.compareTo(minRetention) >= 0 ? 1 : 0) != 0, (String)"Retention specified (%s) is shorter than the minimum retention configured in the system (%s). Minimum retention can be changed with %s configuration property or %s.%s session property", (Object[])new Object[]{retentionDuration, minRetention, "delta.vacuum.min-retention", this.catalogName, "vacuum_min_retention"});
        Instant threshold = Instant.now().minusMillis(retentionDuration.toMillis());
        DeltaLakeMetadata metadata = this.metadataFactory.create(session.getIdentity());
        SchemaTableName tableName = new SchemaTableName(schema, table);
        LocatedTableHandle connectorTableHandle = metadata.getTableHandle(session, tableName);
        Procedures.checkProcedureArgument((connectorTableHandle != null ? 1 : 0) != 0, (String)"Table '%s' does not exist", (Object[])new Object[]{tableName});
        DeltaLakeTableHandle handle = DeltaLakeMetadata.checkValidTableHandle(connectorTableHandle);
        accessControl.checkCanInsertIntoTable(null, tableName);
        accessControl.checkCanDeleteFromTable(null, tableName);
        TableSnapshot tableSnapshot = this.transactionLogAccess.getSnapshot(session, tableName, handle.getLocation(), Optional.of(handle.getReadVersion()));
        ProtocolEntry protocolEntry = this.transactionLogAccess.getProtocolEntry(session, tableSnapshot);
        if (protocolEntry.getMinWriterVersion() > 7) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot execute vacuum procedure with %d writer version".formatted(protocolEntry.getMinWriterVersion()));
        }
        Set<String> unsupportedWriterFeatures = DeltaLakeSchemaSupport.unsupportedWriterFeatures(protocolEntry.getWriterFeatures().orElse((Set<String>)ImmutableSet.of()));
        if (!unsupportedWriterFeatures.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot execute vacuum procedure with %s writer features".formatted(unsupportedWriterFeatures));
        }
        String tableLocation = tableSnapshot.getTableLocation();
        String transactionLogDir = TransactionLogUtil.getTransactionLogDir(tableLocation);
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
        Object commonPathPrefix = tableLocation.endsWith("/") ? tableLocation : tableLocation + "/";
        String queryId = session.getQueryId();
        List<Long> recentVersions = this.transactionLogAccess.getPastTableVersions(fileSystem, transactionLogDir, threshold, tableSnapshot.getVersion());
        Set retainedPaths = (Set)Stream.concat(this.transactionLogAccess.getActiveFiles(tableSnapshot, session).stream().map(AddFileEntry::getPath), this.transactionLogAccess.getJsonEntries(fileSystem, transactionLogDir, (List)recentVersions.stream().sorted(Comparator.naturalOrder()).skip(1L).collect(ImmutableList.toImmutableList())).map(DeltaLakeTransactionLogEntry::getRemove).filter(Objects::nonNull).map(RemoveFileEntry::getPath)).peek(path -> Preconditions.checkState((!path.startsWith(tableLocation) ? 1 : 0) != 0, (String)"Unexpected absolute path in transaction log: %s", (Object)path)).collect(ImmutableSet.toImmutableSet());
        log.debug("[%s] attempting to vacuum table %s [%s] with %s retention (expiry threshold %s). %s data file paths marked for retention", new Object[]{queryId, tableName, tableLocation, retention, threshold, retainedPaths.size()});
        long allPathsChecked = 0L;
        long transactionLogFiles = 0L;
        long retainedKnownFiles = 0L;
        long retainedUnknownFiles = 0L;
        long removedFiles = 0L;
        ArrayList<Location> filesToDelete = new ArrayList<Location>();
        FileIterator listing = fileSystem.listFiles(Location.of((String)tableLocation));
        while (listing.hasNext()) {
            FileEntry entry = listing.next();
            String location = entry.location().toString();
            Preconditions.checkState((boolean)location.startsWith((String)commonPathPrefix), (String)"Unexpected path [%s] returned when listing files under [%s]", (Object)location, (Object)tableLocation);
            String relativePath = location.substring(((String)commonPathPrefix).length());
            if (relativePath.isEmpty()) continue;
            ++allPathsChecked;
            if (relativePath.equals("_delta_log") || relativePath.startsWith("_delta_log/")) {
                log.debug("[%s] skipping a file inside transaction log dir: %s", new Object[]{queryId, location});
                ++transactionLogFiles;
                continue;
            }
            if (retainedPaths.contains(relativePath)) {
                log.debug("[%s] retaining a known file: %s", new Object[]{queryId, location});
                ++retainedKnownFiles;
                continue;
            }
            Instant modificationTime = entry.lastModified();
            if (!modificationTime.isBefore(threshold)) {
                log.debug("[%s] retaining an unknown file %s with modification time %s", new Object[]{queryId, location, modificationTime});
                ++retainedUnknownFiles;
                continue;
            }
            log.debug("[%s] deleting file [%s] with modification time %s", new Object[]{queryId, location, modificationTime});
            filesToDelete.add(entry.location());
            if (filesToDelete.size() != 1000) continue;
            fileSystem.deleteFiles(filesToDelete);
            removedFiles += (long)filesToDelete.size();
            filesToDelete.clear();
        }
        if (!filesToDelete.isEmpty()) {
            fileSystem.deleteFiles(filesToDelete);
            removedFiles += (long)filesToDelete.size();
        }
        log.info("[%s] finished vacuuming table %s [%s]: files checked: %s; metadata files: %s; retained known files: %s; retained unknown files: %s; removed files: %s", new Object[]{queryId, tableName, tableLocation, allPathsChecked, transactionLogFiles, retainedKnownFiles, retainedUnknownFiles, removedFiles});
    }

    static {
        try {
            VACUUM = MethodHandles.lookup().unreflect(VacuumProcedure.class.getMethod("vacuum", ConnectorSession.class, ConnectorAccessControl.class, String.class, String.class, String.class));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

