/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog.checkpoint;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.math.LongMath;
import io.airlift.log.Logger;
import io.trino.filesystem.TrinoInputFile;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnMetadata;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.transactionlog.AddFileEntry;
import io.trino.plugin.deltalake.transactionlog.CommitInfoEntry;
import io.trino.plugin.deltalake.transactionlog.DeletionVectorEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.deltalake.transactionlog.RemoveFileEntry;
import io.trino.plugin.deltalake.transactionlog.TransactionEntry;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.deltalake.transactionlog.TransactionLogParser;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointSchemaManager;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeParquetFileStatistics;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveColumnProjectionInfo;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.ReaderPageSource;
import io.trino.plugin.hive.parquet.ParquetPageSourceFactory;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeUtils;
import io.trino.spi.type.VarcharType;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Queue;
import java.util.Set;
import org.joda.time.DateTimeZone;

public class CheckpointEntryIterator
extends AbstractIterator<DeltaLakeTransactionLogEntry> {
    private static final Logger log = Logger.get(CheckpointEntryIterator.class);
    private final String checkpointPath;
    private final ConnectorSession session;
    private final ConnectorPageSource pageSource;
    private final MapType stringMap;
    private final ArrayType stringList;
    private final Queue<DeltaLakeTransactionLogEntry> nextEntries;
    private final List<CheckPointFieldExtractor> extractors;
    private final boolean checkpointRowStatisticsWritingEnabled;
    private MetadataEntry metadataEntry;
    private ProtocolEntry protocolEntry;
    private List<DeltaLakeColumnMetadata> schema;
    private Page page;
    private long pageIndex;
    private int pagePosition;

    public CheckpointEntryIterator(TrinoInputFile checkpoint, ConnectorSession session, long fileSize, CheckpointSchemaManager checkpointSchemaManager, TypeManager typeManager, Set<EntryType> fields, Optional<MetadataEntry> metadataEntry, Optional<ProtocolEntry> protocolEntry, FileFormatDataSourceStats stats, ParquetReaderOptions parquetReaderOptions, boolean checkpointRowStatisticsWritingEnabled, int domainCompactionThreshold) {
        List columns;
        this.checkpointPath = checkpoint.location().toString();
        this.session = Objects.requireNonNull(session, "session is null");
        this.stringList = (ArrayType)typeManager.getType(TypeSignature.arrayType((TypeSignature)VarcharType.VARCHAR.getTypeSignature()));
        this.stringMap = (MapType)typeManager.getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature()));
        this.checkpointRowStatisticsWritingEnabled = checkpointRowStatisticsWritingEnabled;
        Preconditions.checkArgument((fields.size() > 0 ? 1 : 0) != 0, (Object)"fields is empty");
        ImmutableMap extractors = ImmutableMap.builder().put((Object)EntryType.TRANSACTION, this::buildTxnEntry).put((Object)EntryType.ADD, this::buildAddEntry).put((Object)EntryType.REMOVE, this::buildRemoveEntry).put((Object)EntryType.METADATA, this::buildMetadataEntry).put((Object)EntryType.PROTOCOL, this::buildProtocolEntry).put((Object)EntryType.COMMIT, this::buildCommitInfoEntry).buildOrThrow();
        if (fields.contains((Object)EntryType.ADD)) {
            Preconditions.checkArgument((boolean)metadataEntry.isPresent(), (Object)"Metadata entry must be provided when reading ADD entries from Checkpoint files");
            this.metadataEntry = metadataEntry.get();
            Preconditions.checkArgument((boolean)protocolEntry.isPresent(), (Object)"Protocol entry must be provided when reading ADD entries from Checkpoint files");
            this.protocolEntry = protocolEntry.get();
            this.schema = DeltaLakeSchemaSupport.extractSchema(this.metadataEntry, this.protocolEntry, typeManager);
        }
        TupleDomain<HiveColumnHandle> tupleDomain = (columns = (List)fields.stream().map(field -> this.buildColumnHandle((EntryType)((Object)field), checkpointSchemaManager, this.metadataEntry, this.protocolEntry).toHiveColumnHandle()).collect(ImmutableList.toImmutableList())).size() > 1 ? TupleDomain.all() : this.buildTupleDomainColumnHandle((EntryType)((Object)Iterables.getOnlyElement(fields)), (HiveColumnHandle)Iterables.getOnlyElement((Iterable)columns));
        ReaderPageSource pageSource = ParquetPageSourceFactory.createPageSource((TrinoInputFile)checkpoint, (long)0L, (long)fileSize, (List)columns, tupleDomain, (boolean)true, (DateTimeZone)DateTimeZone.UTC, (FileFormatDataSourceStats)stats, (ParquetReaderOptions)parquetReaderOptions, Optional.empty(), (int)domainCompactionThreshold, (OptionalLong)OptionalLong.empty());
        Verify.verify((boolean)pageSource.getReaderColumns().isEmpty(), (String)"All columns expected to be base columns", (Object[])new Object[0]);
        this.pageSource = pageSource.get();
        this.nextEntries = new ArrayDeque<DeltaLakeTransactionLogEntry>();
        this.extractors = (List)fields.stream().map(arg_0 -> CheckpointEntryIterator.lambda$new$1((Map)extractors, arg_0)).collect(ImmutableList.toImmutableList());
    }

    private DeltaLakeColumnHandle buildColumnHandle(EntryType entryType, CheckpointSchemaManager schemaManager, MetadataEntry metadataEntry, ProtocolEntry protocolEntry) {
        RowType type = switch (entryType) {
            default -> throw new IncompatibleClassChangeError();
            case EntryType.TRANSACTION -> schemaManager.getTxnEntryType();
            case EntryType.ADD -> schemaManager.getAddEntryType(metadataEntry, protocolEntry, true, true);
            case EntryType.REMOVE -> schemaManager.getRemoveEntryType();
            case EntryType.METADATA -> schemaManager.getMetadataEntryType();
            case EntryType.PROTOCOL -> schemaManager.getProtocolEntryType(true, true);
            case EntryType.COMMIT -> schemaManager.getCommitInfoEntryType();
        };
        return new DeltaLakeColumnHandle(entryType.getColumnName(), (Type)type, OptionalInt.empty(), entryType.getColumnName(), (Type)type, DeltaLakeColumnType.REGULAR, Optional.empty());
    }

    private TupleDomain<HiveColumnHandle> buildTupleDomainColumnHandle(EntryType entryType, HiveColumnHandle column) {
        String field;
        BigintType type = switch (entryType) {
            case EntryType.TRANSACTION, EntryType.COMMIT -> {
                field = "version";
                yield BigintType.BIGINT;
            }
            case EntryType.ADD, EntryType.REMOVE -> {
                field = "path";
                yield VarcharType.VARCHAR;
            }
            case EntryType.METADATA -> {
                field = "id";
                yield VarcharType.VARCHAR;
            }
            case EntryType.PROTOCOL -> {
                field = "minReaderVersion";
                yield BigintType.BIGINT;
            }
            default -> throw new IllegalArgumentException("Unsupported Delta Lake checkpoint entry type: " + entryType);
        };
        HiveColumnHandle handle = new HiveColumnHandle(column.getBaseColumnName(), column.getBaseHiveColumnIndex(), column.getBaseHiveType(), column.getBaseType(), Optional.of(new HiveColumnProjectionInfo((List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)field), HiveType.toHiveType((Type)type), (Type)type)), HiveColumnHandle.ColumnType.REGULAR, column.getComment());
        return TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)handle, (Object)Domain.notNull((Type)handle.getType())));
    }

    private DeltaLakeTransactionLogEntry buildCommitInfoEntry(ConnectorSession session, Block block, int pagePosition) {
        log.debug("Building commitInfo entry from %s pagePosition %d", new Object[]{block, pagePosition});
        if (block.isNull(pagePosition)) {
            return null;
        }
        int commitInfoFields = 12;
        int jobFields = 5;
        int notebookFields = 1;
        Block commitInfoEntryBlock = (Block)block.getObject(pagePosition, Block.class);
        log.debug("Block %s has %s fields", new Object[]{block, commitInfoEntryBlock.getPositionCount()});
        if (commitInfoEntryBlock.getPositionCount() != commitInfoFields) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, String.format("Expected block %s to have %d children, but found %s", block, commitInfoFields, commitInfoEntryBlock.getPositionCount()));
        }
        Block jobBlock = (Block)commitInfoEntryBlock.getObject(6, Block.class);
        if (jobBlock.getPositionCount() != jobFields) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, String.format("Expected block %s to have %d children, but found %s", jobBlock, jobFields, jobBlock.getPositionCount()));
        }
        Block notebookBlock = (Block)commitInfoEntryBlock.getObject(7, Block.class);
        if (notebookBlock.getPositionCount() != notebookFields) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, String.format("Expected block %s to have %d children, but found %s", notebookBlock, notebookFields, notebookBlock.getPositionCount()));
        }
        CommitInfoEntry result = new CommitInfoEntry(this.getLong(commitInfoEntryBlock, 0), this.getLong(commitInfoEntryBlock, 1), this.getString(commitInfoEntryBlock, 2), this.getString(commitInfoEntryBlock, 3), this.getString(commitInfoEntryBlock, 4), this.getMap(commitInfoEntryBlock, 5), new CommitInfoEntry.Job(this.getString(jobBlock, 0), this.getString(jobBlock, 1), this.getString(jobBlock, 2), this.getString(jobBlock, 3), this.getString(jobBlock, 4)), new CommitInfoEntry.Notebook(this.getString(notebookBlock, 0)), this.getString(commitInfoEntryBlock, 8), this.getLong(commitInfoEntryBlock, 9), this.getString(commitInfoEntryBlock, 10), Optional.of(this.getByte(commitInfoEntryBlock, 11) != 0));
        log.debug("Result: %s", new Object[]{result});
        return DeltaLakeTransactionLogEntry.commitInfoEntry(result);
    }

    private DeltaLakeTransactionLogEntry buildProtocolEntry(ConnectorSession session, Block block, int pagePosition) {
        log.debug("Building protocol entry from %s pagePosition %d", new Object[]{block, pagePosition});
        if (block.isNull(pagePosition)) {
            return null;
        }
        int minProtocolFields = 2;
        int maxProtocolFields = 4;
        Block protocolEntryBlock = (Block)block.getObject(pagePosition, Block.class);
        log.debug("Block %s has %s fields", new Object[]{block, protocolEntryBlock.getPositionCount()});
        if (protocolEntryBlock.getPositionCount() < minProtocolFields || protocolEntryBlock.getPositionCount() > maxProtocolFields) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, String.format("Expected block %s to have between %d and %d children, but found %s", block, minProtocolFields, maxProtocolFields, protocolEntryBlock.getPositionCount()));
        }
        int position = 0;
        ProtocolEntry result = new ProtocolEntry(this.getInt(protocolEntryBlock, position++), this.getInt(protocolEntryBlock, position++), protocolEntryBlock.getPositionCount() == 4 && protocolEntryBlock.isNull(position) ? Optional.empty() : Optional.of((Set)this.getList(protocolEntryBlock, position++).stream().collect(ImmutableSet.toImmutableSet())), protocolEntryBlock.isNull(position) ? Optional.empty() : Optional.of((Set)this.getList(protocolEntryBlock, position++).stream().collect(ImmutableSet.toImmutableSet())));
        log.debug("Result: %s", new Object[]{result});
        return DeltaLakeTransactionLogEntry.protocolEntry(result);
    }

    private DeltaLakeTransactionLogEntry buildMetadataEntry(ConnectorSession session, Block block, int pagePosition) {
        log.debug("Building metadata entry from %s pagePosition %d", new Object[]{block, pagePosition});
        if (block.isNull(pagePosition)) {
            return null;
        }
        int metadataFields = 8;
        int formatFields = 2;
        Block metadataEntryBlock = (Block)block.getObject(pagePosition, Block.class);
        log.debug("Block %s has %s fields", new Object[]{block, metadataEntryBlock.getPositionCount()});
        if (metadataEntryBlock.getPositionCount() != metadataFields) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, String.format("Expected block %s to have %d children, but found %s", block, metadataFields, metadataEntryBlock.getPositionCount()));
        }
        Block formatBlock = (Block)metadataEntryBlock.getObject(3, Block.class);
        if (formatBlock.getPositionCount() != formatFields) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, String.format("Expected block %s to have %d children, but found %s", formatBlock, formatFields, formatBlock.getPositionCount()));
        }
        MetadataEntry result = new MetadataEntry(this.getString(metadataEntryBlock, 0), this.getString(metadataEntryBlock, 1), this.getString(metadataEntryBlock, 2), new MetadataEntry.Format(this.getString(formatBlock, 0), this.getMap(formatBlock, 1)), this.getString(metadataEntryBlock, 4), this.getList(metadataEntryBlock, 5), this.getMap(metadataEntryBlock, 6), this.getLong(metadataEntryBlock, 7));
        log.debug("Result: %s", new Object[]{result});
        return DeltaLakeTransactionLogEntry.metadataEntry(result);
    }

    private DeltaLakeTransactionLogEntry buildRemoveEntry(ConnectorSession session, Block block, int pagePosition) {
        log.debug("Building remove entry from %s pagePosition %d", new Object[]{block, pagePosition});
        if (block.isNull(pagePosition)) {
            return null;
        }
        int removeFields = 3;
        Block removeEntryBlock = (Block)block.getObject(pagePosition, Block.class);
        log.debug("Block %s has %s fields", new Object[]{block, removeEntryBlock.getPositionCount()});
        if (removeEntryBlock.getPositionCount() != removeFields) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, String.format("Expected block %s to have %d children, but found %s", block, removeFields, removeEntryBlock.getPositionCount()));
        }
        RemoveFileEntry result = new RemoveFileEntry(this.getString(removeEntryBlock, 0), this.getLong(removeEntryBlock, 1), this.getByte(removeEntryBlock, 2) != 0);
        log.debug("Result: %s", new Object[]{result});
        return DeltaLakeTransactionLogEntry.removeFileEntry(result);
    }

    private DeltaLakeTransactionLogEntry buildAddEntry(ConnectorSession session, Block block, int pagePosition) {
        log.debug("Building add entry from %s pagePosition %d", new Object[]{block, pagePosition});
        if (block.isNull(pagePosition)) {
            return null;
        }
        boolean deletionVectorsEnabled = DeltaLakeSchemaSupport.isDeletionVectorEnabled(this.metadataEntry, this.protocolEntry);
        Block addEntryBlock = (Block)block.getObject(pagePosition, Block.class);
        log.debug("Block %s has %s fields", new Object[]{block, addEntryBlock.getPositionCount()});
        String path = this.getString(addEntryBlock, 0);
        Map<String, String> partitionValues = this.getMap(addEntryBlock, 1);
        long size = this.getLong(addEntryBlock, 2);
        long modificationTime = this.getLong(addEntryBlock, 3);
        boolean dataChange = this.getByte(addEntryBlock, 4) != 0;
        Optional<DeletionVectorEntry> deletionVector = Optional.empty();
        int position = 5;
        if (deletionVectorsEnabled) {
            if (!addEntryBlock.isNull(5)) {
                deletionVector = Optional.of(this.parseDeletionVectorFromParquet((Block)addEntryBlock.getObject(5, Block.class)));
            }
            position = 6;
        }
        Map<String, String> tags = this.getMap(addEntryBlock, position + 2);
        AddFileEntry result = !addEntryBlock.isNull(position + 1) ? new AddFileEntry(path, partitionValues, size, modificationTime, dataChange, Optional.empty(), Optional.of(this.parseStatisticsFromParquet((Block)addEntryBlock.getObject(position + 1, Block.class))), tags, deletionVector) : (!addEntryBlock.isNull(position) ? new AddFileEntry(path, partitionValues, size, modificationTime, dataChange, Optional.of(this.getString(addEntryBlock, position)), Optional.empty(), tags, deletionVector) : new AddFileEntry(path, partitionValues, size, modificationTime, dataChange, Optional.empty(), Optional.empty(), tags, deletionVector));
        log.debug("Result: %s", new Object[]{result});
        return DeltaLakeTransactionLogEntry.addFileEntry(result);
    }

    private DeletionVectorEntry parseDeletionVectorFromParquet(Block block) {
        Preconditions.checkArgument((block.getPositionCount() == 5 ? 1 : 0) != 0, (Object)"Deletion vector entry must have 5 fields");
        String storageType = this.getString(block, 0);
        String pathOrInlineDv = this.getString(block, 1);
        OptionalInt offset = block.isNull(2) ? OptionalInt.empty() : OptionalInt.of(this.getInt(block, 2));
        int sizeInBytes = this.getInt(block, 3);
        long cardinality = this.getLong(block, 4);
        return new DeletionVectorEntry(storageType, pathOrInlineDv, offset, sizeInBytes, cardinality);
    }

    private DeltaLakeParquetFileStatistics parseStatisticsFromParquet(Block statsRowBlock) {
        Optional<Map<String, Object>> nullCount;
        if (this.metadataEntry == null) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_DATA, "Checkpoint file found without metadata entry");
        }
        ImmutableList<DeltaLakeColumnMetadata> columnsWithMinMaxStats = TransactionLogAccess.columnsWithStats(this.schema, this.metadataEntry.getOriginalPartitionColumns());
        long numRecords = this.getLong(statsRowBlock, 0);
        Optional<Map<String, Object>> minValues = Optional.empty();
        Optional<Map<String, Object>> maxValues = Optional.empty();
        if (!columnsWithMinMaxStats.isEmpty()) {
            minValues = Optional.of(this.readMinMax(statsRowBlock, 1, (List<DeltaLakeColumnMetadata>)columnsWithMinMaxStats));
            maxValues = Optional.of(this.readMinMax(statsRowBlock, 2, (List<DeltaLakeColumnMetadata>)columnsWithMinMaxStats));
            nullCount = Optional.of(this.readNullCount(statsRowBlock, 3, this.schema));
        } else {
            nullCount = Optional.of(this.readNullCount(statsRowBlock, 1, this.schema));
        }
        return new DeltaLakeParquetFileStatistics(Optional.of(numRecords), minValues, maxValues, nullCount);
    }

    private Map<String, Object> readMinMax(Block block, int blockPosition, List<DeltaLakeColumnMetadata> eligibleColumns) {
        if (block.isNull(blockPosition)) {
            return ImmutableMap.of();
        }
        Block valuesBlock = (Block)block.getObject(blockPosition, Block.class);
        ImmutableMap.Builder values = ImmutableMap.builder();
        for (int i = 0; i < eligibleColumns.size(); ++i) {
            DeltaLakeColumnMetadata metadata = eligibleColumns.get(i);
            String name = metadata.getPhysicalName();
            Type type = metadata.getPhysicalColumnType();
            if (valuesBlock.isNull(i)) continue;
            if (type instanceof RowType) {
                if (!this.checkpointRowStatisticsWritingEnabled) continue;
                values.put((Object)name, (Object)valuesBlock.getSingleValueBlock(i));
                continue;
            }
            if (type instanceof TimestampWithTimeZoneType) {
                long epochMillis = LongMath.divide((long)((Long)TypeUtils.readNativeValue((Type)TimestampType.TIMESTAMP_MILLIS, (Block)valuesBlock, (int)i)), (long)1000L, (RoundingMode)RoundingMode.UNNECESSARY);
                if (Math.floorDiv(epochMillis, 86400000) < TransactionLogParser.START_OF_MODERN_ERA_EPOCH_DAY) continue;
                values.put((Object)name, (Object)DateTimeEncoding.packDateTimeWithZone((long)epochMillis, (TimeZoneKey)TimeZoneKey.UTC_KEY));
                continue;
            }
            values.put((Object)name, TypeUtils.readNativeValue((Type)type, (Block)valuesBlock, (int)i));
        }
        return values.buildOrThrow();
    }

    private Map<String, Object> readNullCount(Block block, int blockPosition, List<DeltaLakeColumnMetadata> columns) {
        if (block.isNull(blockPosition)) {
            return ImmutableMap.of();
        }
        Block valuesBlock = (Block)block.getObject(blockPosition, Block.class);
        ImmutableMap.Builder values = ImmutableMap.builder();
        for (int i = 0; i < columns.size(); ++i) {
            DeltaLakeColumnMetadata metadata = columns.get(i);
            if (valuesBlock.isNull(i)) continue;
            if (metadata.getType() instanceof RowType) {
                if (!this.checkpointRowStatisticsWritingEnabled) continue;
                values.put((Object)metadata.getPhysicalName(), (Object)valuesBlock.getSingleValueBlock(i));
                continue;
            }
            values.put((Object)metadata.getPhysicalName(), (Object)this.getLong(valuesBlock, i));
        }
        return values.buildOrThrow();
    }

    private DeltaLakeTransactionLogEntry buildTxnEntry(ConnectorSession session, Block block, int pagePosition) {
        log.debug("Building txn entry from %s pagePosition %d", new Object[]{block, pagePosition});
        if (block.isNull(pagePosition)) {
            return null;
        }
        int txnFields = 3;
        Block txnEntryBlock = (Block)block.getObject(pagePosition, Block.class);
        log.debug("Block %s has %s fields", new Object[]{block, txnEntryBlock.getPositionCount()});
        if (txnEntryBlock.getPositionCount() != txnFields) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, String.format("Expected block %s to have %d children, but found %s", block, txnFields, txnEntryBlock.getPositionCount()));
        }
        TransactionEntry result = new TransactionEntry(this.getString(txnEntryBlock, 0), this.getLong(txnEntryBlock, 1), this.getLong(txnEntryBlock, 2));
        log.debug("Result: %s", new Object[]{result});
        return DeltaLakeTransactionLogEntry.transactionEntry(result);
    }

    @Nullable
    private String getString(Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return block.getSlice(position, 0, block.getSliceLength(position)).toString(StandardCharsets.UTF_8);
    }

    private long getLong(Block block, int position) {
        Preconditions.checkArgument((!block.isNull(position) ? 1 : 0) != 0);
        return block.getLong(position, 0);
    }

    private int getInt(Block block, int position) {
        Preconditions.checkArgument((!block.isNull(position) ? 1 : 0) != 0);
        return block.getInt(position, 0);
    }

    private byte getByte(Block block, int position) {
        Preconditions.checkArgument((!block.isNull(position) ? 1 : 0) != 0);
        return block.getByte(position, 0);
    }

    private Map<String, String> getMap(Block block, int position) {
        return (Map)this.stringMap.getObjectValue(this.session, block, position);
    }

    private List<String> getList(Block block, int position) {
        return (List)this.stringList.getObjectValue(this.session, block, position);
    }

    protected DeltaLakeTransactionLogEntry computeNext() {
        if (this.nextEntries.isEmpty()) {
            this.fillNextEntries();
        }
        if (!this.nextEntries.isEmpty()) {
            return this.nextEntries.remove();
        }
        try {
            this.pageSource.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return (DeltaLakeTransactionLogEntry)this.endOfData();
    }

    private boolean tryAdvancePage() {
        if (this.pageSource.isFinished()) {
            try {
                this.pageSource.close();
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
            return false;
        }
        this.page = this.pageSource.getNextPage();
        if (this.page == null) {
            return false;
        }
        if (this.page.getChannelCount() != this.extractors.size()) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, String.format("Expected page %d (%s) in %s to contain %d channels, but found %d", this.pageIndex, this.page, this.checkpointPath, this.extractors.size(), this.page.getChannelCount()));
        }
        this.pagePosition = 0;
        ++this.pageIndex;
        return true;
    }

    private void fillNextEntries() {
        while (this.nextEntries.isEmpty()) {
            while (this.page == null || this.pagePosition == this.page.getPositionCount()) {
                if (this.tryAdvancePage()) continue;
                return;
            }
            for (int i = 0; i < this.extractors.size(); ++i) {
                DeltaLakeTransactionLogEntry entry = this.extractors.get(i).getEntry(this.session, this.page.getBlock(i).getLoadedBlock(), this.pagePosition);
                if (entry == null) continue;
                this.nextEntries.add(entry);
            }
            ++this.pagePosition;
        }
    }

    @VisibleForTesting
    OptionalLong getCompletedPositions() {
        return this.pageSource.getCompletedPositions();
    }

    private static /* synthetic */ CheckPointFieldExtractor lambda$new$1(Map extractors, EntryType field) {
        return Objects.requireNonNull((CheckPointFieldExtractor)extractors.get((Object)field), "No extractor found for field " + field);
    }

    public static enum EntryType {
        TRANSACTION("txn"),
        ADD("add"),
        REMOVE("remove"),
        METADATA("metadata"),
        PROTOCOL("protocol"),
        COMMIT("commitinfo");

        private final String columnName;

        private EntryType(String columnName) {
            this.columnName = columnName;
        }

        public String getColumnName() {
            return this.columnName;
        }
    }

    @FunctionalInterface
    public static interface CheckPointFieldExtractor {
        @Nullable
        public DeltaLakeTransactionLogEntry getEntry(ConnectorSession var1, Block var2, int var3);
    }
}

