/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.grpc;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.grpc.ChannelFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.grpc.RefreshingManagedChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.CallOptions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientCall;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ManagedChannel;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.MethodDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

class ChannelPool
extends ManagedChannel {
    private static final int CHANNEL_REFRESH_EXECUTOR_SIZE = 2;
    private final ImmutableList<ManagedChannel> channels;
    private final AtomicInteger indexTicker = new AtomicInteger();
    private final String authority;
    @Nullable
    private ScheduledExecutorService channelRefreshExecutorService;

    static ChannelPool create(int poolSize, ChannelFactory channelFactory) throws IOException {
        ArrayList<ManagedChannel> channels = new ArrayList<ManagedChannel>();
        for (int i = 0; i < poolSize; ++i) {
            channels.add(channelFactory.createSingleChannel());
        }
        return new ChannelPool(channels, null);
    }

    @VisibleForTesting
    static ChannelPool createRefreshing(int poolSize, ChannelFactory channelFactory, ScheduledExecutorService channelRefreshExecutorService) throws IOException {
        ArrayList<ManagedChannel> channels = new ArrayList<ManagedChannel>();
        for (int i = 0; i < poolSize; ++i) {
            channels.add(new RefreshingManagedChannel(channelFactory, channelRefreshExecutorService));
        }
        return new ChannelPool(channels, channelRefreshExecutorService);
    }

    static ChannelPool createRefreshing(int poolSize, ChannelFactory channelFactory) throws IOException {
        return ChannelPool.createRefreshing(poolSize, channelFactory, Executors.newScheduledThreadPool(2));
    }

    private ChannelPool(List<ManagedChannel> channels, @Nullable ScheduledExecutorService channelRefreshExecutorService) {
        this.channels = ImmutableList.copyOf(channels);
        this.authority = channels.get(0).authority();
        this.channelRefreshExecutorService = channelRefreshExecutorService;
    }

    @Override
    public String authority() {
        return this.authority;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions) {
        return this.getNextChannel().newCall(methodDescriptor, callOptions);
    }

    @Override
    public ManagedChannel shutdown() {
        for (ManagedChannel channelWrapper : this.channels) {
            channelWrapper.shutdown();
        }
        if (this.channelRefreshExecutorService != null) {
            this.channelRefreshExecutorService.shutdown();
        }
        return this;
    }

    @Override
    public boolean isShutdown() {
        for (ManagedChannel channel : this.channels) {
            if (channel.isShutdown()) continue;
            return false;
        }
        return this.channelRefreshExecutorService == null || this.channelRefreshExecutorService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        for (ManagedChannel channel : this.channels) {
            if (channel.isTerminated()) continue;
            return false;
        }
        return this.channelRefreshExecutorService == null || this.channelRefreshExecutorService.isTerminated();
    }

    @Override
    public ManagedChannel shutdownNow() {
        for (ManagedChannel channel : this.channels) {
            channel.shutdownNow();
        }
        if (this.channelRefreshExecutorService != null) {
            this.channelRefreshExecutorService.shutdownNow();
        }
        return this;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long endTimeNanos = System.nanoTime() + unit.toNanos(timeout);
        for (ManagedChannel channel : this.channels) {
            long awaitTimeNanos = endTimeNanos - System.nanoTime();
            if (awaitTimeNanos <= 0L) break;
            channel.awaitTermination(awaitTimeNanos, TimeUnit.NANOSECONDS);
        }
        if (this.channelRefreshExecutorService != null) {
            long awaitTimeNanos = endTimeNanos - System.nanoTime();
            this.channelRefreshExecutorService.awaitTermination(awaitTimeNanos, TimeUnit.NANOSECONDS);
        }
        return this.isTerminated();
    }

    private ManagedChannel getNextChannel() {
        return this.getChannel(this.indexTicker.getAndIncrement());
    }

    ManagedChannel getChannel(int affinity) {
        int index = affinity % this.channels.size();
        if ((index = Math.abs(index)) < 0) {
            index = 0;
        }
        return (ManagedChannel)this.channels.get(index);
    }
}

