/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.json.webtoken.JsonWebToken;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.util.Clock;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.Credentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.JwtClaims;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.JwtProvider;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2.OAuth2Utils;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class JwtCredentials
extends Credentials
implements JwtProvider {
    private static final String JWT_ACCESS_PREFIX = "Bearer ";
    private static final String JWT_INCOMPLETE_ERROR_MESSAGE = "JWT claims must contain audience, issuer, and subject.";
    private static final long CLOCK_SKEW = TimeUnit.MINUTES.toSeconds(5L);
    private final Object lock = new byte[0];
    private final PrivateKey privateKey;
    private final String privateKeyId;
    private final JwtClaims jwtClaims;
    private final Long lifeSpanSeconds;
    @VisibleForTesting
    transient Clock clock;
    private transient String jwt;
    private transient Long expiryInSeconds;

    private JwtCredentials(Builder builder) {
        this.privateKey = Preconditions.checkNotNull(builder.getPrivateKey());
        this.privateKeyId = builder.getPrivateKeyId();
        this.jwtClaims = Preconditions.checkNotNull(builder.getJwtClaims());
        Preconditions.checkState(this.jwtClaims.isComplete(), JWT_INCOMPLETE_ERROR_MESSAGE);
        this.lifeSpanSeconds = Preconditions.checkNotNull(builder.getLifeSpanSeconds());
        this.clock = Preconditions.checkNotNull(builder.getClock());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() throws IOException {
        JsonWebSignature.Header header = new JsonWebSignature.Header();
        header.setAlgorithm("RS256");
        header.setType("JWT");
        header.setKeyId(this.privateKeyId);
        JsonWebToken.Payload payload = new JsonWebToken.Payload();
        payload.setAudience(this.jwtClaims.getAudience());
        payload.setIssuer(this.jwtClaims.getIssuer());
        payload.setSubject(this.jwtClaims.getSubject());
        long currentTime = this.clock.currentTimeMillis();
        payload.setIssuedAtTimeSeconds(currentTime / 1000L);
        payload.setExpirationTimeSeconds(currentTime / 1000L + this.lifeSpanSeconds);
        payload.putAll((Map<? extends String, ?>)this.jwtClaims.getAdditionalClaims());
        Object object = this.lock;
        synchronized (object) {
            this.expiryInSeconds = payload.getExpirationTimeSeconds();
            try {
                this.jwt = JsonWebSignature.signUsingRsaSha256(this.privateKey, OAuth2Utils.JSON_FACTORY, header, payload);
            }
            catch (GeneralSecurityException e) {
                throw new IOException("Error signing service account JWT access header with private key.", e);
            }
        }
    }

    private boolean shouldRefresh() {
        return this.expiryInSeconds == null || this.getClock().currentTimeMillis() / 1000L > this.expiryInSeconds - CLOCK_SKEW;
    }

    @Override
    public JwtCredentials jwtWithClaims(JwtClaims newClaims) {
        return JwtCredentials.newBuilder().setPrivateKey(this.privateKey).setPrivateKeyId(this.privateKeyId).setJwtClaims(this.jwtClaims.merge(newClaims)).build();
    }

    @Override
    public String getAuthenticationType() {
        return "JWT";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<String>> getRequestMetadata(URI uri) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.shouldRefresh()) {
                this.refresh();
            }
            List<String> newAuthorizationHeaders = Collections.singletonList(JWT_ACCESS_PREFIX + this.jwt);
            return Collections.singletonMap("Authorization", newAuthorizationHeaders);
        }
    }

    @Override
    public boolean hasRequestMetadata() {
        return true;
    }

    @Override
    public boolean hasRequestMetadataOnly() {
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JwtCredentials)) {
            return false;
        }
        JwtCredentials other = (JwtCredentials)obj;
        return Objects.equals(this.privateKey, other.privateKey) && Objects.equals(this.privateKeyId, other.privateKeyId) && Objects.equals(this.jwtClaims, other.jwtClaims) && Objects.equals(this.lifeSpanSeconds, other.lifeSpanSeconds);
    }

    public int hashCode() {
        return Objects.hash(this.privateKey, this.privateKeyId, this.jwtClaims, this.lifeSpanSeconds);
    }

    Clock getClock() {
        if (this.clock == null) {
            this.clock = Clock.SYSTEM;
        }
        return this.clock;
    }

    public static class Builder {
        private PrivateKey privateKey;
        private String privateKeyId;
        private JwtClaims jwtClaims;
        private Clock clock = Clock.SYSTEM;
        private Long lifeSpanSeconds = TimeUnit.HOURS.toSeconds(1L);

        protected Builder() {
        }

        public Builder setPrivateKey(PrivateKey privateKey) {
            this.privateKey = Preconditions.checkNotNull(privateKey);
            return this;
        }

        public PrivateKey getPrivateKey() {
            return this.privateKey;
        }

        public Builder setPrivateKeyId(String privateKeyId) {
            this.privateKeyId = privateKeyId;
            return this;
        }

        public String getPrivateKeyId() {
            return this.privateKeyId;
        }

        public Builder setJwtClaims(JwtClaims claims) {
            this.jwtClaims = Preconditions.checkNotNull(claims);
            return this;
        }

        public JwtClaims getJwtClaims() {
            return this.jwtClaims;
        }

        public Builder setLifeSpanSeconds(Long lifeSpanSeconds) {
            this.lifeSpanSeconds = Preconditions.checkNotNull(lifeSpanSeconds);
            return this;
        }

        public Long getLifeSpanSeconds() {
            return this.lifeSpanSeconds;
        }

        Builder setClock(Clock clock) {
            this.clock = Preconditions.checkNotNull(clock);
            return this;
        }

        Clock getClock() {
            return this.clock;
        }

        public JwtCredentials build() {
            return new JwtCredentials(this);
        }
    }
}

