/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.sds;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.Bootstrapper;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.EnvoyServerProtoData;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.certprovider.CertProviderClientSslContextProvider;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.sds.CommonTlsContextUtil;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.sds.ReferenceCountingMap;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.internal.sds.SslContextProvider;

final class ClientSslContextProviderFactory
implements ReferenceCountingMap.ValueFactory<EnvoyServerProtoData.UpstreamTlsContext, SslContextProvider> {
    private Bootstrapper.BootstrapInfo bootstrapInfo;
    private final CertProviderClientSslContextProvider.Factory certProviderClientSslContextProviderFactory;

    ClientSslContextProviderFactory(Bootstrapper.BootstrapInfo bootstrapInfo) {
        this(bootstrapInfo, CertProviderClientSslContextProvider.Factory.getInstance());
    }

    ClientSslContextProviderFactory(Bootstrapper.BootstrapInfo bootstrapInfo, CertProviderClientSslContextProvider.Factory factory) {
        this.bootstrapInfo = bootstrapInfo;
        this.certProviderClientSslContextProviderFactory = factory;
    }

    @Override
    public SslContextProvider create(EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext) {
        Preconditions.checkNotNull(upstreamTlsContext, "upstreamTlsContext");
        Preconditions.checkNotNull(upstreamTlsContext.getCommonTlsContext(), "upstreamTlsContext should have CommonTlsContext");
        if (CommonTlsContextUtil.hasCertProviderInstance(upstreamTlsContext.getCommonTlsContext())) {
            return this.certProviderClientSslContextProviderFactory.getProvider(upstreamTlsContext, this.bootstrapInfo.node().toEnvoyProtoNode(), this.bootstrapInfo.certProviders());
        }
        throw new UnsupportedOperationException("Unsupported configurations in UpstreamTlsContext!");
    }
}

