/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.common.metrics;

import com.codahale.metrics.MetricRegistry;
import com.qubole.rubix.common.metrics.CustomMetricsReporter;
import com.qubole.rubix.common.metrics.MetricsReporterType;
import com.qubole.rubix.common.metrics.NoOpReporter;
import com.qubole.rubix.common.utils.ClusterUtil;
import com.qubole.rubix.spi.CacheConfig;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class CustomMetricsReporterProvider {
    private static final Log log = LogFactory.getLog(CustomMetricsReporterProvider.class);
    private static volatile AtomicReference<Boolean> reporterRunning = new AtomicReference();
    private CustomMetricsReporter customMetricsReporter;
    private static volatile CustomMetricsReporterProvider customMetricsReporterProvider;

    private CustomMetricsReporterProvider(CustomMetricsReporter customMetricsReporter) {
        this.customMetricsReporter = customMetricsReporter;
    }

    public static void initialize(Configuration configuration) {
        CustomMetricsReporterProvider.initialize(configuration, Optional.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initialize(Configuration configuration, Optional<MetricRegistry> metricRegistry) {
        if (customMetricsReporterProvider != null) return;
        Class<CustomMetricsReporterProvider> clazz = CustomMetricsReporterProvider.class;
        synchronized (CustomMetricsReporterProvider.class) {
            CustomMetricsReporter customMetricsReporter;
            if (customMetricsReporterProvider != null) return;
            String className = CacheConfig.getRubixMetricCollectorImpl(configuration);
            boolean useCustomReporter = ClusterUtil.getMetricsReporters(configuration).contains((Object)MetricsReporterType.CUSTOM);
            if (useCustomReporter && !className.equals("com.qubole.rubix.common.metrics.NoOpReporter")) {
                try {
                    Class<?> collectorClass = Class.forName(className);
                    log.info((Object)String.format("Using class for metric reporting: %s", className));
                    customMetricsReporter = (CustomMetricsReporter)collectorClass.getDeclaredConstructor(Configuration.class, Optional.class).newInstance(configuration, metricRegistry);
                }
                catch (Exception e) {
                    log.warn((Object)"External Metric Reporter class: %s can not be initialized: ", (Throwable)e);
                    customMetricsReporter = new NoOpReporter();
                }
            } else {
                customMetricsReporter = new NoOpReporter();
            }
            customMetricsReporterProvider = new CustomMetricsReporterProvider(customMetricsReporter);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CustomMetricsReporter getCustomMetricsReporter() {
        if (reporterRunning.get() == null) {
            AtomicReference<Boolean> atomicReference = reporterRunning;
            synchronized (atomicReference) {
                if (reporterRunning.get() == null) {
                    try {
                        CustomMetricsReporterProvider.customMetricsReporterProvider.customMetricsReporter.start();
                    }
                    catch (Exception e) {
                        log.warn((Object)"Exception in starting Custom reporter: ", (Throwable)e);
                        CustomMetricsReporterProvider.customMetricsReporterProvider.customMetricsReporter = new NoOpReporter();
                    }
                    reporterRunning.set(true);
                }
            }
        }
        return CustomMetricsReporterProvider.customMetricsReporterProvider.customMetricsReporter;
    }
}

