/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.core;

import com.google.shaded.shaded.common.base.Preconditions;
import com.qubole.rubix.core.ReadRequest;
import com.qubole.rubix.core.ReadRequestChain;
import com.qubole.rubix.core.ReadRequestChainStats;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;

public class DirectReadRequestChain
extends ReadRequestChain {
    private final FSDataInputStream inputStream;
    private long totalRead;
    private static final Log log = LogFactory.getLog(DirectReadRequestChain.class);

    public DirectReadRequestChain(FSDataInputStream inputStream) {
        super(0);
        this.inputStream = inputStream;
    }

    @Override
    public ReadRequestChainStats getStats() {
        return new ReadRequestChainStats().setDirectRRCDataRead(this.totalRead).setDirectRRCRequests(this.requests);
    }

    @Override
    public Long call() throws IOException {
        log.debug((Object)String.format("Read Request threadName: %s, Direct read Executor threadName: %s", this.threadName, Thread.currentThread().getName()));
        Thread.currentThread().setName(this.threadName);
        long startTime = System.currentTimeMillis();
        if (this.readRequests.size() == 0) {
            return 0L;
        }
        Preconditions.checkState(this.isLocked, "Trying to execute Chain without locking");
        for (ReadRequest readRequest : this.readRequests) {
            if (this.cancelled) {
                this.propagateCancel(this.getClass().getName());
            }
            try {
                this.inputStream.readFully(readRequest.actualReadStart, readRequest.getDestBuffer(), readRequest.getDestBufferOffset(), readRequest.getActualReadLengthIntUnsafe());
            }
            catch (Exception e) {
                log.error((Object)String.format("Error reading %d bytes directly from remote at position %d", readRequest.getActualReadLengthIntUnsafe(), readRequest.actualReadStart), (Throwable)e);
                throw e;
            }
            this.totalRead += (long)readRequest.getActualReadLengthIntUnsafe();
        }
        log.debug((Object)String.format("Read %d bytes directly from remote, no caching", this.totalRead));
        log.debug((Object)("DirectReadRequest took : " + (System.currentTimeMillis() - startTime) + " msecs "));
        return this.totalRead;
    }
}

