/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.core;

import com.google.shaded.shaded.common.base.Preconditions;
import com.google.shaded.shaded.common.base.Throwables;
import com.qubole.rubix.core.NonLocalReadRequestChain;
import com.qubole.rubix.core.ReadRequest;
import com.qubole.rubix.core.ReadRequestChain;
import com.qubole.rubix.core.ReadRequestChainStats;
import com.qubole.rubix.core.RemoteFetchRequestChain;
import com.qubole.rubix.spi.BookKeeperFactory;
import com.qubole.rubix.spi.CacheConfig;
import com.qubole.rubix.spi.RetryingPooledBookkeeperClient;
import com.qubole.rubix.spi.thrift.BlockLocation;
import com.qubole.rubix.spi.thrift.CacheStatusRequest;
import com.qubole.rubix.spi.thrift.Location;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;

public class NonLocalRequestChain
extends ReadRequestChain {
    private static final Log log = LogFactory.getLog(NonLocalRequestChain.class);
    String remoteNodeName;
    long fileSize;
    long lastModified;
    Configuration conf;
    FileSystem remoteFileSystem;
    String remoteFilePath;
    int clusterType;
    int blockSize;
    boolean strictMode;
    BookKeeperFactory bookKeeperFactory;
    NonLocalReadRequestChain nonLocalReadRequestChain;
    RemoteFetchRequestChain remoteFetchRequestChain;
    FileSystem.Statistics statistics;
    List<BlockLocation> isCached;
    long startBlockForCacheStatus;
    long endBlockForCacheStatus;
    long nonLocalReadBytes = 0L;

    public NonLocalRequestChain(String remoteNodeName, long fileSize, long lastModified, Configuration conf, FileSystem remoteFileSystem, String remoteFilePath, int clusterType, boolean strictMode, FileSystem.Statistics statistics, long startBlock, long endBlock, BookKeeperFactory bookKeeperFactory) {
        super(0);
        this.remoteNodeName = remoteNodeName;
        this.remoteFileSystem = remoteFileSystem;
        this.lastModified = lastModified;
        this.remoteFilePath = remoteFilePath;
        this.fileSize = fileSize;
        this.conf = conf;
        this.clusterType = clusterType;
        this.strictMode = strictMode;
        this.statistics = statistics;
        this.startBlockForCacheStatus = startBlock;
        this.endBlockForCacheStatus = endBlock;
        this.bookKeeperFactory = bookKeeperFactory;
        this.blockSize = CacheConfig.getBlockSize(conf);
        try (RetryingPooledBookkeeperClient bookKeeperClient = bookKeeperFactory.createBookKeeperClient(remoteNodeName, conf);){
            log.debug((Object)(" Trying to getCacheStatus from : " + remoteNodeName + " for file : " + remoteFilePath + " StartBlock : " + startBlock + " EndBlock : " + endBlock));
            CacheStatusRequest request = new CacheStatusRequest(remoteFilePath, fileSize, lastModified, startBlock, endBlock).setClusterType(clusterType);
            this.isCached = bookKeeperClient.getCacheStatus(request).getBlocks();
            log.debug((Object)("Cache Status : " + this.isCached));
        }
        catch (Exception e) {
            if (strictMode) {
                throw Throwables.propagate(e);
            }
            log.error((Object)("Could not get cache status from bookkeeper server at " + remoteNodeName), (Throwable)e);
        }
    }

    @Override
    public ReadRequestChainStats getStats() {
        if (this.nonLocalReadRequestChain != null) {
            return this.nonLocalReadRequestChain.getStats();
        }
        return new ReadRequestChainStats();
    }

    @Override
    public void addReadRequest(ReadRequest readRequest) {
        long blockNum = readRequest.backendReadStart / (long)this.blockSize;
        if (!this.needDirectReadRequest(blockNum)) {
            if (this.nonLocalReadRequestChain == null) {
                this.nonLocalReadRequestChain = new NonLocalReadRequestChain(this.remoteNodeName, this.fileSize, this.lastModified, this.conf, this.remoteFileSystem, this.remoteFilePath, this.clusterType, this.strictMode, this.statistics);
            }
            this.nonLocalReadRequestChain.addReadRequest(readRequest);
        } else {
            if (this.remoteFetchRequestChain == null) {
                this.remoteFetchRequestChain = new RemoteFetchRequestChain(this.remoteFilePath, this.remoteFileSystem, this.remoteNodeName, this.conf, this.lastModified, this.fileSize, this.clusterType, this.bookKeeperFactory);
            }
            this.remoteFetchRequestChain.addReadRequest(readRequest);
        }
    }

    protected boolean needDirectReadRequest(long blockNum) {
        int idx = (int)(blockNum - this.startBlockForCacheStatus);
        return this.isCached == null || this.isCached.get(idx).getLocation() != Location.CACHED;
    }

    @Override
    public Long call() throws Exception {
        log.debug((Object)String.format("Read Request threadName: %s, NonLocal Executor threadName: %s", this.threadName, Thread.currentThread().getName()));
        Thread.currentThread().setName(this.threadName);
        Preconditions.checkState(this.isLocked, "Trying to execute Chain without locking");
        long startTime = System.currentTimeMillis();
        log.debug((Object)"Executing NonLocalRequestChain ");
        if (this.nonLocalReadRequestChain != null) {
            this.nonLocalReadRequestChain.lock();
            this.nonLocalReadBytes += this.nonLocalReadRequestChain.call().longValue();
        }
        if (this.remoteFetchRequestChain != null) {
            this.remoteFetchRequestChain.call();
        }
        log.debug((Object)("NonLocalRequest took : " + (System.currentTimeMillis() - startTime) + " msecs "));
        return this.nonLocalReadBytes;
    }

    @Override
    public void updateCacheStatus(String remotePath, long fileSize, long lastModified, int blockSize, Configuration conf) {
        if (CacheConfig.isDummyModeEnabled(conf)) {
            if (this.remoteFetchRequestChain == null || this.remoteFetchRequestChain.getReadRequests().isEmpty()) {
                return;
            }
            this.remoteFetchRequestChain.updateCacheStatus(remotePath, fileSize, lastModified, blockSize, conf);
        }
    }
}

