/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.core;

import com.google.shaded.shaded.common.cache.Cache;
import com.google.shaded.shaded.common.cache.CacheBuilder;
import com.google.shaded.shaded.common.collect.ImmutableMap;
import com.qubole.rubix.spi.BookKeeperFactory;
import com.qubole.rubix.spi.RetryingPooledBookkeeperClient;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;

public class ReadRequestChainStats {
    public static final String DOWNLOADED_FOR_NON_LOCAL_METRIC = "downloaded_for_non_local";
    public static final String EXTRA_READ_FOR_NON_LOCAL_METRIC = "extra_read_for_non_local";
    public static final String WARMUP_TIME_NON_LOCAL_METRIC = "warmup_penalty_non_local";
    public static final String DOWNLOADED_FOR_PARALLEL_WARMUP_METRIC = "downloaded_for_parallel_warmup";
    public static final String PARALLEL_DOWNLOAD_TIME_METRIC = "parallel_download_time";
    private static final long UNKNOWN_VALUE = -1L;
    private static final Cache<String, Map<String, Long>> bookKeeperStats = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).build();
    private static final String STATS_KEY = "stats";
    private long remoteRRCDataRead;
    private long remoteRRCExtraDataRead;
    private long remoteRRCWarmupTime;
    private long remoteRRCRequests;
    private long cachedRRCDataRead;
    private long cachedRRCRequests;
    private long directRRCDataRead;
    private long directRRCRequests;
    private long nonLocalRRCDataRead;
    private long nonLocalRRCRequests;
    private int corruptedFileCount;

    public ReadRequestChainStats add(ReadRequestChainStats other) {
        this.remoteRRCDataRead += other.getRemoteRRCDataRead();
        this.remoteRRCExtraDataRead += other.getRemoteRRCExtraDataRead();
        this.remoteRRCWarmupTime += other.getRemoteRRCWarmupTime();
        this.remoteRRCRequests += other.getRemoteRRCRequests();
        this.cachedRRCDataRead += other.getCachedRRCDataRead();
        this.cachedRRCRequests += other.getCachedRRCRequests();
        this.directRRCDataRead += other.getDirectRRCDataRead();
        this.directRRCRequests += other.getDirectRRCRequests();
        this.nonLocalRRCDataRead += other.getNonLocalRRCDataRead();
        this.nonLocalRRCRequests += other.getNonLocalRRCRequests();
        this.corruptedFileCount += other.getCorruptedFileCount();
        return this;
    }

    public long getRemoteRRCDataRead() {
        return this.remoteRRCDataRead;
    }

    public ReadRequestChainStats setRemoteRRCDataRead(long remoteRRCDataRead) {
        this.remoteRRCDataRead = remoteRRCDataRead;
        return this;
    }

    public long getRemoteRRCExtraDataRead() {
        return this.remoteRRCExtraDataRead;
    }

    public ReadRequestChainStats setRemoteRRCExtraDataRead(long remoteRRCExtraDataRead) {
        this.remoteRRCExtraDataRead = remoteRRCExtraDataRead;
        return this;
    }

    public long getRemoteRRCWarmupTime() {
        return this.remoteRRCWarmupTime;
    }

    public ReadRequestChainStats setRemoteRRCWarmupTime(long remoteRRCWarmupTime) {
        this.remoteRRCWarmupTime = remoteRRCWarmupTime;
        return this;
    }

    public long getRemoteRRCRequests() {
        return this.remoteRRCRequests;
    }

    public ReadRequestChainStats setRemoteRRCRequests(long remoteRRCRequests) {
        this.remoteRRCRequests = remoteRRCRequests;
        return this;
    }

    public long getCachedRRCDataRead() {
        return this.cachedRRCDataRead;
    }

    public ReadRequestChainStats setCachedRRCDataRead(long cachedRRCDataRead) {
        this.cachedRRCDataRead = cachedRRCDataRead;
        return this;
    }

    public long getCachedRRCRequests() {
        return this.cachedRRCRequests;
    }

    public ReadRequestChainStats setCachedRRCRequests(long cachedRRCRequests) {
        this.cachedRRCRequests = cachedRRCRequests;
        return this;
    }

    public long getDirectRRCDataRead() {
        return this.directRRCDataRead;
    }

    public ReadRequestChainStats setDirectRRCDataRead(long directRRCDataRead) {
        this.directRRCDataRead = directRRCDataRead;
        return this;
    }

    public long getDirectRRCRequests() {
        return this.directRRCRequests;
    }

    public ReadRequestChainStats setDirectRRCRequests(long directRRCRequests) {
        this.directRRCRequests = directRRCRequests;
        return this;
    }

    public long getNonLocalRRCDataRead() {
        return this.nonLocalRRCDataRead;
    }

    public ReadRequestChainStats setNonLocalRRCDataRead(long nonLocalRRCDataRead) {
        this.nonLocalRRCDataRead = nonLocalRRCDataRead;
        return this;
    }

    public long getNonLocalRRCRequests() {
        return this.nonLocalRRCRequests;
    }

    public ReadRequestChainStats setNonLocalRRCRequests(long nonLocalRRCRequests) {
        this.nonLocalRRCRequests = nonLocalRRCRequests;
        return this;
    }

    public int getCorruptedFileCount() {
        return this.corruptedFileCount;
    }

    public ReadRequestChainStats setCorruptedFileCount(int corruptedFileCount) {
        this.corruptedFileCount = corruptedFileCount;
        return this;
    }

    public long getDownloadedFromSourceForNonLocalRequests(BookKeeperFactory bookKeeperFactory, Configuration conf) {
        return this.getBookKeeperStats(bookKeeperFactory, conf).getOrDefault(DOWNLOADED_FOR_NON_LOCAL_METRIC, -1L);
    }

    public long getExtraReadFromSourceForNonLocalRequests(BookKeeperFactory bookKeeperFactory, Configuration conf) {
        return this.getBookKeeperStats(bookKeeperFactory, conf).getOrDefault(EXTRA_READ_FOR_NON_LOCAL_METRIC, -1L);
    }

    public long getWarmupTimeForNonLocalRequests(BookKeeperFactory bookKeeperFactory, Configuration conf) {
        return this.getBookKeeperStats(bookKeeperFactory, conf).getOrDefault(WARMUP_TIME_NON_LOCAL_METRIC, -1L);
    }

    public long getDownloadedFromSourceParallel(BookKeeperFactory bookKeeperFactory, Configuration conf) {
        return this.getBookKeeperStats(bookKeeperFactory, conf).getOrDefault(DOWNLOADED_FOR_PARALLEL_WARMUP_METRIC, -1L);
    }

    public long getTotalTimeForParallelDownload(BookKeeperFactory bookKeeperFactory, Configuration conf) {
        return this.getBookKeeperStats(bookKeeperFactory, conf).getOrDefault(PARALLEL_DOWNLOAD_TIME_METRIC, -1L);
    }

    private Map<String, Long> getBookKeeperStats(BookKeeperFactory bookKeeperFactory, Configuration conf) {
        try {
            return bookKeeperStats.get(STATS_KEY, () -> {
                try (RetryingPooledBookkeeperClient client = bookKeeperFactory.createBookKeeperClient(conf);){
                    Map<String, Long> map = client.getReadRequestChainStats();
                    return map;
                }
            });
        }
        catch (Exception e) {
            return ImmutableMap.of();
        }
    }
}

