/*
 * Decompiled with CFR 0.152.
 */
package com.qubole.rubix.spi;

import com.google.shaded.shaded.common.util.concurrent.ThreadFactoryBuilder;
import com.qubole.rubix.spi.CacheConfig;
import java.util.concurrent.ThreadFactory;
import org.apache.hadoop.conf.Configuration;

public class CommonUtilities {
    private CommonUtilities() {
    }

    public static long toBlockStartPosition(long block, Configuration conf) {
        return block * (long)CacheConfig.getBlockSize(conf);
    }

    public static long toBlockEndPosition(long block, Configuration conf) {
        return CommonUtilities.toBlockStartPosition(block + 1L, conf) - 1L;
    }

    public static long alignToBlockStartPosition(long position, Configuration conf) {
        return CommonUtilities.toStartBlock(position, conf) * (long)CacheConfig.getBlockSize(conf);
    }

    public static long alignToBlockEndPosition(long position, Configuration conf) {
        return CommonUtilities.toEndBlock(position, conf) * (long)CacheConfig.getBlockSize(conf);
    }

    public static long toStartBlock(long startingPosition, Configuration conf) {
        return CommonUtilities.toStartBlock(startingPosition, CacheConfig.getBlockSize(conf));
    }

    public static long toEndBlock(long endPosition, Configuration conf) {
        return CommonUtilities.toEndBlock(endPosition, CacheConfig.getBlockSize(conf));
    }

    public static long toStartBlock(long startingPosition, int blockSize) {
        return startingPosition / (long)blockSize;
    }

    public static long toEndBlock(long endPosition, int blockSize) {
        return (endPosition - 1L) / (long)blockSize + 1L;
    }

    public static ThreadFactory threadsNamed(String nameFormat) {
        return new ThreadFactoryBuilder().setNameFormat(nameFormat).build();
    }
}

