/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.conf;

import com.linkedin.coral.$internal.org.apache.hadoop.conf.Configuration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ReconfigurationUtil {
    public static Collection<PropertyChange> getChangedProperties(Configuration newConf, Configuration oldConf) {
        String prop;
        HashMap<String, PropertyChange> changes = new HashMap<String, PropertyChange>();
        for (Map.Entry<String, String> oldEntry : oldConf) {
            prop = oldEntry.getKey();
            String oldVal = oldEntry.getValue();
            String newVal = newConf.getRaw(prop);
            if (newVal != null && newVal.equals(oldVal)) continue;
            changes.put(prop, new PropertyChange(prop, newVal, oldVal));
        }
        for (Map.Entry<String, String> newEntry : newConf) {
            prop = newEntry.getKey();
            String newVal = newEntry.getValue();
            if (oldConf.get(prop) != null) continue;
            changes.put(prop, new PropertyChange(prop, newVal, null));
        }
        return changes.values();
    }

    public Collection<PropertyChange> parseChangedProperties(Configuration newConf, Configuration oldConf) {
        return ReconfigurationUtil.getChangedProperties(newConf, oldConf);
    }

    public static class PropertyChange {
        public String prop;
        public String oldVal;
        public String newVal;

        public PropertyChange(String prop, String newVal, String oldVal) {
            this.prop = prop;
            this.newVal = newVal;
            this.oldVal = oldVal;
        }
    }
}

