/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.columnar;

import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.SerDeStatsStruct;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.StructObject;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.columnar.BytesRefWritable;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.LazyObjectBase;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.StructField;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class ColumnarStructBase
implements StructObject,
SerDeStatsStruct {
    protected int[] prjColIDs = null;
    private FieldInfo[] fieldInfoList = null;
    private ArrayList<Object> cachedList;

    public ColumnarStructBase(ObjectInspector oi, List<Integer> notSkippedColumnIDs) {
        List<? extends StructField> fieldRefs = ((StructObjectInspector)oi).getAllStructFieldRefs();
        int num = fieldRefs.size();
        this.fieldInfoList = new FieldInfo[num];
        for (int i = 0; i < num; ++i) {
            ObjectInspector foi = fieldRefs.get(i).getFieldObjectInspector();
            this.fieldInfoList[i] = new FieldInfo(this.createLazyObjectBase(foi), !notSkippedColumnIDs.contains(i), foi);
        }
        int min2 = notSkippedColumnIDs.size() > num ? num : notSkippedColumnIDs.size();
        this.prjColIDs = new int[min2];
        int index = 0;
        for (int i = 0; i < notSkippedColumnIDs.size(); ++i) {
            int readCol = notSkippedColumnIDs.get(i);
            if (readCol >= num) continue;
            this.prjColIDs[index] = readCol;
            ++index;
        }
    }

    @Override
    public Object getField(int fieldID) {
        return this.fieldInfoList[fieldID].uncheckedGetField();
    }

    protected abstract int getLength(ObjectInspector var1, ByteArrayRef var2, int var3, int var4);

    protected abstract LazyObjectBase createLazyObjectBase(ObjectInspector var1);

    public void init(BytesRefArrayWritable cols) {
        for (int i = 0; i < this.prjColIDs.length; ++i) {
            int fieldIndex = this.prjColIDs[i];
            if (fieldIndex < cols.size()) {
                this.fieldInfoList[fieldIndex].init(cols.unCheckedGet(fieldIndex));
                continue;
            }
            this.fieldInfoList[fieldIndex].init(null);
        }
    }

    public ArrayList<Object> getFieldsAsList() {
        if (this.cachedList == null) {
            this.cachedList = new ArrayList();
        } else {
            this.cachedList.clear();
        }
        for (int i = 0; i < this.fieldInfoList.length; ++i) {
            this.cachedList.add(this.fieldInfoList[i].uncheckedGetField());
        }
        return this.cachedList;
    }

    @Override
    public long getRawDataSerializedSize() {
        long serializedSize = 0L;
        for (int i = 0; i < this.fieldInfoList.length; ++i) {
            serializedSize += this.fieldInfoList[i].getSerializedSize();
        }
        return serializedSize;
    }

    class FieldInfo {
        LazyObjectBase field;
        ByteArrayRef cachedByteArrayRef;
        BytesRefWritable rawBytesField;
        boolean inited;
        boolean fieldSkipped;
        ObjectInspector objectInspector;

        public FieldInfo(LazyObjectBase lazyObject, boolean fieldSkipped, ObjectInspector oi) {
            this.field = lazyObject;
            this.cachedByteArrayRef = new ByteArrayRef();
            this.objectInspector = oi;
            if (fieldSkipped) {
                this.fieldSkipped = true;
                this.inited = true;
            } else {
                this.inited = false;
            }
        }

        public void init(BytesRefWritable col) {
            if (col != null) {
                this.rawBytesField = col;
                this.inited = false;
                this.fieldSkipped = false;
            } else {
                this.fieldSkipped = true;
            }
        }

        public long getSerializedSize() {
            if (this.rawBytesField == null) {
                return 0L;
            }
            return this.rawBytesField.getLength();
        }

        protected Object uncheckedGetField() {
            if (this.fieldSkipped) {
                return null;
            }
            if (!this.inited) {
                try {
                    this.cachedByteArrayRef.setData(this.rawBytesField.getData());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.inited = true;
                int byteLength = ColumnarStructBase.this.getLength(this.objectInspector, this.cachedByteArrayRef, this.rawBytesField.getStart(), this.rawBytesField.getLength());
                if (byteLength == -1) {
                    return null;
                }
                this.field.init(this.cachedByteArrayRef, this.rawBytesField.getStart(), byteLength);
                return this.field.getObject();
            }
            if (ColumnarStructBase.this.getLength(this.objectInspector, this.cachedByteArrayRef, this.rawBytesField.getStart(), this.rawBytesField.getLength()) == -1) {
                return null;
            }
            return this.field.getObject();
        }
    }
}

