/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.io;

import com.linkedin.coral.$internal.org.apache.hadoop.hive.common.type.HiveBaseChar;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.common.type.HiveChar;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.io.HiveBaseCharWritable;
import com.linkedin.coral.$internal.org.apache.hadoop.io.Text;
import com.linkedin.coral.$internal.org.apache.hadoop.io.WritableComparable;
import org.apache.hive.common.util.HiveStringUtils;

public class HiveCharWritable
extends HiveBaseCharWritable
implements WritableComparable<HiveCharWritable> {
    public HiveCharWritable() {
    }

    public HiveCharWritable(HiveChar hc) {
        this.set(hc);
    }

    public HiveCharWritable(HiveCharWritable hcw) {
        this.set(hcw);
    }

    public void set(HiveChar val) {
        this.set(val.getValue(), -1);
    }

    public void set(String val) {
        this.set(val, -1);
    }

    public void set(HiveCharWritable val) {
        this.value.set(val.value);
    }

    public void set(HiveCharWritable val, int maxLength) {
        this.set(val.getHiveChar(), maxLength);
    }

    public void set(HiveChar val, int len) {
        this.set(val.getValue(), len);
    }

    public void set(String val, int maxLength) {
        this.value.set(HiveBaseChar.getPaddedValue(val, maxLength));
    }

    public HiveChar getHiveChar() {
        return new HiveChar(this.value.toString(), -1);
    }

    public void enforceMaxLength(int maxLength) {
        if (this.getCharacterLength() != maxLength) {
            this.set(this.getHiveChar(), maxLength);
        }
    }

    public Text getStrippedValue() {
        return new Text(this.getHiveChar().getStrippedValue());
    }

    public Text getPaddedValue() {
        return this.getTextValue();
    }

    @Override
    public int getCharacterLength() {
        return HiveStringUtils.getTextUtfLength((Text)this.getStrippedValue());
    }

    @Override
    public int compareTo(HiveCharWritable rhs) {
        return this.getStrippedValue().compareTo(rhs.getStrippedValue());
    }

    @Override
    public boolean equals(Object rhs) {
        if (rhs == this) {
            return true;
        }
        if (rhs == null || rhs.getClass() != this.getClass()) {
            return false;
        }
        return this.getStrippedValue().equals(((HiveCharWritable)rhs).getStrippedValue());
    }

    @Override
    public int hashCode() {
        return this.getStrippedValue().hashCode();
    }

    public String toString() {
        return this.getPaddedValue().toString();
    }
}

