/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy;

import com.linkedin.coral.$internal.org.apache.hadoop.hive.common.type.TimestampTZ;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.common.type.TimestampTZUtil;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.io.TimestampLocalTZWritable;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyTimestampLocalTZObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.typeinfo.TimestampLocalTZTypeInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyTimestampLocalTZ
extends LazyPrimitive<LazyTimestampLocalTZObjectInspector, TimestampLocalTZWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(LazyTimestampLocalTZ.class);
    private ZoneId timeZone;

    public LazyTimestampLocalTZ(LazyTimestampLocalTZObjectInspector lazyTimestampTZObjectInspector) {
        super(lazyTimestampTZObjectInspector);
        TimestampLocalTZTypeInfo typeInfo = (TimestampLocalTZTypeInfo)((LazyTimestampLocalTZObjectInspector)this.oi).getTypeInfo();
        if (typeInfo == null) {
            throw new RuntimeException("TimestampLocalTZ type used without type params");
        }
        this.timeZone = typeInfo.timeZone();
        this.data = new TimestampLocalTZWritable();
    }

    public LazyTimestampLocalTZ(LazyTimestampLocalTZ copy) {
        super(copy);
        this.timeZone = copy.timeZone;
        this.data = new TimestampLocalTZWritable((TimestampLocalTZWritable)copy.data);
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        String s2 = null;
        if (!LazyUtils.isDateMaybe(bytes.getData(), start, length)) {
            this.isNull = true;
            return;
        }
        TimestampTZ t = null;
        try {
            s2 = new String(bytes.getData(), start, length, "US-ASCII");
            if (s2.equals("NULL")) {
                this.isNull = true;
                this.logExceptionMessage(bytes, start, length, "timestamp with local time zone".toUpperCase());
            } else {
                t = TimestampTZUtil.parse(s2, this.timeZone);
                this.isNull = false;
            }
        }
        catch (UnsupportedEncodingException e) {
            this.isNull = true;
            LOG.error("Unsupported encoding found ", (Throwable)e);
        }
        catch (DateTimeParseException e) {
            this.isNull = true;
            this.logExceptionMessage(bytes, start, length, "timestamp with local time zone".toUpperCase());
        }
        ((TimestampLocalTZWritable)this.data).set(t);
    }

    @Override
    public TimestampLocalTZWritable getWritableObject() {
        return (TimestampLocalTZWritable)this.data;
    }

    public static void writeUTF8(OutputStream out, TimestampLocalTZWritable i) throws IOException {
        if (i == null) {
            out.write(TimestampLocalTZWritable.nullBytes);
        } else {
            out.write(i.toString().getBytes("US-ASCII"));
        }
    }
}

