/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.calcite.$internal.com.yahoo.sketches.sampling;

import com.linkedin.coral.calcite.$internal.com.yahoo.memory.Memory;
import com.linkedin.coral.calcite.$internal.com.yahoo.memory.MemoryRegion;
import com.linkedin.coral.calcite.$internal.com.yahoo.memory.NativeMemory;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.Family;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.SketchesArgumentException;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.Util;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.sampling.PreambleUtil;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.sampling.ReservoirLongsSketch;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.sampling.SamplingUtil;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.sampling.VersionConverter;

public final class ReservoirLongsUnion {
    private ReservoirLongsSketch gadget_;
    private final int maxK_;

    private ReservoirLongsUnion(int maxK) {
        this.maxK_ = maxK;
    }

    public static ReservoirLongsUnion getInstance(int maxK) {
        return new ReservoirLongsUnion(maxK);
    }

    public static ReservoirLongsUnion getInstance(Memory srcMem) {
        int maxK;
        boolean isEmpty;
        int serVer;
        int numPreLongs;
        Family.RESERVOIR_UNION.checkFamilyID(srcMem.getByte(2L));
        if (srcMem.isReadOnly() && !srcMem.isDirect()) {
            numPreLongs = srcMem.getByte(0L) & 0x3F;
            serVer = srcMem.getByte(1L) & 0xFF;
            isEmpty = (srcMem.getInt(3L) & 4) != 0;
            maxK = srcMem.getInt(4L);
        } else {
            Object memObj = srcMem.array();
            long memAddr = srcMem.getCumulativeOffset(0L);
            numPreLongs = PreambleUtil.extractPreLongs(memObj, memAddr);
            serVer = PreambleUtil.extractSerVer(memObj, memAddr);
            isEmpty = (PreambleUtil.extractFlags(memObj, memAddr) & 4) != 0;
            maxK = PreambleUtil.extractMaxK(memObj, memAddr);
        }
        boolean preLongsEqMin = numPreLongs == Family.RESERVOIR_UNION.getMinPreLongs();
        boolean preLongsEqMax = numPreLongs == Family.RESERVOIR_UNION.getMaxPreLongs();
        if (!preLongsEqMin & !preLongsEqMax) {
            throw new SketchesArgumentException("Possible corruption: Non-empty union with only " + Family.RESERVOIR_UNION.getMinPreLongs() + "preLongs");
        }
        if (serVer != 2) {
            if (serVer == 1) {
                srcMem = VersionConverter.convertUnion1to2(srcMem);
                maxK = PreambleUtil.extractMaxK(srcMem.array(), srcMem.getCumulativeOffset(0L));
            } else {
                throw new SketchesArgumentException("Possible Corruption: Ser Ver must be 2: " + serVer);
            }
        }
        ReservoirLongsUnion rlu = new ReservoirLongsUnion(maxK);
        if (!isEmpty) {
            int preLongBytes = numPreLongs << 3;
            MemoryRegion sketchMem = new MemoryRegion(srcMem, preLongBytes, srcMem.getCapacity() - (long)preLongBytes);
            rlu.update(srcMem.isReadOnly() ? sketchMem.asReadOnlyMemory() : sketchMem);
        }
        return rlu;
    }

    public int getMaxK() {
        return this.maxK_;
    }

    public void update(ReservoirLongsSketch sketchIn) {
        boolean isModifiable;
        if (sketchIn == null) {
            return;
        }
        ReservoirLongsSketch rls = sketchIn.getK() <= this.maxK_ ? sketchIn : sketchIn.downsampledCopy(this.maxK_);
        boolean bl = isModifiable = sketchIn != rls;
        if (this.gadget_ == null) {
            this.createNewGadget(sketchIn, isModifiable);
        } else {
            this.twoWayMergeInternal(rls, isModifiable);
        }
    }

    public void update(Memory mem) {
        if (mem == null) {
            return;
        }
        ReservoirLongsSketch rls = ReservoirLongsSketch.getInstance(mem);
        ReservoirLongsSketch reservoirLongsSketch = rls = rls.getK() <= this.maxK_ ? rls : rls.downsampledCopy(this.maxK_);
        if (this.gadget_ == null) {
            this.createNewGadget(rls, true);
        } else {
            this.twoWayMergeInternal(rls, true);
        }
    }

    public void update(long datum) {
        if (this.gadget_ == null) {
            this.gadget_ = ReservoirLongsSketch.getInstance(this.maxK_);
        }
        this.gadget_.update(datum);
    }

    public ReservoirLongsSketch getResult() {
        return this.gadget_ != null ? this.gadget_.copy() : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String thisSimpleName = this.getClass().getSimpleName();
        sb.append(Util.LS);
        sb.append("### ").append(thisSimpleName).append(" SUMMARY: ").append(Util.LS);
        sb.append("Max k: ").append(this.maxK_).append(Util.LS);
        if (this.gadget_ == null) {
            sb.append("Gadget is null").append(Util.LS);
        } else {
            sb.append("Gadget summary: ").append(this.gadget_.toString());
        }
        sb.append("### END UNION SUMMARY").append(Util.LS);
        return sb.toString();
    }

    public byte[] toByteArray() {
        int outBytes;
        int preLongs;
        byte[] gadgetBytes;
        boolean empty = this.gadget_ == null;
        byte[] byArray = gadgetBytes = this.gadget_ != null ? this.gadget_.toByteArray() : null;
        if (empty) {
            preLongs = Family.RESERVOIR_UNION.getMinPreLongs();
            outBytes = 8;
        } else {
            preLongs = Family.RESERVOIR_UNION.getMaxPreLongs();
            outBytes = (preLongs << 3) + gadgetBytes.length;
        }
        byte[] outArr = new byte[outBytes];
        NativeMemory mem = new NativeMemory(outArr);
        Object memObj = mem.array();
        long memAddr = mem.getCumulativeOffset(0L);
        PreambleUtil.insertPreLongs(memObj, memAddr, preLongs);
        PreambleUtil.insertSerVer(memObj, memAddr, 2);
        PreambleUtil.insertFamilyID(memObj, memAddr, Family.RESERVOIR_UNION.getID());
        if (empty) {
            PreambleUtil.insertFlags(memObj, memAddr, 4);
        } else {
            PreambleUtil.insertFlags(memObj, memAddr, 0);
        }
        PreambleUtil.insertMaxK(memObj, memAddr, this.maxK_);
        if (!empty) {
            int preBytes = preLongs << 3;
            mem.putByteArray(preBytes, gadgetBytes, 0, gadgetBytes.length);
        }
        return outArr;
    }

    private void createNewGadget(ReservoirLongsSketch sketchIn, boolean isModifiable) {
        if (sketchIn.getK() < this.maxK_ && sketchIn.getN() <= (long)sketchIn.getK()) {
            this.gadget_ = ReservoirLongsSketch.getInstance(this.maxK_);
            this.twoWayMergeInternal(sketchIn, isModifiable);
        } else {
            this.gadget_ = isModifiable ? sketchIn : sketchIn.copy();
        }
    }

    private void twoWayMergeInternal(ReservoirLongsSketch sketchIn, boolean isModifiable) {
        if (sketchIn.getN() <= (long)sketchIn.getK()) {
            this.twoWayMergeInternalStandard(sketchIn);
        } else if (this.gadget_.getN() < (long)this.gadget_.getK()) {
            ReservoirLongsSketch tmpSketch = this.gadget_;
            this.gadget_ = isModifiable ? sketchIn : sketchIn.copy();
            this.twoWayMergeInternalStandard(tmpSketch);
        } else if (sketchIn.getImplicitSampleWeight() < (double)this.gadget_.getN() / (double)(this.gadget_.getK() - 1)) {
            this.twoWayMergeInternalWeighted(sketchIn);
        } else {
            ReservoirLongsSketch tmpSketch = this.gadget_;
            this.gadget_ = isModifiable ? sketchIn : sketchIn.copy();
            this.twoWayMergeInternalWeighted(tmpSketch);
        }
    }

    private void twoWayMergeInternalStandard(ReservoirLongsSketch source) {
        assert (source.getN() <= (long)source.getK());
        int numInputSamples = source.getNumSamples();
        for (int i = 0; i < numInputSamples; ++i) {
            this.gadget_.update(source.getValueAtPosition(i));
        }
    }

    private void twoWayMergeInternalWeighted(ReservoirLongsSketch source) {
        assert (this.gadget_.getN() >= (long)this.gadget_.getK());
        int numSourceSamples = source.getK();
        double sourceItemWeight = (double)source.getN() / (double)numSourceSamples;
        double rescaled_prob = (double)this.gadget_.getK() * sourceItemWeight;
        double targetTotal = this.gadget_.getN();
        int tgtK = this.gadget_.getK();
        for (int i = 0; i < numSourceSamples; ++i) {
            double rescaled_one = targetTotal += sourceItemWeight;
            assert (rescaled_prob < rescaled_one);
            double rescaled_flip = rescaled_one * SamplingUtil.rand.nextDouble();
            if (!(rescaled_flip < rescaled_prob)) continue;
            int slotNo = SamplingUtil.rand.nextInt(tgtK);
            this.gadget_.insertValueAtPosition(source.getValueAtPosition(i), slotNo);
        }
        long checkN = (long)Math.floor(0.5 + targetTotal);
        this.gadget_.forceIncrementItemsSeen(source.getN());
        assert (checkN == this.gadget_.getN());
    }
}

