/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.common.transformers;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.calcite.sql.validate.SqlValidator;

public abstract class SqlCallTransformer {
    private SqlValidator sqlValidator;
    private final List<SqlSelect> topSelectNodes = new ArrayList<SqlSelect>();

    public SqlCallTransformer() {
    }

    public SqlCallTransformer(SqlValidator sqlValidator) {
        this.sqlValidator = sqlValidator;
    }

    protected abstract boolean condition(SqlCall var1);

    protected abstract SqlCall transform(SqlCall var1);

    public SqlCall apply(SqlCall sqlCall) {
        if (sqlCall instanceof SqlSelect) {
            this.topSelectNodes.add((SqlSelect)sqlCall);
        }
        if (this.condition(sqlCall)) {
            return this.transform(sqlCall);
        }
        return sqlCall;
    }

    protected RelDataType getRelDataType(SqlNode sqlNode) {
        if (this.sqlValidator == null) {
            throw new RuntimeException("SqlValidator does not exist to derive the RelDataType for SqlNode " + sqlNode);
        }
        for (int i = this.topSelectNodes.size() - 1; i >= 0; --i) {
            SqlSelect topSelectNode = this.topSelectNodes.get(i);
            SqlSelect dummySqlSelect = new SqlSelect(topSelectNode.getParserPosition(), null, SqlNodeList.of(sqlNode), topSelectNode.getFrom(), null, null, null, null, null, null, null);
            try {
                this.sqlValidator.validate(dummySqlSelect);
                return this.sqlValidator.getValidatedNodeType(dummySqlSelect).getFieldList().get(0).getType();
            }
            catch (Throwable throwable) {
                continue;
            }
        }
        throw new RuntimeException("Failed to derive the RelDataType for SqlNode " + sqlNode);
    }

    protected static SqlOperator createSqlOperator(String functionName, SqlReturnTypeInference typeInference) {
        SqlIdentifier sqlIdentifier = new SqlIdentifier((List<String>)ImmutableList.of((Object)functionName), SqlParserPos.ZERO);
        return new SqlUserDefinedFunction(sqlIdentifier, typeInference, null, null, null, null);
    }
}

