/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel;

import com.google.common.base.Preconditions;
import com.linkedin.coral.common.FuzzyUnionSqlRewriter;
import com.linkedin.coral.hive.hive2rel.HiveToRelConverter;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.util.Util;

public class HiveViewExpander
implements RelOptTable.ViewExpander {
    private final HiveToRelConverter hiveToRelConverter;

    public HiveViewExpander(@Nonnull HiveToRelConverter hiveToRelConverter) {
        this.hiveToRelConverter = hiveToRelConverter;
    }

    @Override
    public RelRoot expandView(RelDataType rowType, String queryString, List<String> schemaPath, List<String> viewPath) {
        Preconditions.checkNotNull(viewPath);
        Preconditions.checkState((!viewPath.isEmpty() ? 1 : 0) != 0);
        String dbName = Util.last(schemaPath);
        String tableName = viewPath.get(0);
        SqlNode sqlNode = this.hiveToRelConverter.processView(dbName, tableName).accept(new FuzzyUnionSqlRewriter(tableName, this.hiveToRelConverter));
        return this.hiveToRelConverter.getSqlToRelConverter().convertQuery(sqlNode, true, true);
    }
}

