/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel.functions;

import com.google.common.base.Preconditions;
import com.linkedin.coral.calcite.$internal.com.google.common.collect.HashMultimap;
import com.linkedin.coral.calcite.$internal.com.google.common.collect.ImmutableList;
import com.linkedin.coral.calcite.$internal.com.google.common.collect.ImmutableMultimap;
import com.linkedin.coral.calcite.$internal.com.google.common.collect.Multimap;
import com.linkedin.coral.common.functions.CoralSqlUnnestOperator;
import com.linkedin.coral.common.functions.Function;
import com.linkedin.coral.common.functions.FunctionRegistry;
import com.linkedin.coral.common.functions.FunctionReturnTypes;
import com.linkedin.coral.common.functions.GenericProjectFunction;
import com.linkedin.coral.common.functions.OperandTypeInference;
import com.linkedin.coral.common.functions.SameOperandTypeExceptFirstOperandChecker;
import com.linkedin.coral.hive.hive2rel.functions.CoalesceStructUtility;
import com.linkedin.coral.hive.hive2rel.functions.HiveFunction;
import com.linkedin.coral.hive.hive2rel.functions.HiveJsonTupleOperator;
import com.linkedin.coral.hive.hive2rel.functions.HiveNamedStructFunction;
import com.linkedin.coral.hive.hive2rel.functions.HiveRLikeOperator;
import com.linkedin.coral.hive.hive2rel.functions.HiveReflectOperator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SameOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeTransforms;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;

public class StaticHiveFunctionRegistry
implements FunctionRegistry {
    public static final String IS_TEST_MEMBER_ID_CLASS = "com.linkedin.dali.udf.istestmemberid.hive.IsTestMemberId";
    static final Multimap<String, Function> FUNCTION_MAP = HashMultimap.create();
    public static final Map<String, ImmutableList<String>> UDTF_RETURN_FIELD_NAME_MAP = new HashMap<String, ImmutableList<String>>();

    @Override
    public Collection<Function> lookup(String functionName) {
        return FUNCTION_MAP.get(functionName.toLowerCase());
    }

    public ImmutableMultimap<String, Function> getRegistry() {
        return ImmutableMultimap.copyOf(FUNCTION_MAP);
    }

    private static void addFunctionEntry(String functionName, SqlOperator operator) {
        FUNCTION_MAP.put(functionName.toLowerCase(), new Function(functionName, operator));
    }

    public static void createAddUserDefinedFunction(String functionName, SqlReturnTypeInference returnTypeInference, SqlOperandTypeChecker operandTypeChecker) {
        StaticHiveFunctionRegistry.addFunctionEntry(functionName, StaticHiveFunctionRegistry.createCalciteUDF(functionName, returnTypeInference, operandTypeChecker));
    }

    public static void createAddUserDefinedFunction(String functionName, SqlReturnTypeInference returnTypeInference, SqlOperandTypeChecker operandTypeChecker, String dependency) {
        String depPrefix = dependency.substring(0, 6).toLowerCase();
        if (!depPrefix.equals("ivy://")) {
            dependency = "ivy://" + dependency;
        }
        StaticHiveFunctionRegistry.addFunctionEntry(functionName, StaticHiveFunctionRegistry.createCalciteUDF(functionName, returnTypeInference, operandTypeChecker));
    }

    public static void createAddUserDefinedTableFunction(String functionName, ImmutableList<String> returnFieldNames, ImmutableList<?> returnFieldTypes, SqlOperandTypeChecker operandTypeChecker) {
        Preconditions.checkArgument((!returnFieldTypes.isEmpty() && returnFieldTypes.size() == returnFieldNames.size() && (returnFieldTypes.stream().allMatch(type -> type instanceof SqlTypeName) || returnFieldTypes.stream().allMatch(type -> type instanceof SqlReturnTypeInference)) ? 1 : 0) != 0);
        if (returnFieldTypes.get(0) instanceof SqlTypeName) {
            StaticHiveFunctionRegistry.createAddUserDefinedFunction(functionName, FunctionReturnTypes.rowOf(returnFieldNames, ImmutableList.copyOf(returnFieldTypes.stream().map(type -> (SqlTypeName)((Object)((Object)type))).collect(Collectors.toList()))), operandTypeChecker);
        } else {
            StaticHiveFunctionRegistry.createAddUserDefinedFunction(functionName, FunctionReturnTypes.rowOfInference(returnFieldNames, ImmutableList.copyOf(returnFieldTypes.stream().map(type -> (SqlReturnTypeInference)type).collect(Collectors.toList()))), operandTypeChecker);
        }
        UDTF_RETURN_FIELD_NAME_MAP.put(functionName, returnFieldNames);
    }

    private static SqlOperator createCalciteUDF(String functionName, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, List<RelDataType> paramTypes) {
        return new SqlUserDefinedFunction(new SqlIdentifier(functionName, SqlParserPos.ZERO), returnTypeInference, operandTypeInference, operandTypeChecker, paramTypes, null);
    }

    private static SqlOperator createCalciteUDF(String functionName, SqlReturnTypeInference returnTypeInference, SqlOperandTypeChecker operandTypeChecker) {
        return new SqlUserDefinedFunction(new SqlIdentifier(functionName, SqlParserPos.ZERO), returnTypeInference, null, operandTypeChecker, null, null);
    }

    private static SqlOperator createCalciteUDF(String functionName, SqlReturnTypeInference returnTypeInference) {
        return StaticHiveFunctionRegistry.createCalciteUDF(functionName, returnTypeInference, null);
    }

    private static void addCastOperatorEntries() {
        String[] castFunctions;
        for (String f : castFunctions = new String[]{"tok_boolean", "tok_int", "tok_string", "tok_double", "tok_float", "tok_bigint", "tok_tinyint", "tok_smallint", "tok_char", "tok_decimal", "tok_varchar", "tok_binary", "tok_date", "tok_timestamp"}) {
            FUNCTION_MAP.put(f, HiveFunction.CAST);
        }
    }

    private static Predicate<Integer> optionalOrd(int ordinal) {
        return input -> input == ordinal;
    }

    private static Predicate<Integer> optionalOrd(List<Integer> ordinals) {
        return ordinals::contains;
    }

    static {
        StaticHiveFunctionRegistry.addFunctionEntry("sum", SqlStdOperatorTable.SUM);
        StaticHiveFunctionRegistry.addFunctionEntry("count", SqlStdOperatorTable.COUNT);
        StaticHiveFunctionRegistry.addFunctionEntry("avg", SqlStdOperatorTable.AVG);
        StaticHiveFunctionRegistry.addFunctionEntry("min", SqlStdOperatorTable.MIN);
        StaticHiveFunctionRegistry.addFunctionEntry("max", SqlStdOperatorTable.MAX);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("collect_list", FunctionReturnTypes.ARRAY_OF_ARG0_TYPE, OperandTypes.ANY);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("collect_set", FunctionReturnTypes.ARRAY_OF_ARG0_TYPE, OperandTypes.ANY);
        StaticHiveFunctionRegistry.addFunctionEntry("row_number", SqlStdOperatorTable.ROW_NUMBER);
        StaticHiveFunctionRegistry.addFunctionEntry("rank", SqlStdOperatorTable.RANK);
        StaticHiveFunctionRegistry.addFunctionEntry("dense_rank", SqlStdOperatorTable.DENSE_RANK);
        StaticHiveFunctionRegistry.addFunctionEntry("cume_dist", SqlStdOperatorTable.CUME_DIST);
        StaticHiveFunctionRegistry.addFunctionEntry("percent_rank", SqlStdOperatorTable.PERCENT_RANK);
        StaticHiveFunctionRegistry.addFunctionEntry("first_value", SqlStdOperatorTable.FIRST_VALUE);
        StaticHiveFunctionRegistry.addFunctionEntry("last_value", SqlStdOperatorTable.LAST_VALUE);
        StaticHiveFunctionRegistry.addFunctionEntry("nth_value", SqlStdOperatorTable.NTH_VALUE);
        StaticHiveFunctionRegistry.addFunctionEntry("lag", SqlStdOperatorTable.LAG);
        StaticHiveFunctionRegistry.addFunctionEntry("lead", SqlStdOperatorTable.LEAD);
        StaticHiveFunctionRegistry.addFunctionEntry("stddev", SqlStdOperatorTable.STDDEV);
        StaticHiveFunctionRegistry.addFunctionEntry("stddev_samp", SqlStdOperatorTable.STDDEV_SAMP);
        StaticHiveFunctionRegistry.addFunctionEntry("stddev_pop", SqlStdOperatorTable.STDDEV_POP);
        StaticHiveFunctionRegistry.addFunctionEntry("variance", SqlStdOperatorTable.VARIANCE);
        StaticHiveFunctionRegistry.addFunctionEntry("var_samp", SqlStdOperatorTable.VAR_SAMP);
        StaticHiveFunctionRegistry.addFunctionEntry("var_pop", SqlStdOperatorTable.VAR_POP);
        FUNCTION_MAP.put("in", HiveFunction.IN);
        StaticHiveFunctionRegistry.addFunctionEntry("rlike", HiveRLikeOperator.RLIKE);
        StaticHiveFunctionRegistry.addFunctionEntry("regexp", HiveRLikeOperator.REGEXP);
        StaticHiveFunctionRegistry.addFunctionEntry("!=", SqlStdOperatorTable.NOT_EQUALS);
        StaticHiveFunctionRegistry.addFunctionEntry("==", SqlStdOperatorTable.EQUALS);
        StaticHiveFunctionRegistry.addFunctionEntry("tok_isnull", SqlStdOperatorTable.IS_NULL);
        StaticHiveFunctionRegistry.addFunctionEntry("tok_isnotnull", SqlStdOperatorTable.IS_NOT_NULL);
        FUNCTION_MAP.put("when", HiveFunction.WHEN);
        FUNCTION_MAP.put("case", HiveFunction.CASE);
        FUNCTION_MAP.put("between", HiveFunction.BETWEEN);
        StaticHiveFunctionRegistry.addFunctionEntry("nullif", SqlStdOperatorTable.NULLIF);
        StaticHiveFunctionRegistry.addFunctionEntry("isnull", SqlStdOperatorTable.IS_NULL);
        StaticHiveFunctionRegistry.addFunctionEntry("isnotnull", SqlStdOperatorTable.IS_NOT_NULL);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("nvl", ReturnTypes.ARG0_NULLABLE, OperandTypes.and(OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.ANY), OperandTypes.SAME_SAME));
        StaticHiveFunctionRegistry.addFunctionEntry("if", StaticHiveFunctionRegistry.createCalciteUDF("if", FunctionReturnTypes.IF_FUNC_RETURN_TYPE, OperandTypeInference.BOOLEAN_ANY_SAME, new SameOperandTypeExceptFirstOperandChecker(3, SqlTypeName.BOOLEAN), null));
        StaticHiveFunctionRegistry.addFunctionEntry("coalesce", SqlStdOperatorTable.COALESCE);
        StaticHiveFunctionRegistry.addCastOperatorEntries();
        StaticHiveFunctionRegistry.addFunctionEntry("array", SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR);
        StaticHiveFunctionRegistry.addFunctionEntry("struct", SqlStdOperatorTable.ROW);
        StaticHiveFunctionRegistry.addFunctionEntry("map", SqlStdOperatorTable.MAP_VALUE_CONSTRUCTOR);
        StaticHiveFunctionRegistry.addFunctionEntry("named_struct", HiveNamedStructFunction.NAMED_STRUCT);
        StaticHiveFunctionRegistry.addFunctionEntry("generic_project", GenericProjectFunction.GENERIC_PROJECT);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("binary", FunctionReturnTypes.BINARY, OperandTypes.or(OperandTypes.family(SqlTypeFamily.STRING), OperandTypes.family(SqlTypeFamily.BINARY)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("pmod", ReturnTypes.BIGINT, OperandTypes.NUMERIC_NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("round", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.family(ImmutableList.of(SqlTypeFamily.NUMERIC, SqlTypeFamily.INTEGER), StaticHiveFunctionRegistry.optionalOrd(1)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("bround", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.family(ImmutableList.of(SqlTypeFamily.NUMERIC, SqlTypeFamily.INTEGER), StaticHiveFunctionRegistry.optionalOrd(1)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("floor", ReturnTypes.BIGINT_FORCE_NULLABLE, OperandTypes.family(SqlTypeFamily.NUMERIC));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("ceil", ReturnTypes.BIGINT_FORCE_NULLABLE, OperandTypes.family(SqlTypeFamily.NUMERIC));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("ceiling", ReturnTypes.BIGINT_FORCE_NULLABLE, OperandTypes.family(SqlTypeFamily.NUMERIC));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("rand", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.family(ImmutableList.of(SqlTypeFamily.INTEGER), StaticHiveFunctionRegistry.optionalOrd(0)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("exp", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("ln", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("log10", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("log2", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("log", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC_NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("pow", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC_NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("power", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC_NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("sqrt", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("hex", FunctionReturnTypes.STRING, OperandTypes.or(OperandTypes.family(SqlTypeFamily.STRING), OperandTypes.family(SqlTypeFamily.NUMERIC), OperandTypes.family(SqlTypeFamily.BINARY)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("unhex", FunctionReturnTypes.BINARY, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("conv", FunctionReturnTypes.STRING, OperandTypes.or(OperandTypes.family(SqlTypeFamily.EXACT_NUMERIC, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER), OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("abs", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("sin", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("asin", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("cos", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("acos", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("tan", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("atan", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("degrees", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("radians", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("positive", ReturnTypes.ARG0_NULLABLE, OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("negative", ReturnTypes.ARG0_NULLABLE, OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("sign", ReturnTypes.ARG0_NULLABLE, OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("e", ReturnTypes.DOUBLE, OperandTypes.NILADIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("pi", ReturnTypes.DOUBLE, OperandTypes.NILADIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("factorial", ReturnTypes.BIGINT_NULLABLE, OperandTypes.family(SqlTypeFamily.INTEGER));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("cbrt", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("shiftleft", ReturnTypes.ARG0_NULLABLE, OperandTypes.EXACT_NUMERIC_EXACT_NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("shiftright", ReturnTypes.ARG0_NULLABLE, OperandTypes.EXACT_NUMERIC_EXACT_NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("shiftrightunsigned", ReturnTypes.ARG0_NULLABLE, OperandTypes.EXACT_NUMERIC_EXACT_NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("greatest", ReturnTypes.ARG0_NULLABLE, OperandTypes.SAME_VARIADIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("least", ReturnTypes.ARG0_NULLABLE, OperandTypes.SAME_VARIADIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("width_bucket", ReturnTypes.INTEGER_NULLABLE, OperandTypes.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC, SqlTypeFamily.INTEGER));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("ascii", ReturnTypes.INTEGER, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("base64", FunctionReturnTypes.STRING, OperandTypes.BINARY);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("character_length", ReturnTypes.INTEGER, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("chr", FunctionReturnTypes.STRING, OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("concat", ReturnTypes.cascade(FunctionReturnTypes.STRING, SqlTypeTransforms.TO_NULLABLE), OperandTypes.SAME_VARIADIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("concat_ws", FunctionReturnTypes.STRING, new SqlOperandTypeChecker(){

            @Override
            public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
                return OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.ARRAY).checkOperandTypes(callBinding, throwOnFailure) || new SameOperandTypeChecker(-1).checkOperandTypes(callBinding, throwOnFailure);
            }

            @Override
            public SqlOperandCountRange getOperandCountRange() {
                return SqlOperandCountRanges.from(2);
            }

            @Override
            public String getAllowedSignatures(SqlOperator op, String opName) {
                return opName + "(STRING, ARRAY|STRING, ...)";
            }

            @Override
            public SqlOperandTypeChecker.Consistency getConsistency() {
                return SqlOperandTypeChecker.Consistency.NONE;
            }

            @Override
            public boolean isOptional(int i) {
                return false;
            }
        });
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("context_ngrams", ReturnTypes.LEAST_RESTRICTIVE, OperandTypes.family(SqlTypeFamily.ARRAY, SqlTypeFamily.ARRAY, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("decode", FunctionReturnTypes.STRING, OperandTypes.family(SqlTypeFamily.BINARY, SqlTypeFamily.STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("elt", FunctionReturnTypes.STRING, OperandTypes.VARIADIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("encode", FunctionReturnTypes.BINARY, OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("field", ReturnTypes.INTEGER, OperandTypes.VARIADIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("find_in_set", ReturnTypes.INTEGER, OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("format_number", FunctionReturnTypes.STRING, OperandTypes.NUMERIC_INTEGER);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("get_json_object", FunctionReturnTypes.STRING, OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("in_file", ReturnTypes.BOOLEAN, OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("initcap", FunctionReturnTypes.STRING, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("instr", ReturnTypes.INTEGER, OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("length", ReturnTypes.INTEGER_NULLABLE, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("levenshtein", ReturnTypes.INTEGER, OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("locate", FunctionReturnTypes.STRING, OperandTypes.family(ImmutableList.of(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.INTEGER), StaticHiveFunctionRegistry.optionalOrd(2)));
        StaticHiveFunctionRegistry.addFunctionEntry("lower", SqlStdOperatorTable.LOWER);
        StaticHiveFunctionRegistry.addFunctionEntry("lcase", SqlStdOperatorTable.LOWER);
        StaticHiveFunctionRegistry.addFunctionEntry("translate", SqlLibraryOperators.TRANSLATE3);
        StaticHiveFunctionRegistry.addFunctionEntry("translate3", SqlLibraryOperators.TRANSLATE3);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("lpad", FunctionReturnTypes.STRING, OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.INTEGER, SqlTypeFamily.STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("ltrim", FunctionReturnTypes.STRING, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("ngrams", ReturnTypes.LEAST_RESTRICTIVE, OperandTypes.family(SqlTypeFamily.ARRAY, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("octet_length", ReturnTypes.INTEGER, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("parse_url", FunctionReturnTypes.STRING, OperandTypes.family(Collections.nCopies(3, SqlTypeFamily.STRING), StaticHiveFunctionRegistry.optionalOrd(2)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("printf", FunctionReturnTypes.STRING, OperandTypes.VARIADIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("regexp_extract", ReturnTypes.ARG0, OperandTypes.family(ImmutableList.of(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.INTEGER), StaticHiveFunctionRegistry.optionalOrd(2)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("regexp_replace", FunctionReturnTypes.STRING, OperandTypes.STRING_STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("repeat", FunctionReturnTypes.STRING, OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.INTEGER));
        StaticHiveFunctionRegistry.addFunctionEntry("replace", SqlStdOperatorTable.REPLACE);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("reverse", ReturnTypes.ARG0, OperandTypes.or(OperandTypes.STRING, OperandTypes.NULLABLE_LITERAL));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("rpad", FunctionReturnTypes.STRING, OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.INTEGER, SqlTypeFamily.STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("rtrim", FunctionReturnTypes.STRING, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("sentences", ReturnTypes.LEAST_RESTRICTIVE, OperandTypes.STRING_STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("soundex", FunctionReturnTypes.STRING, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("space", FunctionReturnTypes.STRING, OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("split", FunctionReturnTypes.arrayOfType(SqlTypeName.VARCHAR), OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("str_to_map", FunctionReturnTypes.mapOfType(SqlTypeName.VARCHAR, SqlTypeName.VARCHAR), OperandTypes.family(Collections.nCopies(3, SqlTypeFamily.STRING), StaticHiveFunctionRegistry.optionalOrd(ImmutableList.of(Integer.valueOf(1), Integer.valueOf(2)))));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("substr", FunctionReturnTypes.STRING, OperandTypes.family(ImmutableList.of(SqlTypeFamily.STRING, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER), StaticHiveFunctionRegistry.optionalOrd(2)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("substring", FunctionReturnTypes.STRING, OperandTypes.family(ImmutableList.of(SqlTypeFamily.STRING, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER), StaticHiveFunctionRegistry.optionalOrd(2)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("substring_index", FunctionReturnTypes.STRING, OperandTypes.STRING_STRING_INTEGER);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("trim", FunctionReturnTypes.STRING, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("unbase64", ReturnTypes.explicit(SqlTypeName.VARBINARY), OperandTypes.or(OperandTypes.STRING, OperandTypes.NULLABLE_LITERAL));
        StaticHiveFunctionRegistry.addFunctionEntry("upper", SqlStdOperatorTable.UPPER);
        StaticHiveFunctionRegistry.addFunctionEntry("ucase", SqlStdOperatorTable.UPPER);
        StaticHiveFunctionRegistry.addFunctionEntry("initcap", SqlStdOperatorTable.INITCAP);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("md5", FunctionReturnTypes.STRING, OperandTypes.or(OperandTypes.family(SqlTypeFamily.STRING), OperandTypes.family(SqlTypeFamily.BINARY)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("sha1", FunctionReturnTypes.STRING, OperandTypes.or(OperandTypes.family(SqlTypeFamily.STRING), OperandTypes.family(SqlTypeFamily.BINARY)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("sha", FunctionReturnTypes.STRING, OperandTypes.or(OperandTypes.family(SqlTypeFamily.STRING), OperandTypes.family(SqlTypeFamily.BINARY)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("crc32", ReturnTypes.BIGINT, OperandTypes.or(OperandTypes.family(SqlTypeFamily.STRING), OperandTypes.family(SqlTypeFamily.BINARY)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("xpath", FunctionReturnTypes.arrayOfType(SqlTypeName.VARCHAR), OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("xpath_string", FunctionReturnTypes.STRING, OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("xpath_boolean", ReturnTypes.BOOLEAN, OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("xpath_short", FunctionReturnTypes.SMALLINT, OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("xpath_int", ReturnTypes.INTEGER, OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("xpath_long", ReturnTypes.BIGINT, OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("xpath_float", ReturnTypes.DOUBLE, OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("xpath_double", ReturnTypes.DOUBLE, OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("xpath_number", ReturnTypes.DOUBLE, OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("from_unixtime", FunctionReturnTypes.STRING, OperandTypes.family(ImmutableList.of(SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING), StaticHiveFunctionRegistry.optionalOrd(1)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("unix_timestamp", ReturnTypes.BIGINT, OperandTypes.family(ImmutableList.of(SqlTypeFamily.STRING, SqlTypeFamily.STRING), StaticHiveFunctionRegistry.optionalOrd(ImmutableList.of(Integer.valueOf(0), Integer.valueOf(1)))));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("to_date", FunctionReturnTypes.STRING, OperandTypes.or(OperandTypes.STRING, OperandTypes.DATETIME));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("date", ReturnTypes.DATE, OperandTypes.or(OperandTypes.STRING, OperandTypes.DATETIME));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("year", ReturnTypes.INTEGER, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("quarter", ReturnTypes.INTEGER, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("month", ReturnTypes.INTEGER, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("day", ReturnTypes.INTEGER, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("dayofmonth", ReturnTypes.INTEGER, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("hour", ReturnTypes.INTEGER, OperandTypes.or(OperandTypes.STRING, OperandTypes.DATETIME));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("minute", ReturnTypes.INTEGER, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("second", ReturnTypes.INTEGER, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("weekofyear", ReturnTypes.INTEGER, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("datediff", ReturnTypes.INTEGER, OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("date_add", FunctionReturnTypes.STRING, OperandTypes.or(OperandTypes.family(SqlTypeFamily.DATE, SqlTypeFamily.INTEGER), OperandTypes.family(SqlTypeFamily.TIMESTAMP, SqlTypeFamily.INTEGER), OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.INTEGER)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("date_sub", FunctionReturnTypes.STRING, OperandTypes.or(OperandTypes.family(SqlTypeFamily.DATE, SqlTypeFamily.INTEGER), OperandTypes.family(SqlTypeFamily.TIMESTAMP, SqlTypeFamily.INTEGER), OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.INTEGER)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("from_utc_timestamp", ReturnTypes.explicit(SqlTypeName.TIMESTAMP), OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.STRING));
        StaticHiveFunctionRegistry.addFunctionEntry("current_date", SqlStdOperatorTable.CURRENT_DATE);
        StaticHiveFunctionRegistry.addFunctionEntry("current_timestamp", SqlStdOperatorTable.CURRENT_TIMESTAMP);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("add_months", FunctionReturnTypes.STRING, OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.INTEGER));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("last_day", FunctionReturnTypes.STRING, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("next_day", FunctionReturnTypes.STRING, OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("trunc", FunctionReturnTypes.STRING, OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("months_between", ReturnTypes.DOUBLE, OperandTypes.family(SqlTypeFamily.DATE, SqlTypeFamily.DATE));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("date_format", FunctionReturnTypes.STRING, OperandTypes.or(OperandTypes.family(SqlTypeFamily.DATE, SqlTypeFamily.STRING), OperandTypes.family(SqlTypeFamily.TIMESTAMP, SqlTypeFamily.STRING), OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("to_utc_timestamp", FunctionReturnTypes.STRING, OperandTypes.or(OperandTypes.STRING_STRING, OperandTypes.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING)));
        StaticHiveFunctionRegistry.addFunctionEntry("size", SqlStdOperatorTable.CARDINALITY);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("array_contains", ReturnTypes.BOOLEAN, OperandTypes.family(SqlTypeFamily.ARRAY, SqlTypeFamily.ANY));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("map_keys", opBinding -> {
            RelDataType operandType = opBinding.getOperandType(0);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createArrayType(operandType.getKeyType(), -1L);
        }, OperandTypes.family(SqlTypeFamily.MAP));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("map_values", opBinding -> {
            RelDataType operandType = opBinding.getOperandType(0);
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createArrayType(operandType.getValueType(), -1L);
        }, OperandTypes.family(SqlTypeFamily.MAP));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("array_contains", ReturnTypes.BOOLEAN, OperandTypes.family(SqlTypeFamily.ARRAY, SqlTypeFamily.ANY));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("sort_array", ReturnTypes.ARG0, OperandTypes.ARRAY);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("extract_union", CoalesceStructUtility.COALESCE_STRUCT_FUNCTION_RETURN_STRATEGY, OperandTypes.or(OperandTypes.ANY, OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.INTEGER)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("coalesce_struct", CoalesceStructUtility.COALESCE_STRUCT_FUNCTION_RETURN_STRATEGY, OperandTypes.or(OperandTypes.ANY, OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.INTEGER)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.bug.DummyUdf", FunctionReturnTypes.STRING, OperandTypes.or(OperandTypes.STRING, OperandTypes.ARRAY));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction(IS_TEST_MEMBER_ID_CLASS, ReturnTypes.BOOLEAN, OperandTypes.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.CHARACTER));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.urnextractor.hive.UrnExtractor", FunctionReturnTypes.ARRAY_OF_STR_STR_MAP, OperandTypes.or(OperandTypes.STRING, OperandTypes.ARRAY));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.udf.aws.ReadJsonUDF", FunctionReturnTypes.STRING, OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.udf.hdfs.GetDatasetNameFromPathUDF", FunctionReturnTypes.STRING, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.isguestmemberid.hive.IsGuestMemberId", ReturnTypes.BOOLEAN, OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.watbotcrawlerlookup.hive.WATBotCrawlerLookup", FunctionReturnTypes.rowOf(ImmutableList.of("iscrawler", "crawlerid"), ImmutableList.of(SqlTypeName.BOOLEAN, SqlTypeName.VARCHAR)), OperandTypes.family(ImmutableList.of(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING), StaticHiveFunctionRegistry.optionalOrd(ImmutableList.of(Integer.valueOf(2), Integer.valueOf(3)))));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.userinterfacelookup.hive.UserInterfaceLookup", FunctionReturnTypes.STRING, OperandTypes.or(OperandTypes.family(Collections.nCopies(8, SqlTypeFamily.STRING)), OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.portallookup.hive.PortalLookup", FunctionReturnTypes.STRING, OperandTypes.STRING_STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.useragentparser.hive.UserAgentParser", FunctionReturnTypes.STRING, OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.maplookup.hive.MapLookup", ReturnTypes.cascade(FunctionReturnTypes.STRING, SqlTypeTransforms.FORCE_NULLABLE), OperandTypes.family(SqlTypeFamily.MAP, SqlTypeFamily.STRING, SqlTypeFamily.STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.monarch.UrnGenerator", FunctionReturnTypes.STRING, OperandTypes.VARIADIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.genericlookup.hive.GenericLookup", FunctionReturnTypes.STRING, OperandTypes.or(OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.ANY, SqlTypeFamily.ANY), OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.ANY, SqlTypeFamily.ANY, SqlTypeFamily.ANY)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.tscp.reporting.dali.udfs.UrnToID", FunctionReturnTypes.STRING, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.date.hive.DateFormatToEpoch", ReturnTypes.BIGINT_NULLABLE, OperandTypes.STRING_STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.date.hive.EpochToDateFormat", FunctionReturnTypes.STRING, OperandTypes.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING, SqlTypeFamily.STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.date.hive.EpochToEpochMilliseconds", ReturnTypes.BIGINT_NULLABLE, OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.udf.sanitize.hive.Sanitize", FunctionReturnTypes.STRING, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.coral.$internal.org.apache.hadoop.hive.ql.udf.generic.GenericProject", ReturnTypes.ARG0, OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.view.udf.entityhandles.GetIdFromUrn", ReturnTypes.BIGINT, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.view.udf.entityhandles.GetPermissionsString", FunctionReturnTypes.STRING, OperandTypes.family(SqlTypeFamily.ARRAY));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.view.udf.entityhandles.EpochTimeInSeconds", ReturnTypes.BIGINT, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.view.udf.entityhandles.EpochTimeInSecondsNullable", ReturnTypes.BIGINT_NULLABLE, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.view.udf.entityhandles.IsUrnForType", ReturnTypes.BOOLEAN, OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.view.udf.entityhandles.PhoneNumberNormalizer", FunctionReturnTypes.STRING, OperandTypes.STRING_STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.views.job.udf.GetUUID", FunctionReturnTypes.STRING, OperandTypes.BINARY);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.views.premium.udf.GetOrderUrn", FunctionReturnTypes.STRING, OperandTypes.family(SqlTypeFamily.MAP, SqlTypeFamily.STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.views.premium.udf.GetChooserId", FunctionReturnTypes.STRING, OperandTypes.family(SqlTypeFamily.MAP));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.views.premium.udf.GetFamily", FunctionReturnTypes.STRING, OperandTypes.family(SqlTypeFamily.MAP));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.views.premium.udf.GetPriceUrnList", FunctionReturnTypes.arrayOfType(SqlTypeName.VARCHAR), OperandTypes.family(SqlTypeFamily.MAP));
        SqlReturnTypeInference hitInfo = FunctionReturnTypes.rowOfInference(ImmutableList.of("secondarysearchresultinfo", "entityawaresuggestioninfo"), ImmutableList.of(FunctionReturnTypes.rowOf(ImmutableList.of("vertical"), ImmutableList.of(SqlTypeName.VARCHAR)), FunctionReturnTypes.rowOfInference(ImmutableList.of("suggestedentities"), ImmutableList.of(FunctionReturnTypes.arrayOfType(SqlTypeName.VARCHAR, true)))));
        SqlReturnTypeInference gridPositionInfo = FunctionReturnTypes.rowOf(ImmutableList.of("row", "column"), ImmutableList.of(SqlTypeName.INTEGER, SqlTypeName.INTEGER));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.views.search.udf.CreateSearchActionResultUDF", FunctionReturnTypes.rowOfInference(ImmutableList.of("entityurn", "resulttype", "absoluteposition", "positioninvertical", "iscachehit", "isanonymized", "hitinfo", "gridposition", "isnamematch", "trackingid"), ImmutableList.of(FunctionReturnTypes.STRING, FunctionReturnTypes.STRING, ReturnTypes.INTEGER_NULLABLE, ReturnTypes.INTEGER_NULLABLE, ReturnTypes.BOOLEAN, ReturnTypes.BOOLEAN, hitInfo, gridPositionInfo, ReturnTypes.BOOLEAN, FunctionReturnTypes.BINARY)), OperandTypes.family(SqlTypeFamily.MAP, SqlTypeFamily.STRING, SqlTypeFamily.STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.views.search.udf.GetActionTypeUDF", FunctionReturnTypes.STRING, OperandTypes.or(OperandTypes.STRING_STRING_STRING, OperandTypes.STRING_STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.views.search.udf.GetTYAHResultTypeUDF", FunctionReturnTypes.STRING, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.views.search.udf.GetVerticalUDF", FunctionReturnTypes.STRING, OperandTypes.or(OperandTypes.STRING_STRING_STRING, OperandTypes.STRING_STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.views.search.udf.IsTYAHSearchResultsUDF", ReturnTypes.BOOLEAN, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.views.search.udf.IsValidKeyUDF", ReturnTypes.BOOLEAN, OperandTypes.or(OperandTypes.STRING_STRING_STRING, OperandTypes.STRING_STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.ds.udf.hive.filter.IsTestMemberId", ReturnTypes.BOOLEAN, OperandTypes.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.ds.udf.hive.lookup.PortalLookup", FunctionReturnTypes.STRING, OperandTypes.STRING_STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.ds.udf.hive.lookup.UserInterfaceLookup", FunctionReturnTypes.STRING, OperandTypes.family(Collections.nCopies(8, SqlTypeFamily.STRING)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.ds.udf.hive.lookup.WATBotCrawlerLookup", FunctionReturnTypes.rowOf(ImmutableList.of("iscrawler", "crawlerid"), ImmutableList.of(SqlTypeName.BOOLEAN, SqlTypeName.VARCHAR)), OperandTypes.or(OperandTypes.STRING_STRING_STRING, OperandTypes.STRING_STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dwh.udf.hive.lookup.OsLookup", FunctionReturnTypes.rowOf(ImmutableList.of("os_name", "os_major_version", "os_full_version"), ImmutableList.of(SqlTypeName.VARCHAR, SqlTypeName.VARCHAR, SqlTypeName.VARCHAR)), OperandTypes.or(OperandTypes.STRING_STRING, OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.ANY)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dwh.udf.profile.GetProfileUrl", FunctionReturnTypes.STRING, OperandTypes.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dwh.udf.sessionization.CleanupBrowserId", FunctionReturnTypes.STRING, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.etg.business.common.udfs.MapSfdcProductName", FunctionReturnTypes.STRING, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.etg.business.common.udfs.MapSfdcProductCode", FunctionReturnTypes.STRING, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.etg.business.common.udfs.MapSfdcProductId", ReturnTypes.INTEGER, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("udfs.SeoReferrerTrkUdf", FunctionReturnTypes.STRING, OperandTypes.STRING_STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.vector.daliview.udf.PresentDataType", FunctionReturnTypes.STRING, OperandTypes.family(SqlTypeFamily.ANY));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.vector.daliview.udf.PresentMediaType", FunctionReturnTypes.STRING, OperandTypes.family(SqlTypeFamily.ANY));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.vector.daliview.udf.UnifyVideoOrAudioDurationMicroSeconds", ReturnTypes.BIGINT, OperandTypes.family(SqlTypeFamily.ANY));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.tscp.reporting.dali.udfs.AdClickClassifier", FunctionReturnTypes.rowOf(ImmutableList.of("clicks", "landingPageClicks", "totalEngagements", "otherEngagements", "likes", "commentLikes", "comments", "shares", "follows", "oneClickLeadFormOpens", "companyPageClicks", "fullScreenPlays", new String[]{"viralClicks", "viralLandingPageClicks", "viralLikes", "viralCommentLikes", "viralComments", "viralShares", "viralFollows", "viralOneClickLeadFormOpens", "viralCompanyPageClicks", "viralFullScreenPlays", "viralTotalEngagements", "viralOtherEngagements", "adUnitClicks", "actionClicks", "textUrlClicks", "opens", "cardClicks", "viralCardClicks", "costInUsd", "costInLocalCurrency"}), ImmutableList.of(SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, new SqlTypeName[]{SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.INTEGER, SqlTypeName.DOUBLE, SqlTypeName.DOUBLE})), OperandTypes.family(SqlTypeFamily.INTEGER, SqlTypeFamily.STRING, SqlTypeFamily.INTEGER, SqlTypeFamily.MAP, SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING, SqlTypeFamily.MAP, SqlTypeFamily.ANY, SqlTypeFamily.STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.tscp.reporting.dali.udfs.UnifiedCampaignType", FunctionReturnTypes.STRING, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.tscp.reporting.dali.udfs.ActivityId", ReturnTypes.BIGINT, OperandTypes.family(SqlTypeFamily.MAP));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.tscp.reporting.dali.udfs.AdPlacementClassifier", FunctionReturnTypes.STRING, OperandTypes.family(SqlTypeFamily.INTEGER));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.tscp.reporting.dali.udfs.SponsoredMessageNodeId", ReturnTypes.INTEGER, OperandTypes.family(SqlTypeFamily.STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.orbit.emerger.coercerudfs.DynamicsLineOfBusinessCoercer", FunctionReturnTypes.STRING, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.orbit.emerger.coercerudfs.GenerateId", FunctionReturnTypes.STRING, new SqlOperandTypeChecker(){

            @Override
            public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
                return true;
            }

            @Override
            public SqlOperandCountRange getOperandCountRange() {
                return SqlOperandCountRanges.from(1);
            }

            @Override
            public String getAllowedSignatures(SqlOperator op, String opName) {
                return opName + "(ANY, ...)";
            }

            @Override
            public SqlOperandTypeChecker.Consistency getConsistency() {
                return SqlOperandTypeChecker.Consistency.NONE;
            }

            @Override
            public boolean isOptional(int i) {
                return false;
            }
        });
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.etg.business.common.udfs.MapD365OptionSet", FunctionReturnTypes.STRING, OperandTypes.STRING_STRING_STRING);
        SqlReturnTypeInference getProfileSectionsReturnTypeInference = opBinding -> {
            int numArgs = opBinding.getOperandCount();
            Preconditions.checkState((numArgs == 2 ? 1 : 0) != 0, (Object)"UDF isb.GetProfileSections must take 2 arguments.");
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            RelDataType retType = opBinding.getOperandType(0).getValueType();
            return typeFactory.createArrayType(retType, -1L);
        };
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("isb.GetProfileSections", getProfileSectionsReturnTypeInference, OperandTypes.family(SqlTypeFamily.MAP, SqlTypeFamily.ARRAY));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.recruiter.udf.GetEventOriginUDF", FunctionReturnTypes.STRING, OperandTypes.or(OperandTypes.STRING_STRING_STRING, OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.recruiter.udf.QueryRoutingTypeUDF", FunctionReturnTypes.STRING, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.recruiter.udf.SearchQueryUDF", FunctionReturnTypes.STRING, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.snapshot.udf.ConstructSnapshotUrnUdf", FunctionReturnTypes.STRING, OperandTypes.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.snapshot.udf.SnapshotPurgeEligibleUdf", ReturnTypes.BOOLEAN, OperandTypes.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.daliudfs.hive.DateFormatToEpoch", ReturnTypes.BIGINT_NULLABLE, OperandTypes.STRING_STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.daliudfs.hive.EpochToDateFormat", FunctionReturnTypes.STRING, OperandTypes.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING, SqlTypeFamily.STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.daliudfs.hive.EpochToEpochMilliseconds", ReturnTypes.BIGINT_NULLABLE, OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.stringudfs.hive.InitCap", FunctionReturnTypes.STRING, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.daliudfs.hive.IsGuestMemberId", ReturnTypes.BOOLEAN, OperandTypes.NUMERIC);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.daliudfs.hive.MapLookup", ReturnTypes.cascade(FunctionReturnTypes.STRING, SqlTypeTransforms.FORCE_NULLABLE), OperandTypes.family(SqlTypeFamily.MAP, SqlTypeFamily.STRING, SqlTypeFamily.STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.daliudfs.hive.PortalLookup", FunctionReturnTypes.STRING, OperandTypes.STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.daliudfs.hive.Sanitize", FunctionReturnTypes.STRING, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.jemslookup.udf.hive.JemsLookup", FunctionReturnTypes.rowOfInference(ImmutableList.of("jobproductid", "jobproductname", "jobentitlementids", "jobentitlementnameswithnamespace", "listingtype", "sublistingtype", "istestjob"), ImmutableList.of(ReturnTypes.BIGINT, FunctionReturnTypes.STRING, FunctionReturnTypes.arrayOfType(SqlTypeName.BIGINT, true), FunctionReturnTypes.arrayOfType(SqlTypeName.VARCHAR, true), FunctionReturnTypes.STRING, FunctionReturnTypes.STRING, ReturnTypes.BOOLEAN)), OperandTypes.family(ImmutableList.of(SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.userinterfacelookup.hive.UserInterfaceLookup", FunctionReturnTypes.STRING, OperandTypes.or(OperandTypes.family(Collections.nCopies(8, SqlTypeFamily.STRING)), OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.userinterfacelookuptest.hive.UserInterfaceLookupTest", FunctionReturnTypes.STRING, OperandTypes.or(OperandTypes.family(Collections.nCopies(8, SqlTypeFamily.STRING)), OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.parsing.hive.UserAgentParser", FunctionReturnTypes.STRING, OperandTypes.family(Collections.nCopies(2, SqlTypeFamily.STRING)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.parsing.hive.Ip2Str", FunctionReturnTypes.STRING, OperandTypes.or(OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC), OperandTypes.family(SqlTypeFamily.STRING)));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.lookup.hive.BrowserLookup", FunctionReturnTypes.rowOfInference(ImmutableList.of("browser_name", "browser_major_version", "browser_full_version"), ImmutableList.of(FunctionReturnTypes.STRING, FunctionReturnTypes.STRING, FunctionReturnTypes.STRING)), OperandTypes.STRING_STRING_STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.daliudfs.hive.IsTestMemberId", ReturnTypes.BOOLEAN, OperandTypes.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.urnextractor.hive.UrnExtractorFunctionWrapper", opBinding -> {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createArrayType(typeFactory.createMapType(typeFactory.createSqlType(SqlTypeName.VARCHAR), typeFactory.createSqlType(SqlTypeName.VARCHAR)), -1L);
        }, OperandTypes.or(OperandTypes.ARRAY, OperandTypes.STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.stdudfs.hive.daliudfs.UrnExtractorFunctionWrapper", opBinding -> {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            return typeFactory.createArrayType(typeFactory.createMapType(typeFactory.createSqlType(SqlTypeName.VARCHAR), typeFactory.createSqlType(SqlTypeName.VARCHAR)), -1L);
        }, OperandTypes.or(OperandTypes.ARRAY, OperandTypes.STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.udfs.standard.hive.ObfuscateMemberIdNumeric", ReturnTypes.BIGINT, OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.udfs.standard.hive.ObfuscateMemberIdNumericInt", ReturnTypes.BIGINT, OperandTypes.family(SqlTypeFamily.INTEGER, SqlTypeFamily.STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.udfs.standard.hive.ObfuscateMemberIdNumericLong", ReturnTypes.BIGINT, OperandTypes.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.udfs.standard.hive.ObfuscateAll", ReturnTypes.ARG0, OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.udfs.standard.hive.ObfuscateArray", ReturnTypes.ARG0, OperandTypes.family(SqlTypeFamily.ARRAY, SqlTypeFamily.STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.udfs.standard.hive.ObfuscateArrayEvolve", ReturnTypes.ARG0, OperandTypes.family(SqlTypeFamily.ARRAY, SqlTypeFamily.STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.udfs.standard.hive.ObfuscateStruct", ReturnTypes.ARG0, OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.udfs.standard.hive.ObfuscateMap", ReturnTypes.ARG0, OperandTypes.family(SqlTypeFamily.MAP, SqlTypeFamily.STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.udfs.standard.hive.ObfuscateMapEvolve", ReturnTypes.ARG0, OperandTypes.family(SqlTypeFamily.MAP, SqlTypeFamily.STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.udfs.standard.hive.ObfuscateMapKeyEvolve", ReturnTypes.ARG0, OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.udfs.standard.hive.ObfuscateMapValEvolve", ReturnTypes.ARG0, OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.STRING));
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.jobs.udf.hive.ConvertIndustryCode", FunctionReturnTypes.STRING, OperandTypes.STRING);
        StaticHiveFunctionRegistry.createAddUserDefinedFunction("com.linkedin.dali.customudf.date.hive.DateFormatToEpoch", ReturnTypes.BIGINT_NULLABLE, OperandTypes.STRING_STRING_STRING);
        StaticHiveFunctionRegistry.addFunctionEntry("explode", new CoralSqlUnnestOperator(false));
        StaticHiveFunctionRegistry.addFunctionEntry("posexplode", new CoralSqlUnnestOperator(true));
        StaticHiveFunctionRegistry.addFunctionEntry("json_tuple", HiveJsonTupleOperator.JSON_TUPLE);
        StaticHiveFunctionRegistry.addFunctionEntry("reflect", HiveReflectOperator.REFLECT);
        StaticHiveFunctionRegistry.addFunctionEntry("java_method", HiveReflectOperator.REFLECT);
        StaticHiveFunctionRegistry.createAddUserDefinedTableFunction("com.linkedin.tsar.hive.udf.ToJymbiiScores", ImmutableList.of("job_urn", "rank", "glmix_score", "global_model_score", "sentinel_score", "job_effect_score", "member_effect_score"), ImmutableList.of(SqlTypeName.VARCHAR, SqlTypeName.INTEGER, SqlTypeName.DOUBLE, SqlTypeName.DOUBLE, SqlTypeName.DOUBLE, SqlTypeName.DOUBLE, SqlTypeName.DOUBLE), OperandTypes.family(SqlTypeFamily.ARRAY, SqlTypeFamily.ARRAY));
        StaticHiveFunctionRegistry.addFunctionEntry("current_user", SqlStdOperatorTable.CURRENT_USER);
    }
}

