/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.rel2trino;

import com.google.common.base.Preconditions;
import com.linkedin.coral.common.HiveMetastoreClient;
import com.linkedin.coral.hive.hive2rel.HiveToRelConverter;
import com.linkedin.coral.trino.rel2trino.RelToTrinoConverter;
import java.util.Map;
import org.apache.calcite.rel.RelNode;

public class HiveToTrinoConverter {
    private final HiveToRelConverter hiveToRelConverter;
    private final RelToTrinoConverter relToTrinoConverter;

    public static HiveToTrinoConverter create(HiveMetastoreClient mscClient) {
        Preconditions.checkNotNull((Object)mscClient);
        HiveToRelConverter hiveToRelConverter = new HiveToRelConverter(mscClient);
        RelToTrinoConverter relToTrinoConverter = new RelToTrinoConverter();
        return new HiveToTrinoConverter(hiveToRelConverter, relToTrinoConverter);
    }

    public static HiveToTrinoConverter create(HiveMetastoreClient mscClient, Map<String, Boolean> configs) {
        Preconditions.checkNotNull((Object)mscClient);
        Preconditions.checkNotNull(configs);
        HiveToRelConverter hiveToRelConverter = new HiveToRelConverter(mscClient);
        RelToTrinoConverter relToTrinoConverter = new RelToTrinoConverter(configs);
        return new HiveToTrinoConverter(hiveToRelConverter, relToTrinoConverter);
    }

    private HiveToTrinoConverter(HiveToRelConverter hiveToRelConverter, RelToTrinoConverter relToTrinoConverter) {
        this.hiveToRelConverter = hiveToRelConverter;
        this.relToTrinoConverter = relToTrinoConverter;
    }

    public String toTrinoSql(String hiveSql) {
        RelNode rel = this.hiveToRelConverter.convertSql(hiveSql);
        return this.relToTrinoConverter.convert(rel);
    }

    public String toTrinoSql(String dbName, String viewName) {
        RelNode rel = this.hiveToRelConverter.convertView(dbName, viewName);
        return this.relToTrinoConverter.convert(rel);
    }
}

