/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.rel2trino;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.linkedin.coral.calcite.$internal.com.google.common.collect.ImmutableList;
import com.linkedin.coral.common.functions.FunctionFieldReferenceOperator;
import com.linkedin.coral.hive.hive2rel.rel.HiveUncollect;
import com.linkedin.coral.trino.rel2trino.Calcite2TrinoUDFConverter;
import com.linkedin.coral.trino.rel2trino.CoralToTrinoSqlCallConverter;
import com.linkedin.coral.trino.rel2trino.TrinoSqlDialect;
import com.linkedin.coral.trino.rel2trino.TrinoSqlRewriter;
import com.linkedin.coral.trino.rel2trino.functions.TrinoArrayTransformFunction;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Uncollect;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.rel2sql.RelToSqlConverter;
import org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;

public class RelToTrinoConverter
extends RelToSqlConverter {
    private Map<String, Boolean> configs = new HashMap<String, Boolean>();

    public RelToTrinoConverter() {
        super(TrinoSqlDialect.INSTANCE);
    }

    public RelToTrinoConverter(Map<String, Boolean> configs) {
        super(TrinoSqlDialect.INSTANCE);
        Preconditions.checkNotNull(configs);
        this.configs = configs;
    }

    public String convert(RelNode relNode) {
        RelNode rel = Calcite2TrinoUDFConverter.convertRel(relNode, this.configs);
        SqlNode sqlNode = this.convertToSqlNode(rel);
        SqlNode sqlNodeWithUDFOperatorConverted = sqlNode.accept(new CoralToTrinoSqlCallConverter(this.configs));
        return sqlNodeWithUDFOperatorConverted.accept(new TrinoSqlRewriter()).toSqlString(TrinoSqlDialect.INSTANCE).toString();
    }

    public SqlNode convertToSqlNode(RelNode relNode) {
        return this.visitChild(0, relNode).asStatement();
    }

    public SqlImplementor.Result visit(Window window) {
        return null;
    }

    @Override
    public SqlImplementor.Result visit(Project e) {
        e.getVariablesSet();
        SqlImplementor.Result x = this.visitChild(0, e.getInput());
        this.parseCorrelTable(e, x);
        if (RelToTrinoConverter.isStar(e.getChildExps(), e.getInput().getRowType(), e.getRowType())) {
            return x;
        }
        SqlImplementor.Builder builder = x.builder(e, SqlImplementor.Clause.SELECT);
        ArrayList<SqlNode> selectList = new ArrayList<SqlNode>();
        for (RexNode ref : e.getChildExps()) {
            SqlNode sqlExpr = builder.context.toSql(null, ref);
            RelDataTypeField targetField = e.getRowType().getFieldList().get(selectList.size());
            if (SqlUtil.isNullLiteral(sqlExpr, false) && !((RelDataType)targetField.getValue()).getSqlTypeName().equals((Object)SqlTypeName.NULL)) {
                sqlExpr = SqlStdOperatorTable.CAST.createCall(POS, sqlExpr, this.dialect.getCastSpec(targetField.getType()));
            }
            this.addSelect(selectList, sqlExpr, e.getRowType());
        }
        builder.setSelect(new SqlNodeList(selectList, POS));
        return builder.result();
    }

    @Override
    public SqlImplementor.Result visit(Uncollect e) {
        if (!this.isTrinoSupportedUnnest(e)) {
            throw new UnsupportedOperationException("Trino does not allow unnest a result of a queries");
        }
        SqlImplementor.Result x = this.visitChild(0, e.getInput());
        ArrayList<SqlNode> unnestOperands = new ArrayList<SqlNode>();
        for (RexNode unnestCol : ((Project)e.getInput()).getChildExps()) {
            if (!this.configs.getOrDefault("SUPPORT_LEGACY_UNNEST_ARRAY_OF_STRUCT", false).booleanValue() && e instanceof HiveUncollect && unnestCol.getType().getSqlTypeName().equals((Object)SqlTypeName.ARRAY) && unnestCol.getType().getComponentType().getSqlTypeName().equals((Object)SqlTypeName.ROW)) {
                RelRecordType transformDataType = new RelRecordType((List<RelDataTypeField>)ImmutableList.of(new RelDataTypeFieldImpl("wrapper_field", 0, unnestCol.getType().getComponentType())));
                TrinoArrayTransformFunction tranformFunction = new TrinoArrayTransformFunction(transformDataType);
                SqlNode fieldRef = x.qualifiedContext().toSql(null, unnestCol);
                String fieldRefString = fieldRef.toSqlString(TrinoSqlDialect.INSTANCE).getSql();
                SqlCharStringLiteral transformArgsLiteral = SqlLiteral.createCharString(String.format("%s, x -> ROW(x)", fieldRefString), POS);
                unnestOperands.add(tranformFunction.createCall(POS, transformArgsLiteral));
                continue;
            }
            unnestOperands.add(x.qualifiedContext().toSql(null, unnestCol));
        }
        SqlCall unnestNode = (e.withOrdinality ? SqlStdOperatorTable.UNNEST_WITH_ORDINALITY : SqlStdOperatorTable.UNNEST).createCall(POS, unnestOperands);
        List<SqlNode> asOperands = this.createAsFullOperands(e.getRowType(), unnestNode, x.neededAlias);
        SqlCall asNode = SqlStdOperatorTable.AS.createCall(POS, asOperands);
        return new SqlImplementor.Result(this, asNode, ImmutableList.of(SqlImplementor.Clause.FROM), null, e.getRowType(), (Map<String, RelDataType>)ImmutableMap.of((Object)x.neededAlias, (Object)e.getRowType()));
    }

    @Override
    public SqlImplementor.Result visit(TableScan e) {
        List<String> qualifiedName = e.getTable().getQualifiedName();
        if (qualifiedName.size() > 2) {
            qualifiedName = qualifiedName.subList(qualifiedName.size() - 2, qualifiedName.size());
        }
        SqlIdentifier identifier = new SqlIdentifier(qualifiedName, SqlParserPos.ZERO);
        return this.result(identifier, ImmutableList.of(SqlImplementor.Clause.FROM), e, null);
    }

    private boolean isTrinoSupportedUnnest(Uncollect uncollect) {
        if (!(uncollect.getInput() instanceof Project) || !(((Project)uncollect.getInput()).getInput() instanceof Values)) {
            return false;
        }
        Values values = (Values)((Project)uncollect.getInput()).getInput();
        if (values.getTuples().size() == 1 && ((ImmutableList)values.getTuples().get(0)).size() == 1) {
            RexLiteral val = (RexLiteral)((ImmutableList)values.getTuples().get(0)).get(0);
            return val.getValue().equals(new BigDecimal(0));
        }
        return false;
    }

    @Override
    public SqlImplementor.Result visit(Correlate e) {
        SqlImplementor.Result leftResult = this.visitChild(0, e.getLeft()).resetAlias(e.getCorrelVariable(), e.getLeft().getRowType());
        this.parseCorrelTable(e, leftResult);
        SqlImplementor.Result rightResult = this.visitChild(1, e.getRight()).resetAlias();
        SqlNode rightLateral = rightResult.node;
        if (rightLateral.getKind() != SqlKind.AS) {
            rightLateral = SqlStdOperatorTable.LATERAL.createCall(POS, rightLateral);
            rightLateral = SqlStdOperatorTable.AS.createCall(POS, rightLateral, new SqlIdentifier(rightResult.neededAlias, POS));
        }
        SqlJoin join = new SqlJoin(POS, leftResult.asFrom(), SqlLiteral.createBoolean(false, POS), JoinType.CROSS.symbol(POS), rightLateral, JoinConditionType.NONE.symbol(POS), null);
        return this.result(join, leftResult, rightResult);
    }

    @Override
    public SqlImplementor.Result visit(Values e) {
        SqlImplementor.Result originalResult = super.visit(e);
        return new SqlImplementor.Result(this, originalResult.node, originalResult.clauses, null, originalResult.neededType, originalResult.aliases);
    }

    @Override
    public SqlImplementor.Context aliasContext(Map<String, RelDataType> aliases, boolean qualified) {
        return new SqlImplementor.AliasContext((SqlDialect)TrinoSqlDialect.INSTANCE, aliases, qualified){

            @Override
            public SqlNode toSql(RexProgram program, RexNode rex) {
                if (rex.getKind() == SqlKind.FIELD_ACCESS) {
                    ArrayList<String> accessNames = new ArrayList<String>();
                    RexNode referencedExpr = rex;
                    while (referencedExpr.getKind() == SqlKind.FIELD_ACCESS) {
                        accessNames.add(((RexFieldAccess)referencedExpr).getField().getName());
                        referencedExpr = ((RexFieldAccess)referencedExpr).getReferenceExpr();
                    }
                    if (referencedExpr.getKind() == SqlKind.OTHER_FUNCTION) {
                        SqlNode functionCall = this.toSql(program, referencedExpr);
                        Collections.reverse(accessNames);
                        for (String accessName : accessNames) {
                            functionCall = FunctionFieldReferenceOperator.DOT.createCall(SqlParserPos.ZERO, functionCall, new SqlIdentifier(accessName, SqlImplementor.POS));
                        }
                        return functionCall;
                    }
                }
                return super.toSql(program, rex);
            }
        };
    }
}

