/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.writer;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.XxHash64;
import io.trino.array.IntBigArray;
import io.trino.spi.block.Block;
import io.trino.spi.block.VariableWidthBlock;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public class DictionaryBuilder {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(DictionaryBuilder.class);
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final float FILL_RATIO = 0.75f;
    private static final int EMPTY_SLOT = -1;
    private static final int NULL_POSITION = 0;
    private static final int EXPECTED_BYTES_PER_ENTRY = 32;
    private final IntBigArray blockPositionByHash = new IntBigArray();
    private int entryCount = 1;
    private SliceOutput sliceOutput;
    private int[] offsets;
    private int maxFill;
    private int hashMask;

    public DictionaryBuilder(int expectedSize) {
        Preconditions.checkArgument((expectedSize >= 0 ? 1 : 0) != 0, (Object)"expectedSize must not be negative");
        int expectedEntries = Math.min(expectedSize, 32768);
        int expectedBytes = expectedEntries * 32;
        this.sliceOutput = new DynamicSliceOutput(Math.min(expectedBytes, 0x7FFFFFF7));
        int hashSize = HashCommon.arraySize((int)expectedSize, (float)0.75f);
        this.maxFill = DictionaryBuilder.calculateMaxFill(hashSize);
        this.hashMask = hashSize - 1;
        this.offsets = new int[this.maxFill + 1];
        this.blockPositionByHash.ensureCapacity((long)hashSize);
        this.blockPositionByHash.fill(-1);
    }

    public long getSizeInBytes() {
        return (long)this.sliceOutput.size() + SizeOf.sizeOf((int[])this.offsets);
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.sliceOutput.getRetainedSize() + SizeOf.sizeOf((int[])this.offsets) + this.blockPositionByHash.sizeOf();
    }

    public Block getElementBlock() {
        boolean[] isNull = new boolean[this.entryCount];
        isNull[0] = true;
        return new VariableWidthBlock(this.entryCount, this.sliceOutput.slice(), this.offsets, Optional.of(isNull));
    }

    public void clear() {
        this.blockPositionByHash.fill(-1);
        int initialSize = Math.min((int)((double)this.sliceOutput.size() * 1.25), 0x7FFFFFF7);
        this.sliceOutput = new DynamicSliceOutput(initialSize);
        this.entryCount = 1;
        Arrays.fill(this.offsets, 0);
    }

    public int putIfAbsent(Block block, int position) {
        Objects.requireNonNull(block, "block must not be null");
        if (block.isNull(position)) {
            return 0;
        }
        long hashPosition = this.getHashPositionOfElement(block, position);
        int blockPosition = this.blockPositionByHash.get(hashPosition) != -1 ? this.blockPositionByHash.get(hashPosition) : this.addNewElement(hashPosition, block, position);
        Verify.verify((blockPosition != 0 ? 1 : 0) != 0);
        return blockPosition;
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    private long getHashPositionOfElement(Block block, int position) {
        Preconditions.checkArgument((!block.isNull(position) ? 1 : 0) != 0, (Object)"position is null");
        int length = block.getSliceLength(position);
        long hashPosition = this.getMaskedHash(block.hash(position, 0, length));
        int entryPosition;
        while ((entryPosition = this.blockPositionByHash.get(hashPosition)) != -1) {
            int entryOffset = this.offsets[entryPosition];
            int entryLength = this.offsets[entryPosition + 1] - entryOffset;
            if (entryLength == length && block.bytesEqual(position, 0, this.sliceOutput.getUnderlyingSlice(), entryOffset, entryLength)) {
                return hashPosition;
            }
            hashPosition = this.getMaskedHash(hashPosition + 1L);
        }
        return hashPosition;
    }

    private int addNewElement(long hashPosition, Block block, int position) {
        Preconditions.checkArgument((!block.isNull(position) ? 1 : 0) != 0, (Object)"position is null");
        int newElementPositionInBlock = this.entryCount++;
        int length = block.getSliceLength(position);
        block.writeSliceTo(position, 0, length, this.sliceOutput);
        this.offsets[this.entryCount] = this.sliceOutput.size();
        this.blockPositionByHash.set(hashPosition, newElementPositionInBlock);
        if (this.entryCount >= this.maxFill) {
            this.rehash(this.maxFill * 2);
        }
        return newElementPositionInBlock;
    }

    private void rehash(int size) {
        int newHashSize = HashCommon.arraySize((int)(size + 1), (float)0.75f);
        this.hashMask = newHashSize - 1;
        this.maxFill = DictionaryBuilder.calculateMaxFill(newHashSize);
        this.offsets = Arrays.copyOf(this.offsets, this.maxFill + 1);
        this.blockPositionByHash.ensureCapacity((long)newHashSize);
        this.blockPositionByHash.fill(-1);
        for (int entryPosition = 1; entryPosition < this.entryCount; ++entryPosition) {
            int entryOffset = this.offsets[entryPosition];
            int entryLength = this.offsets[entryPosition + 1] - entryOffset;
            long entryHashCode = XxHash64.hash((Slice)this.sliceOutput.getUnderlyingSlice(), (int)entryOffset, (int)entryLength);
            long hashPosition = this.getMaskedHash(entryHashCode);
            while (true) {
                int hashEntryIndex;
                if ((hashEntryIndex = this.blockPositionByHash.get(hashPosition)) == -1) break;
                hashPosition = this.getMaskedHash(hashPosition + 1L);
            }
            this.blockPositionByHash.set(hashPosition, entryPosition);
        }
    }

    private static int calculateMaxFill(int hashSize) {
        int maxFill = (int)Math.ceil((float)hashSize * 0.75f);
        if (maxFill == hashSize) {
            --maxFill;
        }
        return maxFill;
    }

    private long getMaskedHash(long rawHash) {
        return rawHash & (long)this.hashMask;
    }
}

