/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop.$internal.com.microsoft.azure.storage.blob;

import io.trino.hadoop.$internal.com.microsoft.azure.storage.StorageException;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.blob.BlobOutputStream;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.core.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LengthLimitingStream
extends BlobOutputStream {
    private final OutputStream wrappedStream;
    private long startOffset;
    private Long endOffset;
    private long position;
    private Long length;

    public LengthLimitingStream(OutputStream wrappedStream, long start, Long length) {
        this.wrappedStream = wrappedStream;
        this.startOffset = start;
        this.length = length;
        if (length != null) {
            this.endOffset = this.startOffset + (this.length - 1L);
        }
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        if (this.position < this.startOffset) {
            int discardBytes = (int)Math.min(this.startOffset - this.position, (long)length);
            offset += discardBytes;
            length -= discardBytes;
            this.position += (long)discardBytes;
        }
        if (this.endOffset != null) {
            length = (int)Math.min(this.endOffset + 1L - this.position, (long)length);
        }
        if (length > 0) {
            this.wrappedStream.write(data, offset, length);
            this.position += (long)length;
        }
    }

    @Override
    public void write(InputStream sourceStream, long writeLength) throws IOException, StorageException {
        Utility.writeToOutputStream(sourceStream, this, writeLength, false, false, null, null);
    }

    @Override
    public void flush() throws IOException {
        this.wrappedStream.flush();
    }

    @Override
    public void close() throws IOException {
    }
}

