/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hadoop;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.util.NativeCodeLoader;

public final class HadoopNative {
    private static boolean loaded = false;
    private static Throwable error = null;

    private HadoopNative() {
    }

    public static synchronized void requireHadoopNative() {
        if (loaded) {
            return;
        }
        if (error != null) {
            throw new RuntimeException("failed to load Hadoop native library", error);
        }
        try {
            HadoopNative.loadLibrary("hadoop");
            HadoopNative.loadLibrary("zstd");
            HadoopNative.setStatic(NativeCodeLoader.class.getDeclaredField("nativeCodeLoaded"), true);
            HadoopNative.loadAllCodecs();
            loaded = true;
        }
        catch (Throwable t) {
            error = t;
            throw new RuntimeException("failed to load Hadoop native library", error);
        }
    }

    private static void loadAllCodecs() {
        Configuration conf = new Configuration();
        CompressionCodecFactory factory = new CompressionCodecFactory(conf);
        for (Class<? extends CompressionCodec> clazz : CompressionCodecFactory.getCodecClasses(conf)) {
            CompressionCodec codec = factory.getCodecByClassName(clazz.getName());
            if (codec == null) {
                throw new RuntimeException("failed to load codec: " + clazz.getName());
            }
            codec.getDecompressorType();
        }
    }

    private static void setStatic(Field field, Object value) throws IllegalAccessException {
        field.setAccessible(true);
        field.set(null, value);
    }

    private static void loadLibrary(String name) throws IOException {
        String libraryPath = HadoopNative.getLibraryPath(name);
        URL url = HadoopNative.class.getResource(libraryPath);
        if (url == null) {
            throw new RuntimeException("library not found: " + libraryPath);
        }
        File file = File.createTempFile(name, null);
        file.deleteOnExit();
        try (InputStream in = url.openStream();){
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        System.load(file.getAbsolutePath());
    }

    private static String getLibraryPath(String name) {
        return "/nativelib/" + HadoopNative.getPlatform() + "/" + System.mapLibraryName(name);
    }

    private static String getPlatform() {
        String name = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        return (name + "-" + arch).replace(' ', '_');
    }
}

